/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.typecheck;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.chi.metamodel.chi.ConstantDeclaration;
import org.eclipse.escet.chi.metamodel.chi.Declaration;
import org.eclipse.escet.chi.metamodel.chi.EnumDeclaration;
import org.eclipse.escet.chi.metamodel.chi.EnumValue;
import org.eclipse.escet.chi.metamodel.chi.FunctionDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ModelDeclaration;
import org.eclipse.escet.chi.metamodel.chi.ProcessDeclaration;
import org.eclipse.escet.chi.metamodel.chi.Specification;
import org.eclipse.escet.chi.metamodel.chi.TypeDeclaration;
import org.eclipse.escet.chi.metamodel.chi.XperDeclaration;
import org.eclipse.escet.chi.metamodel.java.ChiConstructors;
import org.eclipse.escet.chi.typecheck.CheckContext;
import org.eclipse.escet.chi.typecheck.ChiTypeChecker;
import org.eclipse.escet.chi.typecheck.Message;
import org.eclipse.escet.chi.typecheck.symbols.ConstantSymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.EnumValueSymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.FunctionDefSymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.ModelDefSymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.ProcessDefSymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.SymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.TypeSymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.XperDefSymbolEntry;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public abstract class CheckSpecification {
    public static Specification transSpecification(Specification spec, ChiTypeChecker tchk) {
        CheckContext topCtxt = new CheckContext(tchk);
        topCtxt = topCtxt.newSymbolContext();
        List enums = Lists.list();
        List types = Lists.list();
        List constants = Lists.list();
        List functions = Lists.list();
        List processes = Lists.list();
        List models = Lists.list();
        List experiments = Lists.list();
        for (Declaration decl : spec.getDeclarations()) {
            SymbolEntry se;
            if (decl instanceof EnumDeclaration) {
                EnumDeclaration eDecl = (EnumDeclaration)decl;
                eDecl = CheckSpecification.transEnumDeclaration(eDecl, topCtxt);
                se = new TypeSymbolEntry((Declaration)eDecl, null);
                topCtxt.addSymbol(se);
                enums.add(se);
                for (EnumValue eVal : eDecl.getValues()) {
                    EnumValueSymbolEntry sv = new EnumValueSymbolEntry((TypeSymbolEntry)se, eVal, topCtxt);
                    topCtxt.addSymbol(sv);
                }
                continue;
            }
            if (decl instanceof TypeDeclaration) {
                TypeDeclaration tdef = (TypeDeclaration)decl;
                se = new TypeSymbolEntry((Declaration)tdef, topCtxt);
                topCtxt.addSymbol(se);
                types.add(se);
                continue;
            }
            if (decl instanceof ConstantDeclaration) {
                ConstantDeclaration cdef = (ConstantDeclaration)decl;
                se = new ConstantSymbolEntry(cdef, topCtxt);
                topCtxt.addSymbol(se);
                constants.add(se);
                continue;
            }
            if (decl instanceof FunctionDeclaration) {
                FunctionDeclaration fdef = (FunctionDeclaration)decl;
                se = new FunctionDefSymbolEntry(fdef, topCtxt);
                topCtxt.addSymbol(se);
                functions.add(se);
                continue;
            }
            if (decl instanceof ProcessDeclaration) {
                ProcessDeclaration pdef = (ProcessDeclaration)decl;
                se = new ProcessDefSymbolEntry(pdef, topCtxt);
                topCtxt.addSymbol(se);
                processes.add(se);
                continue;
            }
            if (decl instanceof ModelDeclaration) {
                ModelDeclaration mdef = (ModelDeclaration)decl;
                se = new ModelDefSymbolEntry(mdef, topCtxt);
                topCtxt.addSymbol(se);
                models.add(se);
                continue;
            }
            if (!(decl instanceof XperDeclaration)) continue;
            XperDeclaration xdef = (XperDeclaration)decl;
            se = new XperDefSymbolEntry(xdef, topCtxt);
            topCtxt.addSymbol(se);
            experiments.add(se);
        }
        List newDecls = Lists.list();
        for (SymbolEntry se : enums) {
            if (!CheckSpecification.doTypecheck(se)) continue;
            newDecls.add(((TypeSymbolEntry)se).getEnumTypeDeclaration());
        }
        for (SymbolEntry se : types) {
            if (!CheckSpecification.doTypecheck(se)) continue;
            newDecls.add(((TypeSymbolEntry)se).getTypeDeclaration());
        }
        for (SymbolEntry se : constants) {
            if (!CheckSpecification.doTypecheck(se)) continue;
            newDecls.add(((ConstantSymbolEntry)se).getConstant());
        }
        for (SymbolEntry se : functions) {
            if (!CheckSpecification.doTypecheck(se)) continue;
            newDecls.add(((FunctionDefSymbolEntry)se).getFunction());
        }
        for (SymbolEntry se : processes) {
            if (!CheckSpecification.doTypecheck(se)) continue;
            newDecls.add(((ProcessDefSymbolEntry)se).getProcess());
        }
        for (SymbolEntry se : models) {
            if (!CheckSpecification.doTypecheck(se)) continue;
            newDecls.add(((ModelDefSymbolEntry)se).getModel());
        }
        for (SymbolEntry se : experiments) {
            if (!CheckSpecification.doTypecheck(se)) continue;
            newDecls.add(((XperDefSymbolEntry)se).getXper());
        }
        topCtxt.checkSymbolUsage();
        return ChiConstructors.newSpecification((List)newDecls);
    }

    private static boolean doTypecheck(SymbolEntry se) {
        try {
            se.fullTypeCheck();
            return true;
        }
        catch (SemanticException e) {
            return false;
        }
    }

    private static EnumDeclaration transEnumDeclaration(EnumDeclaration decl, CheckContext ctxt) {
        List newValues = Lists.list();
        Map uniq = Maps.map();
        for (EnumValue ev : decl.getValues()) {
            String val = ev.getName();
            EnumValue prev = (EnumValue)uniq.get(val);
            if (prev != null) {
                ctxt.addError(Message.ENUM_VALUE_DOUBLE_DEFINED, prev.getPosition(), val);
                ctxt.addError(Message.ENUM_VALUE_DOUBLE_DEFINED, ev.getPosition(), val);
                throw new SemanticException();
            }
            uniq.put(val, ev);
            newValues.add(ChiConstructors.newEnumValue((String)val, (Position)PositionUtils.copyPosition((PositionObject)ev)));
        }
        return ChiConstructors.newEnumDeclaration((String)decl.getName(), (Position)PositionUtils.copyPosition((PositionObject)decl), (List)newValues);
    }
}

