/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.postchk;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFile;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFor;
import org.eclipse.escet.cif.metamodel.cif.print.PrintForKind;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class CifPrintPostChecker {
    private CifPrintPostChecker() {
    }

    public static void check(Specification spec, CifPostCheckEnv env) {
        CifPrintPostChecker.checkComponent((ComplexComponent)spec, env, null);
    }

    private static void checkComponent(ComplexComponent comp, CifPostCheckEnv env, PrintFile printFile) {
        for (IoDecl ioDecl : comp.getIoDecls()) {
            if (!(ioDecl instanceof PrintFile)) continue;
            printFile = (PrintFile)ioDecl;
            break;
        }
        for (IoDecl ioDecl : comp.getIoDecls()) {
            try {
                if (!(ioDecl instanceof Print)) continue;
                CifPrintPostChecker.checkPrint((Print)ioDecl, env, printFile);
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                CifPrintPostChecker.checkComponent((ComplexComponent)child, env, printFile);
            }
        }
    }

    private static void checkPrint(Print print, CifPostCheckEnv env, PrintFile printFile) {
        if (print.getFors().isEmpty()) {
            return;
        }
        Map kindToPosMap = Maps.map();
        for (PrintFor printFor : print.getFors()) {
            Object posList = (List)kindToPosMap.get(printFor.getKind());
            if (posList == null) {
                posList = Lists.list();
                kindToPosMap.put(printFor.getKind(), posList);
            }
            posList.add(printFor);
        }
        Set entries = kindToPosMap.entrySet();
        for (Map.Entry entry : entries) {
            Object fors;
            PrintForKind kind = (PrintForKind)entry.getKey();
            if (kind == PrintForKind.NAME || (fors = (List)entry.getValue()).size() < 2) continue;
            Iterator iterator = fors.iterator();
            while (iterator.hasNext()) {
                PrintFor printFor = (PrintFor)iterator.next();
                String txt = Strings.fmt((String)"\"%s\"", (Object[])new Object[]{kind.name().toLowerCase(Locale.US)});
                env.addProblem(ErrMsg.PRINT_DUPL_FOR, printFor.getPosition(), txt);
            }
        }
        List list = (List)kindToPosMap.get(PrintForKind.EVENT);
        List nameFors = (List)kindToPosMap.get(PrintForKind.NAME);
        if (list != null && nameFors != null) {
            Assert.check((!list.isEmpty() ? 1 : 0) != 0);
            Assert.check((!nameFors.isEmpty() ? 1 : 0) != 0);
            for (PrintFor printFor : nameFors) {
                String txt = Strings.fmt((String)"\"event\" (all events) and \"%s\" (specific event)", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)printFor.getEvent())});
                env.addProblem(ErrMsg.PRINT_DUPL_FOR, printFor.getPosition(), txt);
            }
        }
        if (nameFors != null && nameFors.size() > 1) {
            Map eventForMap = Maps.map();
            for (PrintFor printFor : nameFors) {
                EventExpression eventRef = (EventExpression)printFor.getEvent();
                Event event = eventRef.getEvent();
                PrintFor duplFor = (PrintFor)eventForMap.get(event);
                if (duplFor == null) {
                    eventForMap.put(event, printFor);
                    continue;
                }
                String txt = Strings.fmt((String)"event \"%s\"", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)event)});
                env.addProblem(ErrMsg.PRINT_DUPL_FOR, printFor.getPosition(), txt);
                env.addProblem(ErrMsg.PRINT_DUPL_FOR, duplFor.getPosition(), txt);
            }
        }
    }
}

