/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.io;

import java.io.IOException;
import org.eclipse.escet.chi.runtime.data.io.ChiFileHandle;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.exceptions.InputOutputException;

public class ChiStdioFile
extends ChiFileHandle {
    private String outBuffer = "";

    public ChiStdioFile(String operations) {
        super(null, operations);
    }

    private void ensureReadAllowed() {
        if (!this.operations.equals("r")) {
            String msg = "Console is not opened for reading.";
            throw new InputOutputException(msg);
        }
    }

    private void ensureWriteAllowed() {
        if (!this.operations.equals("w")) {
            String msg = "Console is not opened for writing.";
            throw new InputOutputException(msg);
        }
    }

    @Override
    public int read() {
        this.ensureReadAllowed();
        AppStreams streams = AppEnv.getStreams();
        try {
            return streams.in.read();
        }
        catch (IOException e) {
            String msg = "Console read failed";
            throw new InputOutputException(msg, (Throwable)e);
        }
    }

    @Override
    public void write(String data) {
        int i;
        this.ensureWriteAllowed();
        this.outBuffer = String.valueOf(this.outBuffer) + data;
        while ((i = this.outBuffer.indexOf(10)) >= 0) {
            if (OutputProvider.doout()) {
                OutputProvider.out((String)this.outBuffer.substring(0, i));
            }
            this.outBuffer = this.outBuffer.substring(i + 1);
        }
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public void flush() {
        if (this.operations.equals("w") && !this.outBuffer.isEmpty()) {
            if (OutputProvider.doout()) {
                OutputProvider.out((String)this.outBuffer);
            }
            this.outBuffer = "";
        }
    }

    @Override
    public void markStream(int count) {
        this.ensureReadAllowed();
        AppStreams streams = AppEnv.getStreams();
        try {
            streams.in.mark(count);
        }
        catch (IOException e) {
            String msg = "Console marking failed";
            throw new InputOutputException(msg, (Throwable)e);
        }
    }

    @Override
    public void resetStream() {
        this.ensureReadAllowed();
        AppStreams streams = AppEnv.getStreams();
        try {
            streams.in.reset();
        }
        catch (IOException e) {
            String msg = "Console resetting failed";
            throw new InputOutputException(msg, (Throwable)e);
        }
    }
}

