/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data;

import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.common.java.Strings;

public class DataSupport {
    private DataSupport() {
    }

    private static int normalizeIndex(int value, String name, int length, boolean exclusive) {
        int offset;
        int n = offset = exclusive ? 1 : 0;
        if (value >= length + offset) {
            String msg = Strings.fmt((String)"%s is out of range, index is %d while the length of the string is %d (maximum index is %d).", (Object[])new Object[]{name, value, length, length + offset - 1});
            throw new ChiSimulatorException(msg);
        }
        if (value < 0 && (value += length) + offset < 0) {
            String msg = Strings.fmt((String)"%s is out of range, value is %d, while the lowest allowed value is %d.", (Object[])new Object[]{name, value - length, -(length + offset)});
            throw new ChiSimulatorException(msg);
        }
        return value;
    }

    public static String stringProjection(String str, int value) {
        value = DataSupport.normalizeIndex(value, "Index of string projection", str.length(), false);
        return str.substring(value, value + 1);
    }

    /*
     * Unable to fully structure code
     */
    public static String stringSlice(String str, int start, int end, int step) {
        block6: {
            start = DataSupport.normalizeIndex(start, "Start index of string slice", str.length(), false);
            end = DataSupport.normalizeIndex(end, "End index of string slice", str.length(), true);
            if (step == 0) {
                msg = "Step size of string slice must be non-zero.";
                throw new ChiSimulatorException(msg);
            }
            if (step == 1) {
                if (start == 0 && end == str.length()) {
                    return str;
                }
                if (start <= end) {
                    return str.substring(start, end);
                }
            }
            result = new StringBuilder(2 + Math.abs(start - end) / Math.abs(step));
            if (step <= 0) ** GOTO lbl22
            while (start < end) {
                result.append(str.substring(start, start + 1));
                start += step;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                result.append(str.substring(start, start + 1));
                start += step;
lbl22:
                // 2 sources

                ** while (start > end)
            }
        }
        return result.toString();
    }
}

