/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.options;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.escet.cif.datasynth.settings.BddSimplify;
import org.eclipse.escet.cif.datasynth.settings.CifDataSynthesisSettingsDefaults;
import org.eclipse.escet.common.app.framework.options.EnumSetOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class BddSimplifyOption
extends EnumSetOption<BddSimplify> {
    public BddSimplifyOption() {
        super("BDD predicate simplify", "Specify comma separated names of the desired BDD predicate simplifications to perform. Specify \"guards-plants\" to simplify supervisor guards wrt plant guards, \"guards-req-auts\" to simplify supervisor guards wrt state/event exclusion requirement invariants derived from the requirement automata, \"guard-se-excl-plant-invs\" to simplify supervisor guards wrt state/event exclusion plant invariants from the input specification, \"guards-se-excl-req-invs\" to simplify supervisor guards wrt state/event exclusion requirement invariants from the input specification, \"guards-state-plant-invs\" to simplify supervisor guards wrt state plant invariants from the input specification, \"guards-state-req-invs\" to simplify supervisor guards wrt state requirement invariants from the input specification, \"guards-ctrl-beh\" to simplify supervisor guards wrt controlled behavior, \"initial-unctrl\" to simplify the initialization predicate of the controlled system wrt the initialization predicate of the uncontrolled system, and/or \"initial-state-plant-invs\" to simplify the initialization predicate of the controlled system wrt the state plant invariants. Prefix a name with \"+\" to add it on top of the defaults, or with \\\"-\\\" to remove it from the defaults. By default, all simplifications are enabled.", null, "bdd-simplify", "SIMPLIFICATION", (EnumSet)CifDataSynthesisSettingsDefaults.BDD_SIMPLIFICATIONS_DEFAULT.clone(), true, "The desired BDD predicate simplifications to perform.", BddSimplify.class);
    }

    protected String getDialogText(BddSimplify simplification) {
        switch (simplification) {
            case GUARDS_PLANTS: {
                return "Supervisor guards wrt their plant guards.";
            }
            case GUARDS_REQ_AUTS: {
                return "Supervisor guards wrt state/event exclusion requirement invariants derived from the requirement automata.";
            }
            case GUARDS_SE_EXCL_PLANT_INVS: {
                return "Supervisor guards wrt state/event exclusion plant invariants from the input specification.";
            }
            case GUARDS_SE_EXCL_REQ_INVS: {
                return "Supervisor guards wrt state/event exclusion requirement invariants from the input specification.";
            }
            case GUARDS_STATE_PLANT_INVS: {
                return "Supervisor guards wrt state plant invariants from the input specification.";
            }
            case GUARDS_STATE_REQ_INVS: {
                return "Supervisor guards wrt state requirement invariants from the input specification.";
            }
            case GUARDS_CTRL_BEH: {
                return "Supervisor guards wrt controlled behavior.";
            }
            case INITIAL_UNCTRL: {
                return "Initialization predicate of the controlled system wrt the initialization predicate of the uncontrolled system.";
            }
            case INITIAL_STATE_PLANT_INVS: {
                return "Initialization predicate of the controlled system wrt the state plant invariants.";
            }
        }
        throw new RuntimeException("Unknown simplification: " + String.valueOf((Object)simplification));
    }

    public static Set<BddSimplify> getSimplifications() {
        return (Set)Options.get(BddSimplifyOption.class);
    }
}

