/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.Arrays;
import java.util.List;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public record ExprCodeGeneratorResult(List<ExtraMethod> extraMethods, String exprCode, CifType type) {
    private static final String METHOD_BASE_NAME = "evalExpression";
    private static final int LIMIT = 100000;

    public ExprCodeGeneratorResult {
        Assert.check((exprCode.length() < 100000 ? 1 : 0) != 0);
    }

    public ExprCodeGeneratorResult(String exprCode, CifType type) {
        this(Lists.list(), exprCode, type);
    }

    public static ExprCodeGeneratorResult merge(String mergeFormatString, CifType type, CifCompilerContext ctxt, ExprCodeGeneratorResult ... results) {
        return ExprCodeGeneratorResult.merge(mergeFormatString, type, ctxt, Arrays.asList(results));
    }

    /*
     * Unable to fully structure code
     */
    public static ExprCodeGeneratorResult merge(String mergeFormatString, CifType type, CifCompilerContext ctxt, List<ExprCodeGeneratorResult> results) {
        if (!results.isEmpty()) ** GOTO lbl16
        return new ExprCodeGeneratorResult(Strings.fmt((String)mergeFormatString, (Object[])new Object[0]), type);
lbl-1000:
        // 1 sources

        {
            indexLargest = ExprCodeGeneratorResult.getLargestResult(results);
            largest = results.get(indexLargest);
            newLargest = ExprCodeGeneratorResult.createMethod(largest, ctxt);
            Assert.check((boolean)(newLargest.exprCode().length() < largest.exprCode().length()));
            results.set(indexLargest, newLargest);
            index = indexLargest + 1;
            while (index < results.size()) {
                if (results.get(index).equals(largest)) {
                    results.set(index, newLargest);
                }
                ++index;
            }
lbl16:
            // 2 sources

            ** while (!ExprCodeGeneratorResult.areUnderTheLimit(results, (int)mergeFormatString.length()))
        }
lbl17:
        // 1 sources

        exprText = Strings.fmt((String)mergeFormatString, (Object[])results.toArray(new ExprCodeGeneratorResult[results.size()]));
        mergedExtraMethods = Lists.list();
        seen = Sets.set();
        for (ExprCodeGeneratorResult result : results) {
            if (!seen.add(result)) continue;
            mergedExtraMethods.addAll(result.extraMethods());
        }
        return new ExprCodeGeneratorResult(mergedExtraMethods, exprText, type);
    }

    public void addExtraMethods(CodeBox c) {
        for (ExtraMethod extraMethod : this.extraMethods) {
            extraMethod.addExtraMethod(c);
        }
    }

    private static ExprCodeGeneratorResult createMethod(ExprCodeGeneratorResult result, CifCompilerContext ctxt) {
        Assert.notNull((Object)result.type());
        List<ExtraMethod> newSubExprs = result.extraMethods();
        String methodName = Strings.fmt((String)"%s%d", (Object[])new Object[]{METHOD_BASE_NAME, ctxt.exprCodeGenExtraMethodCounter.getAndIncrement()});
        newSubExprs.add(new ExtraMethod(result.exprCode(), methodName, TypeCodeGenerator.gencodeType(result.type(), ctxt)));
        return new ExprCodeGeneratorResult(newSubExprs, Strings.fmt((String)"%s(state)", (Object[])new Object[]{methodName}), result.type());
    }

    private static boolean areUnderTheLimit(List<ExprCodeGeneratorResult> results, int mergeFormatStringLength) {
        int total = mergeFormatStringLength;
        for (ExprCodeGeneratorResult result : results) {
            total += result.exprCode.length();
        }
        return total < 100000;
    }

    private static int getLargestResult(List<ExprCodeGeneratorResult> results) {
        Assert.check((!results.isEmpty() ? 1 : 0) != 0);
        int largestSize = results.get((int)0).exprCode.length();
        int largestIndex = 0;
        int i = 1;
        while (i < results.size()) {
            if (results.get((int)i).exprCode.length() > largestSize) {
                largestSize = results.get((int)i).exprCode.length();
                largestIndex = i;
            }
            ++i;
        }
        return largestIndex;
    }

    @Override
    public String toString() {
        return this.exprCode;
    }

    public record ExtraMethod(String bodyCode, String name, String type) {
        public void addExtraMethod(CodeBox c) {
            c.add();
            c.add("private static %s %s(State state) {", new Object[]{this.type, this.name});
            c.indent();
            c.add("return %s;", new Object[]{this.bodyCode});
            c.dedent();
            c.add("}");
        }
    }
}

