/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class VarDiscOnlyStaticEvalInitCheck
extends CifCheck {
    protected void preprocessDiscVariable(DiscVariable var, CifCheckViolations violations) {
        EObject parent = var.eContainer();
        if (!(parent instanceof ComplexComponent)) {
            return;
        }
        VariableValue values = var.getValue();
        if (values == null) {
            return;
        }
        for (Expression value : values.getValues()) {
            if (!CifValueUtils.hasSingleValue((Expression)value, (boolean)true, (boolean)true)) {
                violations.add((PositionObject)value, "Discrete variable has an initial value that cannot be evaluated statically", new Object[0]);
                continue;
            }
            try {
                CifEvalUtils.eval((Expression)value, (boolean)true);
            }
            catch (CifEvalException e) {
                Expression reportExpr = e.expr != null ? e.expr : value;
                violations.add((PositionObject)reportExpr, "Discrete variable has an initial value that cannot be evaluated statically, as evaluating it results in an evaluation error", new Object[0]);
            }
        }
    }
}

