/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers;

import java.util.List;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.checkers.CifChecker;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;

public class CifPreconditionChecker
extends CifChecker {
    public CifPreconditionChecker(Termination termination, List<CifCheck> preconditions) {
        super(termination, preconditions);
    }

    public CifPreconditionChecker(Termination termination, CifCheck ... preconditions) {
        super(termination, preconditions);
    }

    public void reportPreconditionViolations(Specification spec, String absSpecPath, String toolName) {
        CifCheckViolations violations = this.check(spec, absSpecPath);
        if (violations.hasViolations()) {
            String incompleteTxt = "";
            if (violations.isIncomplete()) {
                incompleteTxt = " (checking was prematurely terminated, so the report below may be incomplete)";
            }
            List lines = Lists.list();
            lines.add(toolName + Strings.fmt((String)" failed due to unsatisfied preconditions%s:", (Object[])new Object[]{incompleteTxt}));
            lines.addAll(violations.createReport());
            throw new UnsupportedException(String.join((CharSequence)"\n", lines));
        }
    }
}

