/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.varorder.orderers;

import java.util.List;
import org.eclipse.escet.cif.bdd.varorder.graph.Graph;
import org.eclipse.escet.cif.bdd.varorder.graph.Node;
import org.eclipse.escet.cif.bdd.varorder.graph.algos.PseudoPeripheralNodeFinder;
import org.eclipse.escet.cif.bdd.varorder.graph.algos.PseudoPeripheralNodeFinderKind;
import org.eclipse.escet.cif.bdd.varorder.graph.algos.WeightedCuthillMcKeeNodeOrderer;
import org.eclipse.escet.cif.bdd.varorder.helper.RelationsKind;
import org.eclipse.escet.cif.bdd.varorder.helper.RepresentationKind;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrder;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrdererData;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrdererEffect;
import org.eclipse.escet.cif.bdd.varorder.orderers.VarOrderer;
import org.eclipse.escet.common.java.Strings;

public class WeightedCuthillMcKeeVarOrderer
extends VarOrderer {
    private final PseudoPeripheralNodeFinderKind nodeFinderKind;
    private final RelationsKind relationsKind;
    private final VarOrdererEffect effect;

    public WeightedCuthillMcKeeVarOrderer(PseudoPeripheralNodeFinderKind nodeFinderKind, RelationsKind relationsKind, VarOrdererEffect effect) {
        this.nodeFinderKind = nodeFinderKind;
        this.relationsKind = relationsKind;
        this.effect = effect;
    }

    @Override
    public VarOrdererData order(VarOrdererData inputData, boolean dbgEnabled, int dbgLevel) {
        Graph graph = inputData.helper.getGraph(this.relationsKind);
        if (dbgEnabled) {
            inputData.helper.dbg(dbgLevel, "Applying Weighted Cuthill-McKee algorithm:", new Object[0]);
            inputData.helper.dbg(dbgLevel + 1, "Node finder: %s", this.enumValueToParserArg(this.nodeFinderKind));
            inputData.helper.dbg(dbgLevel + 1, "Relations: %s", this.enumValueToParserArg(this.relationsKind));
            inputData.helper.dbg(dbgLevel + 1, "Effect: %s", this.enumValueToParserArg(this.effect));
            inputData.helper.dbgRepresentation(dbgLevel + 1, RepresentationKind.GRAPH, this.relationsKind);
            inputData.helper.dbg();
        }
        if (graph.edgeCount() == 0L) {
            if (dbgEnabled) {
                inputData.helper.dbg(dbgLevel + 1, "Skipping algorithm: no graph edges.", new Object[0]);
            }
            return inputData;
        }
        if (dbgEnabled) {
            inputData.helper.dbgMetricsForVarOrder(dbgLevel + 1, inputData.varOrder.getOrderedVars(), "before", this.relationsKind);
        }
        PseudoPeripheralNodeFinder nodeFinder = this.nodeFinderKind.create();
        List<Node> order = new WeightedCuthillMcKeeNodeOrderer(nodeFinder).orderNodes(graph);
        if (dbgEnabled) {
            inputData.helper.dbgMetricsForNodeOrder(dbgLevel + 1, order, "after", this.relationsKind);
        }
        return new VarOrdererData(inputData, VarOrder.createFromOrderedVars(inputData.helper.reorderForNodeOrder(order)), this.effect);
    }

    public String toString() {
        return Strings.fmt((String)"weighted-cm(node-finder=%s, relations=%s, effect=%s)", (Object[])new Object[]{this.enumValueToParserArg(this.nodeFinderKind), this.enumValueToParserArg(this.relationsKind), this.enumValueToParserArg(this.effect)});
    }
}

