/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.varorder.orderers;

import java.util.List;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrder;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrdererData;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrdererEffect;
import org.eclipse.escet.cif.bdd.varorder.orderers.VarOrderer;

public class CustomVarOrderer
extends VarOrderer {
    private final VarOrder order;
    private final VarOrdererEffect effect;

    public CustomVarOrderer(VarOrder order, VarOrdererEffect effect) {
        this.order = order;
        this.effect = effect;
    }

    @Override
    public VarOrdererData order(VarOrdererData inputData, boolean dbgEnabled, int dbgLevel) {
        if (dbgEnabled) {
            inputData.helper.dbg(dbgLevel, "Applying a custom variable order:", new Object[0]);
            inputData.helper.dbg(dbgLevel + 1, "Order: %s", this.getOrderText());
            inputData.helper.dbg(dbgLevel + 1, "Effect: %s", this.enumValueToParserArg(this.effect));
        }
        return new VarOrdererData(inputData, this.order, this.effect);
    }

    private String getOrderText() {
        StringBuilder txt = new StringBuilder();
        List<List<CifBddVariable>> groups = this.order.getVarOrder();
        int i = 0;
        while (i < groups.size()) {
            List<CifBddVariable> group = groups.get(i);
            if (i > 0) {
                txt.append(";");
            }
            int j = 0;
            while (j < group.size()) {
                if (j > 0) {
                    txt.append(",");
                }
                CifBddVariable var = group.get(j);
                txt.append(var.rawName);
                ++j;
            }
            ++i;
        }
        return txt.toString();
    }

    public String toString() {
        StringBuilder txt = new StringBuilder();
        txt.append("custom(effect=");
        txt.append(this.enumValueToParserArg(this.effect));
        txt.append(", order=\"");
        txt.append(this.getOrderText());
        txt.append("\")");
        return txt.toString();
    }
}

