/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion.preconditions;

import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifInternalFuncUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifToBddVarOnlySpecificTypesCheck
extends CifCheckNoCompDefInst {
    protected void preprocessDiscVariable(DiscVariable discVar, CifCheckViolations violations) {
        if (CifInternalFuncUtils.isFuncParam((DiscVariable)discVar)) {
            this.checkType(discVar.getType(), "Function parameter has", violations);
        } else if (CifInternalFuncUtils.isFuncLocalVar((DiscVariable)discVar)) {
            this.checkType(discVar.getType(), "Function local variable has", violations);
        } else {
            this.checkType(discVar.getType(), "Discrete variable has", violations);
        }
    }

    protected void preprocessInputVariable(InputVariable inputVar, CifCheckViolations violations) {
        this.checkType(inputVar.getType(), "Input variable has", violations);
    }

    protected void preprocessInternalFunction(InternalFunction func, CifCheckViolations violations) {
        for (CifType returnType : func.getReturnTypes()) {
            this.checkType(returnType, "Function return type is", violations);
        }
    }

    private void checkType(CifType type, String prefix, CifCheckViolations violations) {
        CifType normType = CifTypeUtils.normalizeType((CifType)type);
        if (!(normType instanceof BoolType)) {
            if (normType instanceof IntType) {
                IntType intType = (IntType)normType;
                if (CifTypeUtils.isRangeless((IntType)intType)) {
                    violations.add((PositionObject)type, prefix + " a rangeless integer type", new Object[0]);
                } else {
                    long count = CifTypeUtils.getPossibleValuesCount((IntType)intType);
                    if (count > Integer.MAX_VALUE) {
                        violations.add((PositionObject)type, prefix + " an integer type with more than 2,147,483,647 possible values", new Object[0]);
                    }
                }
            } else if (!(normType instanceof EnumType)) {
                violations.add((PositionObject)type, prefix + " a type that is not a boolean, integer or enumeration type", new Object[0]);
            }
        }
    }
}

