/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.statements.seq;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.statements.seq.SeqCode;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.AssignmentNode;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.DictionaryProjection;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.LhsHead;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.LhsUnpacking;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.LhsVariableReference;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.ListProjection;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.RhsExpression;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.RhsVarName;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.TupleProjection;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.AssignmentStatement;
import org.eclipse.escet.chi.metamodel.chi.BinaryExpression;
import org.eclipse.escet.chi.metamodel.chi.DictType;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.FieldReference;
import org.eclipse.escet.chi.metamodel.chi.ListType;
import org.eclipse.escet.chi.metamodel.chi.TupleExpression;
import org.eclipse.escet.chi.metamodel.chi.TupleType;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.VariableReference;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class AssignmentConversions {
    private AssignmentConversions() {
    }

    public static SeqCode convertAssignment(AssignmentStatement stat, CodeGeneratorContext ctxt, JavaFile currentClass) {
        List<LhsHead> asgs = AssignmentConversions.makeSingleAssignments(stat.getLhs(), stat.getRhs());
        List<String> lines = AssignmentConversions.generateAssignments(asgs, ctxt, currentClass);
        return new SeqCode(lines, (PositionObject)stat);
    }

    public static List<String> convertAssignment(Expression lhs, String rhsName, Type rhsType, CodeGeneratorContext ctxt, JavaFile currentClass) {
        RhsVarName rhs = new RhsVarName(rhsName, rhsType);
        List asgs = Lists.list((Object)AssignmentConversions.buildAssignment(lhs, rhs));
        List<String> lines = AssignmentConversions.generateAssignments(asgs, ctxt, currentClass);
        return lines;
    }

    private static List<LhsHead> makeSingleAssignments(Expression lhs, Expression rhs) {
        if (lhs instanceof TupleExpression && rhs instanceof TupleExpression) {
            EList tlf = ((TupleExpression)lhs).getFields();
            EList trf = ((TupleExpression)rhs).getFields();
            Assert.check((tlf.size() == trf.size() ? 1 : 0) != 0);
            List singles = Lists.list();
            int i = 0;
            while (i < tlf.size()) {
                singles.addAll(AssignmentConversions.makeSingleAssignments((Expression)tlf.get(i), (Expression)trf.get(i)));
                ++i;
            }
            return singles;
        }
        RhsExpression rhsAsg = new RhsExpression(rhs);
        return Lists.list((Object)AssignmentConversions.buildAssignment(lhs, rhsAsg));
    }

    /*
     * Unable to fully structure code
     */
    private static LhsHead buildAssignment(Expression lhs, AssignmentNode rhs) {
        if (!(lhs instanceof TupleExpression)) ** GOTO lbl22
        tup = (TupleExpression)lhs;
        lhsUnpacked = new LhsUnpacking();
        for (Expression elm : tup.getFields()) {
            lhsUnpacked.elements.add(AssignmentConversions.buildAssignment(elm, rhs));
        }
        return lhsUnpacked;
lbl-1000:
        // 1 sources

        {
            bep = (BinaryExpression)lhs;
            tp = TypeIDCreation.dropTypeReferences(bep.getLeft().getType());
            if (tp instanceof TupleType) {
                rhs = new TupleProjection((TupleType)tp, (FieldReference)bep.getRight(), rhs);
                lhs = bep.getLeft();
                continue;
            }
            if (tp instanceof ListType) {
                rhs = new ListProjection((ListType)tp, bep.getRight(), rhs);
                lhs = bep.getLeft();
                continue;
            }
            Assert.check((boolean)(tp instanceof DictType));
            rhs = new DictionaryProjection((DictType)tp, bep.getRight(), rhs);
            lhs = bep.getLeft();
lbl22:
            // 4 sources

            ** while (lhs instanceof BinaryExpression)
        }
lbl23:
        // 1 sources

        Assert.check((boolean)(lhs instanceof VariableReference));
        ref = (VariableReference)lhs;
        return new LhsVariableReference(ref.getVariable(), rhs);
    }

    private static List<String> generateAssignments(List<LhsHead> asgs, CodeGeneratorContext ctxt, JavaFile currentClass) {
        Set assignedVars = Sets.set();
        for (LhsHead single : asgs) {
            single.getLhsRootVariables(assignedVars);
        }
        List lines = Lists.list();
        for (LhsHead single : asgs) {
            single.saveUsedValues(single.isOneAssignment(), assignedVars, ctxt, currentClass, lines);
        }
        for (LhsHead single : asgs) {
            single.assignValue(null, ctxt, currentClass, lines);
        }
        if (!lines.isEmpty()) {
            lines.add("");
        }
        return lines;
    }
}

