/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.javascript.typeinfos;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.javascript.JavaScriptDataValue;
import org.eclipse.escet.cif.codegen.typeinfos.RangeCheckErrorLevelText;
import org.eclipse.escet.cif.codegen.typeinfos.TupleTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.Strings;

public class JavaScriptTupleTypeInfo
extends TupleTypeInfo {
    public JavaScriptTupleTypeInfo(CifType cifType, TypeInfo[] fieldTIs) {
        super(cifType, fieldTIs);
    }

    @Override
    public String getTargetType() {
        return "CifTuple_" + this.getTypeName();
    }

    @Override
    public int getSize() {
        return this.childInfos.length;
    }

    @Override
    public void generateCode(CodeContext ctxt) {
        String className = this.getTargetType();
        String cifTypeText = CifTextUtils.typeToStr((CifType)this.cifType);
        MemoryCodeBox code = ctxt.makeCodeBox(3);
        code.add();
        code.add("/** Tuple class for CIF tuple type representative \"%s\". */", new Object[]{cifTypeText});
        code.add("class %s {", new Object[]{className});
        code.indent();
        String[] names = new String[this.childInfos.length];
        CharSequence[] paramTxts = new String[this.childInfos.length];
        int i = 0;
        while (i < names.length) {
            names[i] = Strings.fmt((String)"_field%d", (Object[])new Object[]{i});
            paramTxts[i] = Strings.fmt((String)"%s", (Object[])new Object[]{names[i]});
            ++i;
        }
        i = 0;
        while (i < names.length) {
            code.add("/** The %s field. */", new Object[]{Numbers.toOrdinal((int)(i + 1))});
            code.add("%s;", new Object[]{names[i]});
            code.add();
            ++i;
        }
        code.add("/**");
        code.add(" * Constructor for the {@link %s} class.", new Object[]{className});
        code.add(" *");
        i = 0;
        while (i < names.length) {
            code.add(" * @param %s The %s field.", new Object[]{names[i], Numbers.toOrdinal((int)(i + 1))});
            ++i;
        }
        code.add(" */");
        code.add("constructor(%s) {", new Object[]{String.join((CharSequence)", ", paramTxts)});
        code.indent();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name2 = stringArray[n2];
            code.add("this.%s = %s;", new Object[]{name2, name2});
            ++n2;
        }
        code.dedent();
        code.add("}");
        code.add();
        code.add("copy() {");
        code.indent();
        code.add("return new %s(%s);", new Object[]{className, Arrays.stream(names).map(name -> "this." + name).collect(Collectors.joining(", "))});
        code.dedent();
        code.add("}");
        code.add();
        code.add("toString() {");
        code.indent();
        code.add("var rslt = '(';");
        i = 0;
        while (i < names.length) {
            if (i > 0) {
                code.add("rslt += ', ';");
            }
            code.add("rslt += %sUtils.valueToStr(this.%s);", new Object[]{ctxt.getPrefix(), names[i]});
            ++i;
        }
        code.add("rslt += ')';");
        code.add("return rslt;");
        code.dedent();
        code.add("}");
        code.dedent();
        code.add("}");
        String newTupleCode = code.toString();
        ctxt.appendReplacement("javascript-tuples-code", "\n" + newTupleCode);
    }

    @Override
    public void storeValue(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public void declareInit(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("var %s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public String getBinaryExpressionTemplate(BinaryOperator binOp, CodeContext ctxt) {
        if (binOp.equals((Object)BinaryOperator.EQUAL)) {
            return Strings.fmt((String)"%sUtils.equalObjs(${left-value}, ${right-value})", (Object[])new Object[]{ctxt.getPrefix()});
        }
        if (binOp.equals((Object)BinaryOperator.UNEQUAL)) {
            return Strings.fmt((String)"!%sUtils.equalObjs(${left-value}, ${right-value})", (Object[])new Object[]{ctxt.getPrefix()});
        }
        throw new RuntimeException("Unexpected binary operator: " + Strings.str((Object)binOp));
    }

    @Override
    public ExprCode getProjectedValue(ExprCode childCode, int index, Destination dest, CodeContext ctxt) {
        Assert.check((index >= 0 ? 1 : 0) != 0);
        ExprCode result = new ExprCode();
        result.add(childCode);
        String resultText = this.appendProjection(childCode.getData(), false, index);
        result.setDestination(dest);
        result.setDataValue(new JavaScriptDataValue(resultText));
        return result;
    }

    @Override
    public String appendProjection(String value, boolean safe, int index) {
        Assert.check((index >= 0 ? 1 : 0) != 0);
        return safe ? Strings.fmt((String)"%s._field%d", (Object[])new Object[]{value, index}) : Strings.fmt((String)"(%s)._field%d", (Object[])new Object[]{value, index});
    }

    @Override
    public CodeBox modifyContainer(VariableInformation containerInfo, ExprCode partCode, int index, CodeContext ctxt) {
        MemoryCodeBox code = ctxt.makeCodeBox();
        code.add((Box)partCode.getCode());
        code.add("%s = %s;", new Object[]{this.appendProjection(containerInfo.targetRef, true, index), partCode.getData()});
        return code;
    }

    @Override
    public void checkRange(CifType lhsType, CifType rhsType, DataValue rhsValue, CifType varType, String varName, List<RangeCheckErrorLevelText> errorTexts, int level, CodeBox code, CodeContext ctxt) {
        TupleType lhsTuple = (TupleType)lhsType;
        TupleType rhsTuple = (TupleType)rhsType;
        int last = errorTexts.size();
        errorTexts.add(null);
        int i = 0;
        while (i < this.childInfos.length) {
            errorTexts.set(last, new RangeCheckErrorLevelText(false, ((Field)lhsTuple.getFields().get(i)).getName()));
            this.childInfos[i].checkRange(((Field)lhsTuple.getFields().get(i)).getType(), ((Field)rhsTuple.getFields().get(i)).getType(), new JavaScriptDataValue(this.appendProjection(rhsValue.getData(), false, i)), varType, varName, errorTexts, level, code, ctxt);
            ++i;
        }
        errorTexts.remove(last);
        Assert.check((last == errorTexts.size() ? 1 : 0) != 0);
    }

    @Override
    public ExprCode convertLiteral(TupleExpression expr, Destination dest, CodeContext ctxt) {
        String className = this.getTargetType();
        ExprCode result = new ExprCode();
        StringBuilder constructorCall = new StringBuilder();
        constructorCall.append("new ");
        constructorCall.append(className);
        constructorCall.append('(');
        boolean first = true;
        for (Expression arg : expr.getFields()) {
            if (!first) {
                constructorCall.append(", ");
            }
            first = false;
            ExprCode fieldValue = ctxt.exprToTarget(arg, null);
            result.add(fieldValue);
            constructorCall.append(fieldValue.getData());
        }
        constructorCall.append(')');
        result.setDestination(dest);
        result.setDataValue(new JavaScriptDataValue(constructorCall.toString()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaScriptTupleTypeInfo)) {
            return false;
        }
        JavaScriptTupleTypeInfo otherTuple = (JavaScriptTupleTypeInfo)other;
        if (this.childInfos.length != otherTuple.childInfos.length) {
            return false;
        }
        int i = 0;
        while (i < this.childInfos.length) {
            if (!this.childInfos[i].equals(otherTuple.childInfos[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = JavaScriptTupleTypeInfo.class.hashCode() + this.childInfos.length;
        int i = 0;
        while (i < this.childInfos.length) {
            h += this.childInfos[i].hashCode();
            ++i;
        }
        return h;
    }
}

