/*
 * Decompiled with CFR 0.152.
 */
package com.github.javabdd;

import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDException;
import com.github.javabdd.BDDFactory;
import com.github.javabdd.BDDPairing;
import com.github.javabdd.BDDVarSet;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class BDD {
    public abstract BDDFactory getFactory();

    public abstract boolean isZero();

    public abstract boolean isOne();

    public boolean isUniverse() {
        return this.isOne();
    }

    public BDDVarSet toVarSet() {
        return new BDDVarSet.DefaultImpl(this.id());
    }

    public abstract int var();

    public int level() {
        if (this.isZero() || this.isOne()) {
            return this.getFactory().varNum();
        }
        return this.getFactory().var2Level(this.var());
    }

    public abstract BDD high();

    public abstract BDD low();

    public abstract BDD id();

    public abstract BDD not();

    public BDD and(BDD that) {
        return this.apply(that, BDDFactory.and);
    }

    public BDD andWith(BDD that) {
        return this.applyWith(that, BDDFactory.and);
    }

    public BDD or(BDD that) {
        return this.apply(that, BDDFactory.or);
    }

    public BDD orWith(BDD that) {
        return this.applyWith(that, BDDFactory.or);
    }

    public BDD xor(BDD that) {
        return this.apply(that, BDDFactory.xor);
    }

    public BDD xorWith(BDD that) {
        return this.applyWith(that, BDDFactory.xor);
    }

    public BDD imp(BDD that) {
        return this.apply(that, BDDFactory.imp);
    }

    public BDD impWith(BDD that) {
        return this.applyWith(that, BDDFactory.imp);
    }

    public BDD biimp(BDD that) {
        return this.apply(that, BDDFactory.biimp);
    }

    public BDD biimpWith(BDD that) {
        return this.applyWith(that, BDDFactory.biimp);
    }

    public abstract BDD ite(BDD var1, BDD var2);

    public BDD relprod(BDD that, BDDVarSet var) {
        return this.applyEx(that, BDDFactory.and, var);
    }

    public abstract BDD compose(BDD var1, int var2);

    public abstract BDD veccompose(BDDPairing var1);

    public abstract BDD constrain(BDD var1);

    public abstract BDD exist(BDDVarSet var1);

    public abstract BDD forAll(BDDVarSet var1);

    public abstract BDD unique(BDDVarSet var1);

    public abstract BDD restrict(BDD var1);

    public abstract BDD restrictWith(BDD var1);

    public abstract BDD simplify(BDD var1);

    public abstract BDDVarSet support();

    public abstract BDD apply(BDD var1, BDDFactory.BDDOp var2);

    public abstract BDD applyWith(BDD var1, BDDFactory.BDDOp var2);

    public abstract BDD applyAll(BDD var1, BDDFactory.BDDOp var2, BDDVarSet var3);

    public abstract BDD applyEx(BDD var1, BDDFactory.BDDOp var2, BDDVarSet var3);

    public abstract BDD applyUni(BDD var1, BDDFactory.BDDOp var2, BDDVarSet var3);

    public abstract BDD satOne();

    public abstract BDD fullSatOne();

    public abstract BDD satOne(BDDVarSet var1, boolean var2);

    public abstract BDD relnext(BDD var1, BDDVarSet var2);

    public abstract BDD relnextUnion(BDD var1, BDD var2, BDDVarSet var3);

    public BDD relnextUnion(BDD states, BDDVarSet vars) {
        return this.relnextUnion(states, states, vars);
    }

    public abstract BDD relnextIntersection(BDD var1, BDD var2, BDDVarSet var3);

    public abstract BDD relprev(BDD var1, BDDVarSet var2);

    public abstract BDD relprevUnion(BDD var1, BDD var2, BDDVarSet var3);

    public BDD relprevUnion(BDD states, BDDVarSet vars) {
        return this.relprevUnion(states, states, vars);
    }

    public abstract BDD relprevIntersection(BDD var1, BDD var2, BDDVarSet var3);

    public abstract BDD saturationForward(List<BDD> var1, List<BDDVarSet> var2, int var3);

    public abstract BDD boundedSaturationForward(BDD var1, List<BDD> var2, List<BDDVarSet> var3, int var4);

    public abstract BDD saturationBackward(List<BDD> var1, List<BDDVarSet> var2, int var3);

    public abstract BDD boundedSaturationBackward(BDD var1, List<BDD> var2, List<BDDVarSet> var3, int var4);

    public AllSatIterator allsat() {
        return new AllSatIterator(this);
    }

    public BigInteger scanVar(BDDDomain d) {
        if (this.isZero()) {
            return BigInteger.valueOf(-1L);
        }
        BigInteger[] allvar = this.scanAllVar();
        BigInteger res = allvar[d.getIndex()];
        return res;
    }

    public BigInteger[] scanAllVar() {
        if (this.isZero()) {
            return null;
        }
        BDDFactory factory = this.getFactory();
        int bddvarnum = factory.varNum();
        boolean[] store = new boolean[bddvarnum];
        BDD p = this.id();
        while (!p.isOne() && !p.isZero()) {
            BDD p2;
            BDD lo = p.low();
            if (!lo.isZero()) {
                store[p.var()] = false;
                p2 = p.low();
                p.free();
                p = p2;
            } else {
                store[p.var()] = true;
                p2 = p.high();
                p.free();
                p = p2;
            }
            lo.free();
        }
        int fdvarnum = factory.numberOfDomains();
        BigInteger[] res = new BigInteger[fdvarnum];
        for (int n = 0; n < fdvarnum; ++n) {
            BDDDomain dom = factory.getDomain(n);
            int[] ivar = dom.vars();
            BigInteger val = BigInteger.ZERO;
            for (int m = dom.varNum() - 1; m >= 0; --m) {
                val = val.shiftLeft(1);
                if (!store[ivar[m]]) continue;
                val = val.add(BigInteger.ONE);
            }
            res[n] = val;
        }
        return res;
    }

    public BDDIterator iterator(BDDVarSet var) {
        return new BDDIterator(this, var);
    }

    public abstract BDD replace(BDDPairing var1);

    public abstract BDD replaceWith(BDDPairing var1);

    public void printSet() {
        System.out.println(this.toString());
    }

    public void printSetWithDomains() {
        System.out.println(this.toStringWithDomains());
    }

    public void printDot() {
        PrintStream out = System.out;
        out.println("digraph G {");
        out.println("0 [shape=box, label=\"0\", style=filled, shape=box, height=0.3, width=0.3];");
        out.println("1 [shape=box, label=\"1\", style=filled, shape=box, height=0.3, width=0.3];");
        boolean[] visited = new boolean[this.nodeCount() + 2];
        visited[0] = true;
        visited[1] = true;
        HashMap<BDD, Integer> map = new HashMap<BDD, Integer>();
        map.put(this.getFactory().zero(), 0);
        map.put(this.getFactory().one(), 1);
        this.printdot_rec(out, 1, visited, map);
        for (BDD b : map.keySet()) {
            b.free();
        }
        out.println("}");
    }

    protected int printdot_rec(PrintStream out, int current, boolean[] visited, HashMap<BDD, Integer> map) {
        int r;
        Integer ri = map.get(this);
        if (ri == null) {
            ri = ++current;
            map.put(this.id(), ri);
        }
        if (visited[r = ri.intValue()]) {
            return current;
        }
        visited[r] = true;
        out.println(r + " [label=\"" + this.var() + "\"];");
        BDD l = this.low();
        BDD h = this.high();
        Integer li = map.get(l);
        if (li == null) {
            li = ++current;
            map.put(l.id(), li);
        }
        int low = li;
        Integer hi = map.get(h);
        if (hi == null) {
            hi = ++current;
            map.put(h.id(), hi);
        }
        int high = hi;
        out.println(r + " -> " + low + " [style=dotted];");
        out.println(r + " -> " + high + " [style=filled];");
        current = l.printdot_rec(out, current, visited, map);
        l.free();
        current = h.printdot_rec(out, current, visited, map);
        h.free();
        return current;
    }

    public abstract int nodeCount();

    public abstract BigInteger pathCount();

    public abstract BigInteger satCount();

    public BigInteger satCount(BDDVarSet varset) {
        BDDFactory factory = this.getFactory();
        if (varset.isEmpty() || this.isZero()) {
            return BigInteger.ZERO;
        }
        int unused = factory.varNum();
        BigDecimal unused2 = new BigDecimal(this.satCount()).divide(new BigDecimal(BigInteger.TWO.pow(unused -= varset.size())));
        BigDecimal rslt = unused2.compareTo(BigDecimal.ONE) >= 0 ? unused2 : BigDecimal.ONE;
        return rslt.toBigIntegerExact();
    }

    public double logSatCount() {
        return Math.log(this.satCount().doubleValue());
    }

    public double logSatCount(BDDVarSet varset) {
        return Math.log(this.satCount(varset).doubleValue());
    }

    public abstract int[] varProfile();

    public abstract boolean equalsBDD(BDD var1);

    public boolean equals(Object o) {
        if (!(o instanceof BDD)) {
            return false;
        }
        return this.equalsBDD((BDD)o);
    }

    public abstract int hashCode();

    public String toString() {
        BDDFactory f = this.getFactory();
        int[] set = new int[f.varNum()];
        if (f.isZDD()) {
            Arrays.fill(set, 1);
        }
        StringBuffer sb = new StringBuffer();
        BDD.bdd_printset_rec(f, sb, this, set);
        return sb.toString();
    }

    private static void bdd_printset_rec(BDDFactory f, StringBuffer sb, BDD r, int[] set) {
        if (r.isZero()) {
            return;
        }
        if (r.isOne()) {
            sb.append('<');
            boolean first = true;
            for (int n = 0; n < set.length; ++n) {
                if (set[n] <= 0) continue;
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(f.level2Var(n));
                sb.append(':');
                sb.append(set[n] == 2 ? 1 : 0);
            }
            sb.append('>');
        } else if (f.isZDD()) {
            BDD rl;
            if (r.low().equals(r.high())) {
                set[f.var2Level((int)r.var())] = 0;
            } else {
                rl = r.low();
                BDD.bdd_printset_rec(f, sb, rl, set);
                rl.free();
                set[f.var2Level((int)r.var())] = 2;
            }
            rl = r.high();
            BDD.bdd_printset_rec(f, sb, rl, set);
            rl.free();
            set[f.var2Level((int)r.var())] = 1;
        } else {
            set[f.var2Level((int)r.var())] = 1;
            BDD rl = r.low();
            BDD.bdd_printset_rec(f, sb, rl, set);
            rl.free();
            set[f.var2Level((int)r.var())] = 2;
            BDD rh = r.high();
            BDD.bdd_printset_rec(f, sb, rh, set);
            rh.free();
            set[f.var2Level((int)r.var())] = 0;
        }
    }

    public String toStringWithDomains() {
        return this.toStringWithDomains(BDDToString.INSTANCE);
    }

    public String toStringWithDomains(BDDToString ts) {
        if (this.isZero()) {
            return "F";
        }
        if (this.isOne()) {
            return "T";
        }
        BDDFactory bdd = this.getFactory();
        StringBuffer sb = new StringBuffer();
        int[] set = new int[bdd.varNum()];
        BDD.fdd_printset_rec(bdd, sb, ts, this, set);
        return sb.toString();
    }

    private static void fdd_printset_helper(OutputBuffer sb, BigInteger value, int i, int[] set, int[] var, int maxSkip) {
        if (i == maxSkip) {
            BigInteger maxValue = value.or(BigInteger.ONE.shiftLeft(i + 1).subtract(BigInteger.ONE));
            sb.append(value, maxValue);
            return;
        }
        int val = set[var[i]];
        if (val == 0) {
            BigInteger temp = value.setBit(i);
            BDD.fdd_printset_helper(sb, temp, i - 1, set, var, maxSkip);
        }
        BDD.fdd_printset_helper(sb, value, i - 1, set, var, maxSkip);
    }

    private static void fdd_printset_rec(BDDFactory bdd, StringBuffer sb, BDDToString ts, BDD r, int[] set) {
        int fdvarnum = bdd.numberOfDomains();
        boolean used = false;
        if (r.isZero()) {
            return;
        }
        if (r.isOne()) {
            sb.append('<');
            boolean first = true;
            for (int n = 0; n < fdvarnum; ++n) {
                int val;
                int i;
                used = false;
                BDDDomain domain_n = bdd.getDomain(n);
                int[] domain_n_ivar = domain_n.vars();
                int domain_n_varnum = domain_n_ivar.length;
                for (int m = 0; m < domain_n_varnum; ++m) {
                    if (set[domain_n_ivar[m]] == 0) continue;
                    used = true;
                }
                if (!used) continue;
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(domain_n.getName());
                sb.append(':');
                int[] var = domain_n_ivar;
                BigInteger pos = BigInteger.ZERO;
                int maxSkip = -1;
                boolean hasDontCare = false;
                for (i = 0; i < domain_n_varnum; ++i) {
                    val = set[var[i]];
                    if (val != 0) continue;
                    hasDontCare = true;
                    if (maxSkip != i - 1) continue;
                    maxSkip = i;
                }
                for (i = domain_n_varnum - 1; i >= 0; --i) {
                    pos = pos.shiftLeft(1);
                    val = set[var[i]];
                    if (val != 2) continue;
                    pos = pos.setBit(0);
                }
                if (!hasDontCare) {
                    sb.append(ts.elementName(n, pos));
                    continue;
                }
                OutputBuffer ob = new OutputBuffer(ts, sb, n);
                BDD.fdd_printset_helper(ob, pos, domain_n_varnum - 1, set, var, maxSkip);
                ob.finish();
            }
            sb.append('>');
        } else {
            set[r.var()] = 1;
            BDD lo = r.low();
            BDD.fdd_printset_rec(bdd, sb, ts, lo, set);
            lo.free();
            set[r.var()] = 2;
            BDD hi = r.high();
            BDD.fdd_printset_rec(bdd, sb, ts, hi, set);
            hi.free();
            set[r.var()] = 0;
        }
    }

    public abstract void free();

    protected BDD() {
    }

    public static class AllSatIterator
    implements Iterator<byte[]> {
        protected final BDDFactory f;
        protected LinkedList<BDD> loStack;
        protected LinkedList<BDD> hiStack;
        protected byte[] allsatProfile;
        protected final boolean useLevel;

        protected AllSatIterator(BDDFactory factory, boolean level) {
            this.f = factory;
            this.useLevel = level;
        }

        public AllSatIterator(BDD r) {
            this(r, false);
        }

        public AllSatIterator(BDD r, boolean lev) {
            this.f = r.getFactory();
            this.useLevel = lev;
            if (r.isZero()) {
                return;
            }
            this.allsatProfile = new byte[this.f.varNum()];
            if (!this.f.isZDD()) {
                Arrays.fill(this.allsatProfile, (byte)-1);
            }
            this.loStack = new LinkedList();
            this.hiStack = new LinkedList();
            if (!r.isOne()) {
                this.loStack.addLast(r.id());
                if (!this.gotoNext()) {
                    this.allsatProfile = null;
                }
            }
        }

        private boolean gotoNext() {
            while (true) {
                int v;
                BDD r;
                boolean lo_empty;
                if (lo_empty = this.loStack.isEmpty()) {
                    if (this.hiStack.isEmpty()) {
                        return false;
                    }
                    r = this.hiStack.removeLast();
                } else {
                    r = this.loStack.removeLast();
                }
                int LEVEL_r = r.level();
                this.allsatProfile[this.useLevel ? LEVEL_r : this.f.level2Var((int)LEVEL_r)] = lo_empty ? (byte)1 : 0;
                BDD rn = lo_empty ? r.high() : r.low();
                int n = v = rn.isOne() || rn.isZero() ? this.f.varNum() - 1 : rn.level() - 1;
                while (v > LEVEL_r) {
                    this.allsatProfile[this.useLevel ? v : this.f.level2Var((int)v)] = this.f.isZDD() ? 0 : -1;
                    --v;
                }
                if (!lo_empty) {
                    if (this.f.isZDD()) {
                        BDD rh = r.high();
                        boolean isDontCare = rn.equals(rh);
                        rh.free();
                        if (isDontCare) {
                            this.allsatProfile[this.useLevel ? v : this.f.level2Var((int)v)] = -1;
                            r.free();
                        } else {
                            this.hiStack.addLast(r);
                        }
                    } else {
                        this.hiStack.addLast(r);
                    }
                } else {
                    r.free();
                }
                if (rn.isOne()) {
                    rn.free();
                    return true;
                }
                if (rn.isZero()) {
                    rn.free();
                    continue;
                }
                this.loStack.addLast(rn);
            }
        }

        @Override
        public boolean hasNext() {
            return this.allsatProfile != null;
        }

        public byte[] nextSat() {
            if (this.allsatProfile == null) {
                throw new NoSuchElementException();
            }
            byte[] b = new byte[this.allsatProfile.length];
            System.arraycopy(this.allsatProfile, 0, b, 0, b.length);
            if (!this.gotoNext()) {
                this.allsatProfile = null;
            }
            return b;
        }

        @Override
        public byte[] next() {
            return this.nextSat();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class BDDIterator
    implements Iterator<BDD> {
        final BDDFactory f;
        final AllSatIterator i;
        final BDD initialBDD;
        final int[] v;
        final boolean[] b;
        byte[] a;
        BDD lastReturned;

        public BDDIterator(BDD bdd, BDDVarSet var) {
            this.initialBDD = bdd;
            this.f = bdd.getFactory();
            this.i = new AllSatIterator(bdd, true);
            this.v = var.toLevelArray();
            this.b = new boolean[this.v.length];
            this.gotoNext();
        }

        protected void gotoNext() {
            if (!this.i.hasNext()) {
                this.a = null;
                return;
            }
            this.a = this.i.next();
            for (int i = 0; i < this.v.length; ++i) {
                int vi = this.v[i];
                this.b[i] = this.a[vi] == 1;
            }
        }

        protected boolean gotoNextA() {
            for (int i = this.v.length - 1; i >= 0; --i) {
                int vi = this.v[i];
                if (this.a[vi] != -1) continue;
                if (!this.b[i]) {
                    this.b[i] = true;
                    return true;
                }
                this.b[i] = false;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.a != null;
        }

        @Override
        public BDD next() {
            return this.nextBDD();
        }

        public BigInteger nextValue(BDDDomain dom) {
            if (this.a == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = null;
            BigInteger val = BigInteger.ZERO;
            int[] ivar = dom.vars();
            for (int m = dom.varNum() - 1; m >= 0; --m) {
                val = val.shiftLeft(1);
                int level = this.f.var2Level(ivar[m]);
                int k = Arrays.binarySearch(this.v, level);
                if (k < 0) {
                    val = null;
                    break;
                }
                if (!this.b[k]) continue;
                val = val.add(BigInteger.ONE);
            }
            if (!this.gotoNextA()) {
                this.gotoNext();
            }
            return val;
        }

        public BigInteger[] nextTuple() {
            if (this.a == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = null;
            BigInteger[] result = new BigInteger[this.f.numberOfDomains()];
            for (int i = 0; i < result.length; ++i) {
                BDDDomain dom = this.f.getDomain(i);
                int[] ivar = dom.vars();
                BigInteger val = BigInteger.ZERO;
                for (int m = dom.varNum() - 1; m >= 0; --m) {
                    val = val.shiftLeft(1);
                    int level = this.f.var2Level(ivar[m]);
                    int k = Arrays.binarySearch(this.v, level);
                    if (k < 0) {
                        val = null;
                        break;
                    }
                    if (!this.b[k]) continue;
                    val = val.add(BigInteger.ONE);
                }
                result[i] = val;
            }
            if (!this.gotoNextA()) {
                this.gotoNext();
            }
            return result;
        }

        public BigInteger[] nextTuple2() {
            boolean[] store = this.nextSat();
            BigInteger[] result = new BigInteger[this.f.numberOfDomains()];
            for (int i = 0; i < result.length; ++i) {
                BDDDomain dom = this.f.getDomain(i);
                int[] ivar = dom.vars();
                BigInteger val = BigInteger.ZERO;
                for (int m = dom.varNum() - 1; m >= 0; --m) {
                    val = val.shiftLeft(1);
                    if (!store[ivar[m]]) continue;
                    val = val.add(BigInteger.ONE);
                }
                result[i] = val;
            }
            return result;
        }

        public boolean[] nextSat() {
            if (this.a == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = null;
            boolean[] result = new boolean[this.f.varNum()];
            for (int i = 0; i < this.b.length; ++i) {
                result[this.f.level2Var((int)this.v[i])] = this.b[i];
            }
            if (!this.gotoNextA()) {
                this.gotoNext();
            }
            return result;
        }

        public BDD nextBDD() {
            if (this.a == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.f.universe();
            for (int i = this.v.length - 1; i >= 0; --i) {
                int li = this.v[i];
                int vi = this.f.level2Var(li);
                if (this.b[i]) {
                    this.lastReturned.andWith(this.f.ithVar(vi));
                    continue;
                }
                this.lastReturned.andWith(this.f.nithVar(vi));
            }
            if (!this.gotoNextA()) {
                this.gotoNext();
            }
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.initialBDD.applyWith(this.lastReturned.id(), BDDFactory.diff);
            this.lastReturned = null;
        }

        public boolean isDontCare(int var) {
            if (this.a == null) {
                return false;
            }
            int level = this.f.var2Level(var);
            return this.a[level] == -1;
        }

        public boolean isDontCare(BDDDomain d) {
            if (this.a == null) {
                return false;
            }
            int[] vars = d.vars();
            for (int i = 0; i < vars.length; ++i) {
                if (this.isDontCare(vars[i])) continue;
                return false;
            }
            return true;
        }

        public void fastForward(int var) {
            if (this.a == null) {
                throw new BDDException();
            }
            int level = this.f.var2Level(var);
            int i = Arrays.binarySearch(this.v, level);
            if (i < 0 || this.a[i] != -1) {
                throw new BDDException();
            }
            this.b[i] = true;
        }

        public void fastForward(int[] vars) {
            for (int i = 0; i < vars.length; ++i) {
                this.fastForward(vars[i]);
            }
        }

        public void skipDontCare(BDDDomain d) {
            int[] vars = d.vars();
            this.fastForward(vars);
            if (!this.gotoNextA()) {
                this.gotoNext();
            }
        }
    }

    public static class BDDToString {
        public static final BDDToString INSTANCE = new BDDToString();

        protected BDDToString() {
        }

        public String elementName(int i, BigInteger j) {
            return j.toString();
        }

        public String elementNames(int i, BigInteger lo, BigInteger hi) {
            return lo.toString() + "-" + hi.toString();
        }
    }

    private static class OutputBuffer {
        BDDToString ts;
        StringBuffer sb;
        int domain;
        BigInteger lastLow;
        BigInteger lastHigh;
        boolean done;
        static final BigInteger MINUS2 = BigInteger.valueOf(-2L);

        OutputBuffer(BDDToString ts, StringBuffer sb, int domain) {
            this.ts = ts;
            this.sb = sb;
            this.lastHigh = MINUS2;
            this.domain = domain;
        }

        void append(BigInteger low, BigInteger high) {
            if (low.equals(this.lastHigh.add(BigInteger.ONE))) {
                this.lastHigh = high;
            } else {
                this.finish();
                this.lastLow = low;
                this.lastHigh = high;
            }
        }

        StringBuffer finish() {
            if (!this.lastHigh.equals(MINUS2)) {
                if (this.done) {
                    this.sb.append('/');
                }
                if (this.lastLow.equals(this.lastHigh)) {
                    this.sb.append(this.ts.elementName(this.domain, this.lastHigh));
                } else {
                    this.sb.append(this.ts.elementNames(this.domain, this.lastLow, this.lastHigh));
                }
                this.lastHigh = MINUS2;
            }
            this.done = true;
            return this.sb;
        }
    }
}

