/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.checks.boundedresponse;

import java.util.List;
import org.eclipse.escet.cif.controllercheck.checks.CheckConclusion;
import org.eclipse.escet.cif.controllercheck.checks.boundedresponse.Bound;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.java.output.WarnOutput;

public class BoundedResponseCheckConclusion
implements CheckConclusion {
    public final Bound uncontrollablesBound;
    public final Bound controllablesBound;
    private final int maxPrintedCycleStatesCount;

    public BoundedResponseCheckConclusion(Bound uncontrollablesBound, Bound controllablesBound, int maxPrintedCycleStatesCount) {
        List<String> states;
        this.uncontrollablesBound = uncontrollablesBound;
        this.controllablesBound = controllablesBound;
        this.maxPrintedCycleStatesCount = maxPrintedCycleStatesCount;
        if (!uncontrollablesBound.isBounded()) {
            states = uncontrollablesBound.getCycleStates();
            Assert.notNull(states);
            Assert.check((states.size() <= maxPrintedCycleStatesCount || states.size() == maxPrintedCycleStatesCount + 1 && ((String)Lists.last(states)).equals("...") ? 1 : 0) != 0);
        }
        if (!controllablesBound.isBounded()) {
            states = controllablesBound.getCycleStates();
            Assert.notNull(states);
            Assert.check((states.size() <= maxPrintedCycleStatesCount || states.size() == maxPrintedCycleStatesCount + 1 && ((String)Lists.last(states)).equals("...") ? 1 : 0) != 0);
        }
    }

    @Override
    public boolean propertyHolds() {
        return this.uncontrollablesBound.isBounded() && this.controllablesBound.isBounded();
    }

    @Override
    public boolean hasDetails() {
        return true;
    }

    @Override
    public void printResult(DebugNormalOutput out, WarnOutput warn) {
        if (!this.uncontrollablesBound.hasInitialState() || !this.controllablesBound.hasInitialState()) {
            warn.line("The specification cannot be initialized.");
        }
        if (this.propertyHolds()) {
            out.line("[OK] The specification has bounded response:");
        } else {
            out.line("[ERROR] The specification does NOT have bounded response:");
        }
        out.line();
        out.inc();
        this.printDetailsForBound(out, this.uncontrollablesBound, "uncontrollable");
        if (!this.uncontrollablesBound.isBounded()) {
            out.line();
        }
        this.printDetailsForBound(out, this.controllablesBound, "controllable");
        out.dec();
    }

    private void printDetailsForBound(DebugNormalOutput out, Bound bound, String eventKind) {
        if (bound.isBounded()) {
            int boundNr = bound.getBound();
            if (boundNr == 0) {
                out.line("- No transitions are possible for %s events.", new Object[]{eventKind});
            } else {
                out.line("- At most %,d iteration%s needed for the event loop for %s events.", new Object[]{boundNr, boundNr == 1 ? " is" : "s are", eventKind});
            }
        } else {
            out.line("- An infinite sequence of transitions is possible for %s events.", new Object[]{eventKind});
            out.line();
            out.line("  Edge%s enabled in cycle(s):", new Object[]{bound.getCycleEdges().size() == 1 ? "" : "s"});
            out.inc();
            for (String cycleEdge : bound.getCycleEdges().stream().sorted().toList()) {
                out.line(cycleEdge);
            }
            out.dec();
            out.line();
            if (this.maxPrintedCycleStatesCount > 0) {
                boolean complete;
                List<String> printedCycleStates = bound.getCycleStates();
                boolean bl = complete = printedCycleStates.size() <= this.maxPrintedCycleStatesCount;
                String msg = complete ? "  States in cycle(s) at end of event loop executions:" : Strings.fmt((String)"  States in cycle(s) at end of event loop executions, limited to %,d 'printed cycle state%s':", (Object[])new Object[]{this.maxPrintedCycleStatesCount, this.maxPrintedCycleStatesCount == 1 ? "" : "s"});
                out.line(msg);
                out.inc();
                for (String printedCycleState : printedCycleStates) {
                    out.line(printedCycleState);
                }
                out.dec();
            }
        }
    }
}

