/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.checks;

import java.util.Map;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.ElimAlgVariables;
import org.eclipse.escet.cif.cif2cif.ElimConsts;
import org.eclipse.escet.cif.cif2cif.ElimIfUpdates;
import org.eclipse.escet.cif.cif2cif.ElimLocRefExprs;
import org.eclipse.escet.cif.cif2cif.ElimMonitors;
import org.eclipse.escet.cif.cif2cif.ElimSelf;
import org.eclipse.escet.cif.cif2cif.ElimStateEvtExclInvs;
import org.eclipse.escet.cif.cif2cif.ElimTypeDecls;
import org.eclipse.escet.cif.cif2cif.EnumsToInts;
import org.eclipse.escet.cif.cif2cif.SimplifyValues;
import org.eclipse.escet.cif.controllercheck.ControllerCheckerSettings;
import org.eclipse.escet.cif.controllercheck.checks.CheckConclusion;
import org.eclipse.escet.cif.controllercheck.checks.ControllerCheckerCheck;
import org.eclipse.escet.cif.controllercheck.mdd.CifMddSpec;
import org.eclipse.escet.cif.controllercheck.mdd.MddDeterminismChecker;
import org.eclipse.escet.cif.controllercheck.mdd.MddPreChecker;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.java.output.WarnOutput;

public abstract class ControllerCheckerMddBasedCheck<T extends CheckConclusion>
implements ControllerCheckerCheck<T> {
    @Override
    public T performCheck(Specification spec, String specAbsPath, ControllerCheckerSettings checkerSettings) {
        Termination termination = checkerSettings.getTermination();
        DebugNormalOutput debugOutput = checkerSettings.getDebugOutput();
        debugOutput.line("Converting CIF specification to an MDD representation:");
        debugOutput.inc();
        CifMddSpec cifMddSpec = ControllerCheckerMddBasedCheck.convertToMdd(spec, specAbsPath, termination, checkerSettings.getNormalOutput(), checkerSettings.getDebugOutput(), checkerSettings.getWarnOutput());
        debugOutput.dec();
        debugOutput.line();
        termination.throwIfRequested();
        return this.performCheck(cifMddSpec);
    }

    protected abstract T performCheck(CifMddSpec var1);

    private static CifMddSpec convertToMdd(Specification spec, String specAbsPath, Termination termination, DebugNormalOutput normalOutput, DebugNormalOutput debugOutput, WarnOutput warnOutput) {
        spec = (Specification)EMFHelper.deepclone((EObject)spec);
        termination.throwIfRequested();
        new ElimStateEvtExclInvs(warnOutput).transform(spec);
        new ElimMonitors().transform(spec);
        new ElimSelf().transform(spec);
        new ElimTypeDecls().transform(spec);
        Function<Automaton, String> varNamingFunction = a -> "LP_" + a.getName();
        Function<Automaton, String> enumNamingFunction = a -> "LOCS_" + a.getName();
        Function<Location, String> litNamingFunction = l -> "LOC_" + l.getName();
        boolean considerLocsForRename = true;
        boolean addInitPreds = true;
        boolean optimized = false;
        Map lpVarToAbsAutNameMap = null;
        boolean optInits = true;
        boolean addEdgeGuards = true;
        boolean copyAutAnnosToEnum = false;
        boolean copyLocAnnosToEnumLits = false;
        new ElimLocRefExprs(varNamingFunction, enumNamingFunction, litNamingFunction, true, true, false, lpVarToAbsAutNameMap, true, true, false, false, warnOutput).transform(spec);
        new EnumsToInts().transform(spec);
        termination.throwIfRequested();
        new ElimAlgVariables().transform(spec);
        new ElimConsts().transform(spec);
        new SimplifyValues().transform(spec);
        termination.throwIfRequested();
        new MddPreChecker(termination).reportPreconditionViolations(spec, specAbsPath, "CIF controller properties checker");
        termination.throwIfRequested();
        new ElimIfUpdates().transform(spec);
        termination.throwIfRequested();
        new MddDeterminismChecker(termination).reportPreconditionViolations(spec, specAbsPath, "CIF controller properties checker");
        termination.throwIfRequested();
        CifMddSpec cifMddSpec = new CifMddSpec(termination, normalOutput, debugOutput);
        cifMddSpec.compute(spec);
        termination.throwIfRequested();
        return cifMddSpec;
    }
}

