/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.platform.validation.test.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IExceptionAttribute;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.IInnerClassesAttribute;
import org.eclipse.jdt.core.util.IInnerClassesAttributeEntry;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.platform.validation.test.checker.ClassInfo;
import org.eclipse.soda.dk.platform.validation.test.checker.FieldInfo;
import org.eclipse.soda.dk.platform.validation.test.checker.LogService;
import org.eclipse.soda.dk.platform.validation.test.checker.MethodInfo;

public class ClassLibParser {
    private static final int READING = 7440;
    public static ResourceBundle DefaultResourceBundle;
    private Map innerClassAttributes;
    private LogService log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.platform.validation.test.parser.ClassLibParserResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public ClassLibParser(LogService log) {
        this.log = log;
    }

    private static boolean isPublicOrProtected(int accessFlags) {
        return (accessFlags & 5) != 0;
    }

    private static FieldInfo[] parseFields(IClassFileReader classFileReader) {
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        IFieldInfo[] fieldInfos = classFileReader.getFieldInfos();
        int i = 0;
        while (i < fieldInfos.length) {
            IFieldInfo fieldInfo = fieldInfos[i];
            int accessFlags = fieldInfo.getAccessFlags();
            String name = ClassLibParser.toJavaName(fieldInfo.getName());
            if (ClassLibParser.isPublicOrProtected(accessFlags)) {
                String descriptor = ClassLibParser.toJavaDescriptor(fieldInfo.getDescriptor());
                fieldInfoList.add(new FieldInfo(name, accessFlags, descriptor));
            }
            ++i;
        }
        FieldInfo[] fields = new FieldInfo[fieldInfoList.size()];
        fieldInfoList.toArray(fields);
        return fields;
    }

    private static MethodInfo[] parseMethods(IClassFileReader classFileReader) {
        ArrayList<MethodInfo> methodInfoList = new ArrayList<MethodInfo>();
        IMethodInfo[] methodInfos = classFileReader.getMethodInfos();
        int i = 0;
        while (i < methodInfos.length) {
            IMethodInfo methodInfo = methodInfos[i];
            int accessFlags = methodInfo.getAccessFlags();
            String name = ClassLibParser.toJavaName(methodInfo.getName());
            if (ClassLibParser.isPublicOrProtected(accessFlags)) {
                String methodDescriptor = new String(methodInfo.getDescriptor());
                int retPos = methodDescriptor.indexOf(41) + 1;
                String returnTypeDescriptor = ClassLibParser.toJavaDescriptor(methodDescriptor.substring(retPos));
                ArrayList<String> parameterList = new ArrayList<String>();
                int j = 1;
                StringBuffer parameterDescriptor = new StringBuffer();
                while (j < retPos - 1) {
                    char c;
                    if ((c = methodDescriptor.charAt(j++)) == '[') {
                        parameterDescriptor.append(c);
                        continue;
                    }
                    if (c == 'V') continue;
                    if (c == 'L') {
                        int semiPos = methodDescriptor.indexOf(59, j);
                        parameterDescriptor.append(methodDescriptor.substring(j - 1, semiPos));
                        j = semiPos;
                        continue;
                    }
                    parameterDescriptor.append(c);
                    parameterList.add(ClassLibParser.toJavaDescriptor(parameterDescriptor.toString()));
                    parameterDescriptor = new StringBuffer();
                }
                String[] parameterDescriptors = new String[parameterList.size()];
                parameterList.toArray(parameterDescriptors);
                IExceptionAttribute exceptionAttribute = methodInfo.getExceptionAttribute();
                String[] exceptionNames = exceptionAttribute == null ? (String[])null : ClassLibParser.toJavaNames(exceptionAttribute.getExceptionNames());
                methodInfoList.add(new MethodInfo(name, accessFlags, returnTypeDescriptor, parameterDescriptors, exceptionNames));
            }
            ++i;
        }
        MethodInfo[] methods = new MethodInfo[methodInfoList.size()];
        methodInfoList.toArray(methods);
        return methods;
    }

    private static String toJavaDescriptor(char[] jvmDescr) {
        if (jvmDescr == null) {
            return null;
        }
        return ClassLibParser.toJavaDescriptor(new String(jvmDescr).replace('/', '.'));
    }

    private static String toJavaDescriptor(String jvmDescr) {
        if (jvmDescr == null) {
            return null;
        }
        String descr = jvmDescr.replace('/', '.');
        switch (descr.charAt(0)) {
            case 'L': {
                descr = descr.substring(1, descr.length() - 1);
                break;
            }
            case 'Z': {
                descr = "boolean";
                break;
            }
            case 'B': {
                descr = "byte";
                break;
            }
            case 'C': {
                descr = "char";
                break;
            }
            case 'S': {
                descr = "short";
                break;
            }
            case 'I': {
                descr = "int";
                break;
            }
            case 'J': {
                descr = "long";
                break;
            }
            case 'F': {
                descr = "float";
                break;
            }
            case 'D': {
                descr = "double";
                break;
            }
            case 'V': {
                descr = "void";
            }
        }
        return descr;
    }

    private static String toJavaName(char[] jvmName) {
        if (jvmName == null) {
            return null;
        }
        return new String(jvmName).replace('/', '.');
    }

    private static String[] toJavaNames(char[][] jvmNames) {
        String[] names = new String[jvmNames.length];
        int i = 0;
        while (i < names.length) {
            names[i] = ClassLibParser.toJavaName(jvmNames[i]);
            ++i;
        }
        return names;
    }

    private void mergeInnerClassAttributes(List classInfos) {
        Iterator iter = classInfos.iterator();
        while (iter.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iter.next();
            Integer innerClassAccessFlags = (Integer)this.innerClassAttributes.get(classInfo.getName());
            classInfo.setInnerClassAccessFlags(innerClassAccessFlags);
        }
        this.innerClassAttributes = null;
    }

    private boolean packageMatches(String pathName, String[] packages) {
        String qualifiedName = pathName.replace('/', '.');
        int i = 0;
        while (i < packages.length) {
            if (qualifiedName.startsWith(packages[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ClassInfo parseClass(InputStream in) throws ClassFormatException {
        ClassInfo classInfo;
        IClassFileReader classFileReader = ToolFactory.createDefaultClassFileReader((InputStream)in, (int)65503);
        String className = ClassLibParser.toJavaName(classFileReader.getClassName());
        String superClass = ClassLibParser.toJavaName(classFileReader.getSuperclassName());
        String[] interfaceNames = ClassLibParser.toJavaNames(classFileReader.getInterfaceNames());
        int classAccessFlags = classFileReader.getAccessFlags();
        if (ClassLibParser.isPublicOrProtected(classAccessFlags)) {
            FieldInfo[] fields = ClassLibParser.parseFields(classFileReader);
            MethodInfo[] methods = ClassLibParser.parseMethods(classFileReader);
            this.parseInnerClassInfo(classFileReader);
            classInfo = new ClassInfo(className, classAccessFlags, superClass, interfaceNames);
            classInfo.setFields(fields);
            classInfo.setMethods(methods);
        } else {
            classInfo = null;
        }
        return classInfo;
    }

    public List parseClassLib(InputStream in) throws IOException, ClassFormatException {
        return this.parseClassLib(in, "");
    }

    public List parseClassLib(InputStream in, String packageName) throws IOException, ClassFormatException {
        return this.parseClassLib(in, new String[]{packageName});
    }

    public List parseClassLib(InputStream in, String[] packageNames) throws IOException, ClassFormatException {
        ZipEntry zipEntry;
        ArrayList<ClassInfo> classInfos = new ArrayList<ClassInfo>();
        this.innerClassAttributes = new HashMap();
        ZipInputStream zipIn = new ZipInputStream(in);
        do {
            String pathName;
            if ((zipEntry = zipIn.getNextEntry()) == null) continue;
            if (!zipEntry.isDirectory() && (pathName = zipEntry.getName()).endsWith(".class") && this.packageMatches(pathName, packageNames)) {
                this.log.log(3, Nls.format((String)DefaultResourceBundle.getString(Integer.toString(7440)), (Object)pathName));
                ClassInfo classInfo = this.parseClass(zipIn);
                if (classInfo != null) {
                    classInfos.add(classInfo);
                }
            }
            zipIn.closeEntry();
        } while (zipEntry != null);
        zipIn.close();
        this.mergeInnerClassAttributes(classInfos);
        return classInfos;
    }

    private void parseInnerClassInfo(IClassFileReader classFileReader) {
        IInnerClassesAttribute innerClassAttribute = classFileReader.getInnerClassesAttribute();
        if (innerClassAttribute != null) {
            IInnerClassesAttributeEntry[] entries = innerClassAttribute.getInnerClassAttributesEntries();
            int i = 0;
            while (i < entries.length) {
                IInnerClassesAttributeEntry entry = entries[i];
                String innerClassName = ClassLibParser.toJavaName(entry.getInnerClassName());
                this.innerClassAttributes.put(innerClassName, new Integer(entry.getAccessFlags()));
                ++i;
            }
        }
    }
}

