/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification.test.bundle;

import java.util.Hashtable;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.notification.test.NotificationTest;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.record.interfaces.IServiceDetecter;
import org.eclipse.soda.sat.core.record.interfaces.ServiceDetecterListener;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class NotificationTestBundle
extends BaseBundleActivator
implements ServiceDetecterListener {
    private Hashtable tests = new Hashtable(101);
    protected IServiceDetecter detector;

    public void serviceAdded(IServiceDetecter detector, ServiceReference serviceReference, Object service) {
        if (service instanceof NotificationService) {
            NotificationTest notificationTest = new NotificationTest();
            notificationTest.setNotificationService((NotificationService)service);
            this.tests.put(service, notificationTest);
        }
    }

    public void serviceRemoved(IServiceDetecter detector, ServiceReference serviceReference, Object service) {
        Object object;
        if (service instanceof NotificationService && (object = this.tests.get(service)) instanceof NotificationTest) {
            NotificationTest notificationTest = (NotificationTest)((Object)object);
            notificationTest.setNotificationService(null);
            notificationTest.exit();
            this.tests.remove(service);
        }
    }

    protected void start() throws Exception {
        System.out.println("NotificationTestBundle started");
        FactoryUtility utility = FactoryUtility.getInstance();
        BundleContext context = this.getBundleContext();
        this.detector = utility.createServiceDetecter(context, "org.eclipse.soda.dk.notification.service.NotificationService");
        this.detector.addServiceDetecterListener((ServiceDetecterListener)this);
        this.detector.acquire();
    }

    protected void stop() throws Exception {
        this.detector.release();
        this.detector = null;
    }
}

