/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.generic.rfid.write.profile;

import java.util.Map;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.generic.adapter.service.GenericWriteListener;
import org.eclipse.soda.dk.generic.adapter.service.GenericWriteListenerService;
import org.eclipse.soda.dk.generic.adapter.service.GenericWriteService;
import org.eclipse.soda.dk.generic.rfid.write.profile.AbstractGenericRfidWriteProfile;

public abstract class GenericRfidWriteProfile
extends AbstractGenericRfidWriteProfile {
    private GenericWriteListener writeListener = new GenericWriteListener(){

        public void receiveWriteEvent(String tagId, Map tagData) {
            this.receiveWriteEvent(tagId, "operation", tagData);
        }

        public void receiveWriteEvent(String tagId, String operationId, Map tagData) {
            GenericRfidWriteProfile.this.handleWriteEvent(tagId, operationId, tagData);
        }
    };

    protected GenericRfidWriteProfile() {
    }

    protected GenericRfidWriteProfile(String capabilities, String status, String configuration, String metrics) {
    }

    public void activate() {
        super.activate();
        GenericWriteListenerService writeListenerService = (GenericWriteListenerService)((Object)this.getGenericWriteService());
        if (writeListenerService != null) {
            writeListenerService.setWriteListener(this.writeListener);
        }
    }

    public void deactivate() {
        super.deactivate();
        GenericWriteListenerService writeListenerService = (GenericWriteListenerService)((Object)this.getGenericWriteService());
        if (writeListenerService != null) {
            writeListenerService.setWriteListener(null);
        }
    }

    protected boolean execute(String[] op_parameters) {
        GenericWriteService adapter = this.getGenericWriteService();
        if (adapter != null) {
            return adapter.execute(op_parameters);
        }
        return false;
    }

    protected GenericWriteService getGenericWriteService() {
        AdapterService adapter = this.getAdapter();
        if (adapter != null && adapter instanceof GenericWriteService) {
            return (GenericWriteService)adapter;
        }
        return null;
    }
}

