/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

final class CloseablePath
implements Closeable {
    private static final String FILE_URI_SCHEME = "file";
    private static final String JAR_URI_SCHEME = "jar";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String JAR_URI_SEPARATOR = "!";
    private static final Closeable NULL_CLOSEABLE = () -> {};
    private static final ConcurrentMap<URI, ManagedFileSystem> MANAGED_FILE_SYSTEMS = new ConcurrentHashMap<URI, ManagedFileSystem>();
    private final Path path;
    private final Closeable delegate;

    static CloseablePath create(URI uri) throws URISyntaxException {
        if (JAR_URI_SCHEME.equals(uri.getScheme())) {
            String[] parts = uri.toString().split(JAR_URI_SEPARATOR);
            String jarUri = parts[0];
            String jarEntry = parts[1];
            return CloseablePath.createForJarFileSystem(new URI(jarUri), fileSystem -> fileSystem.getPath(jarEntry, new String[0]));
        }
        if (uri.getScheme().equals(FILE_URI_SCHEME) && uri.getPath().endsWith(JAR_FILE_EXTENSION)) {
            return CloseablePath.createForJarFileSystem(new URI("jar:" + uri), fileSystem -> fileSystem.getRootDirectories().iterator().next());
        }
        return new CloseablePath(Paths.get(uri), NULL_CLOSEABLE);
    }

    private static CloseablePath createForJarFileSystem(URI jarUri, Function<FileSystem, Path> pathProvider) {
        ManagedFileSystem managedFileSystem = MANAGED_FILE_SYSTEMS.compute(jarUri, (__, oldValue) -> oldValue == null ? new ManagedFileSystem(jarUri) : ((ManagedFileSystem)oldValue).retain());
        Path path = pathProvider.apply(managedFileSystem.fileSystem);
        return new CloseablePath(path, () -> MANAGED_FILE_SYSTEMS.compute(jarUri, (__, ___) -> managedFileSystem.release()));
    }

    private CloseablePath(Path path, Closeable delegate) {
        this.path = path;
        this.delegate = delegate;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private static class ManagedFileSystem {
        private final AtomicInteger referenceCount = new AtomicInteger(1);
        private final FileSystem fileSystem;
        private final URI jarUri;

        ManagedFileSystem(URI jarUri) {
            this.jarUri = jarUri;
            try {
                this.fileSystem = FileSystems.newFileSystem(jarUri, Collections.emptyMap());
            }
            catch (IOException e2) {
                throw new UncheckedIOException("Failed to create file system for " + jarUri, e2);
            }
        }

        private ManagedFileSystem retain() {
            this.referenceCount.incrementAndGet();
            return this;
        }

        private ManagedFileSystem release() {
            if (this.referenceCount.decrementAndGet() == 0) {
                this.close();
                return null;
            }
            return this;
        }

        private void close() {
            try {
                this.fileSystem.close();
            }
            catch (IOException e2) {
                throw new UncheckedIOException("Failed to close file system for " + this.jarUri, e2);
            }
        }
    }
}

