/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.base.block;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.jena.tdb1.base.block.Block;
import org.apache.jena.tdb1.base.block.BlockMgr;
import org.apache.jena.tdb1.base.block.BlockMgrWrapper;

public final class BlockMgrFreeChain
extends BlockMgrWrapper {
    private final Deque<Block> freeBlocks = new ArrayDeque<Block>();

    public BlockMgrFreeChain(BlockMgr blockMgr) {
        super(blockMgr);
    }

    @Override
    public Block allocate(int blockSize) {
        if (!this.freeBlocks.isEmpty()) {
            Block block = this.freeBlocks.removeFirst();
            block.getByteBuffer().position(0);
            return block;
        }
        return super.allocate(blockSize);
    }

    @Override
    public void free(Block block) {
        this.freeBlocks.add(block);
    }

    @Override
    public boolean valid(int id) {
        for (Block blk : this.freeBlocks) {
            if (blk.getId() != (long)id) continue;
            return true;
        }
        return super.valid(id);
    }

    @Override
    public void sync() {
        super.sync();
    }

    @Override
    public String toString() {
        return "Free:" + super.toString();
    }
}

