/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.protobuf;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.protobuf.ProtobufConvert;
import org.apache.jena.riot.protobuf.VisitorStreamRowProtoRDF;
import org.apache.jena.riot.protobuf.wire.PB_RDF;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.sparql.core.Quad;

class PBufRDF {
    private static PrefixMap PMAP0 = PrefixMapFactory.emptyPrefixMap();

    PBufRDF() {
    }

    public static void writeDelimitedTo(GeneratedMessage gmv3, OutputStream output) {
        try {
            gmv3.writeDelimitedTo(output);
        }
        catch (IOException e2) {
            IO.exception(e2);
        }
    }

    public static PB_RDF.RDF_Triple rdfTriple(Triple triple, PB_RDF.RDF_Triple.Builder tripleBuilder, PB_RDF.RDF_Term.Builder termBuilder) {
        tripleBuilder.clear();
        tripleBuilder.setS(PBufRDF.rdfTerm(triple.getSubject(), termBuilder));
        tripleBuilder.setP(PBufRDF.rdfTerm(triple.getPredicate(), termBuilder));
        tripleBuilder.setO(PBufRDF.rdfTerm(triple.getObject(), termBuilder));
        return tripleBuilder.build();
    }

    public static PB_RDF.RDF_Quad rdfQuad(Quad quad, PB_RDF.RDF_Quad.Builder quadBuilder, PB_RDF.RDF_Term.Builder termBuilder) {
        quadBuilder.clear();
        if (quad.getGraph() != null) {
            quadBuilder.setG(PBufRDF.rdfTerm(quad.getGraph(), termBuilder));
        }
        quadBuilder.setS(PBufRDF.rdfTerm(quad.getSubject(), termBuilder));
        quadBuilder.setP(PBufRDF.rdfTerm(quad.getPredicate(), termBuilder));
        quadBuilder.setO(PBufRDF.rdfTerm(quad.getObject(), termBuilder));
        return quadBuilder.build();
    }

    public static PB_RDF.RDF_Term rdfTerm(Node node, PB_RDF.RDF_Term.Builder termBuilder) {
        return PBufRDF.rdfTerm(node, termBuilder, false);
    }

    static PB_RDF.RDF_Term rdfTerm(Node node, PB_RDF.RDF_Term.Builder termBuilder, boolean encodeValues) {
        termBuilder.clear();
        PB_RDF.RDF_Term term = ProtobufConvert.toProtobuf(node, PMAP0, termBuilder, encodeValues);
        return term;
    }

    static boolean visit(PB_RDF.RDF_StreamRow x, VisitorStreamRowProtoRDF visitor) {
        if (x == null) {
            return false;
        }
        switch (x.getRowCase()) {
            case BASE: {
                visitor.visit(x.getBase());
                return true;
            }
            case PREFIXDECL: {
                visitor.visit(x.getPrefixDecl());
                return true;
            }
            case QUAD: {
                visitor.visit(x.getQuad());
                return true;
            }
            case TRIPLE: {
                visitor.visit(x.getTriple());
                return true;
            }
            case ROW_NOT_SET: {
                throw new InternalErrorException();
            }
        }
        return false;
    }
}

