/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.WriterDatasetRIOTFactory;
import org.apache.jena.riot.WriterGraphRIOTFactory;
import org.apache.jena.riot.protobuf.WriterDatasetProtobuf;
import org.apache.jena.riot.protobuf.WriterGraphProtobuf;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.thrift.WriterDatasetThrift;
import org.apache.jena.riot.thrift.WriterGraphThrift;
import org.apache.jena.riot.writer.JsonLD11Writer;
import org.apache.jena.riot.writer.NQuadsWriter;
import org.apache.jena.riot.writer.NTriplesWriter;
import org.apache.jena.riot.writer.NullWriter;
import org.apache.jena.riot.writer.RDFJSONWriter;
import org.apache.jena.riot.writer.RDFXMLAbbrevWriter;
import org.apache.jena.riot.writer.RDFXMLPlainWriter;
import org.apache.jena.riot.writer.TriGWriter;
import org.apache.jena.riot.writer.TriGWriterBlocks;
import org.apache.jena.riot.writer.TriGWriterFlat;
import org.apache.jena.riot.writer.TriGWriterLong;
import org.apache.jena.riot.writer.TurtleWriter;
import org.apache.jena.riot.writer.TurtleWriterBlocks;
import org.apache.jena.riot.writer.TurtleWriterFlat;
import org.apache.jena.riot.writer.TurtleWriterLong;
import org.apache.jena.riot.writer.WriterTriX;
import org.apache.jena.sys.JenaSystem;

public class RDFWriterRegistry {
    private static Map<RDFFormat, WriterGraphRIOTFactory> registryGraph = new HashMap<RDFFormat, WriterGraphRIOTFactory>();
    private static Map<RDFFormat, WriterDatasetRIOTFactory> registryDataset = new HashMap<RDFFormat, WriterDatasetRIOTFactory>();
    private static Map<Lang, RDFFormat> langToFormat = new HashMap<Lang, RDFFormat>();
    private static WriterDatasetRIOTFactory wdsfactoryAsGraph;

    private static WriterDatasetRIOTFactory wdsfactoryForGraph() {
        return wdsfactoryAsGraph;
    }

    private static WriterGraphRIOTFactory createWriterGraphFactory() {
        return serialization -> {
            if (Objects.equals(RDFFormat.TURTLE_PRETTY, serialization)) {
                return new TurtleWriter();
            }
            if (Objects.equals(RDFFormat.TURTLE_BLOCKS, serialization)) {
                return new TurtleWriterBlocks();
            }
            if (Objects.equals(RDFFormat.TURTLE_FLAT, serialization)) {
                return new TurtleWriterFlat();
            }
            if (Objects.equals(RDFFormat.TURTLE_LONG, serialization)) {
                return new TurtleWriterLong();
            }
            if (Objects.equals(RDFFormat.NTRIPLES_UTF8, serialization)) {
                return new NTriplesWriter();
            }
            if (Objects.equals(RDFFormat.NTRIPLES_ASCII, serialization)) {
                return new NTriplesWriter(CharSpace.ASCII);
            }
            if (Objects.equals(RDFFormat.RDFJSON, serialization)) {
                return new RDFJSONWriter();
            }
            if (Objects.equals(RDFFormat.RDFXML_PRETTY, serialization)) {
                return new RDFXMLAbbrevWriter();
            }
            if (Objects.equals(RDFFormat.RDFXML_PLAIN, serialization)) {
                return new RDFXMLPlainWriter();
            }
            WriterDatasetRIOT dsw = RDFWriterRegistry.wdsfactoryForGraph().create(serialization);
            if (dsw != null) {
                return RiotLib.adapter(dsw);
            }
            return null;
        };
    }

    private static WriterDatasetRIOTFactory createWriterDatasetFactory() {
        return serialization -> {
            if (Objects.equals(RDFFormat.TRIG_PRETTY, serialization)) {
                return new TriGWriter();
            }
            if (Objects.equals(RDFFormat.TRIG_BLOCKS, serialization)) {
                return new TriGWriterBlocks();
            }
            if (Objects.equals(RDFFormat.TRIG_FLAT, serialization)) {
                return new TriGWriterFlat();
            }
            if (Objects.equals(RDFFormat.TRIG_LONG, serialization)) {
                return new TriGWriterLong();
            }
            if (Objects.equals(RDFFormat.NQUADS_UTF8, serialization)) {
                return new NQuadsWriter();
            }
            if (Objects.equals(RDFFormat.NQUADS_ASCII, serialization)) {
                return new NQuadsWriter(CharSpace.ASCII);
            }
            if (Objects.equals(RDFFormat.RDFNULL, serialization)) {
                return NullWriter.factory.create(RDFFormat.RDFNULL);
            }
            return null;
        };
    }

    public static void init() {
    }

    private static void init$() {
        WriterGraphRIOTFactory wgfactory = RDFWriterRegistry.createWriterGraphFactory();
        WriterDatasetRIOTFactory wdsfactory = RDFWriterRegistry.createWriterDatasetFactory();
        WriterDatasetRIOTFactory wdsJsonldFactory11 = syntaxForm -> new JsonLD11Writer(syntaxForm);
        WriterGraphRIOTFactory wgJsonldFactory11 = syntaxForm -> RiotLib.adapter(new JsonLD11Writer(syntaxForm));
        WriterGraphRIOTFactory wgProtoFactory = syntaxForm -> new WriterGraphProtobuf(syntaxForm);
        WriterDatasetRIOTFactory wdsProtoFactory = syntaxForm -> new WriterDatasetProtobuf(syntaxForm);
        WriterGraphRIOTFactory wgThriftFactory = syntaxForm -> new WriterGraphThrift(syntaxForm);
        WriterDatasetRIOTFactory wdsThriftFactory = syntaxForm -> new WriterDatasetThrift(syntaxForm);
        WriterGraphRIOTFactory wgTriXFactory = syntaxForm -> new WriterTriX();
        WriterDatasetRIOTFactory wdsTriXFactory = syntaxForm -> new WriterTriX();
        WriterGraphRIOTFactory jsonldWriterGraphDefault = wgJsonldFactory11;
        WriterDatasetRIOTFactory jsonldWriterDatasetDefault = wdsJsonldFactory11;
        RDFWriterRegistry.register(Lang.TURTLE, RDFFormat.TURTLE);
        RDFWriterRegistry.register(Lang.N3, RDFFormat.TURTLE);
        RDFWriterRegistry.register(Lang.NTRIPLES, RDFFormat.NTRIPLES);
        RDFWriterRegistry.register(Lang.RDFXML, RDFFormat.RDFXML);
        RDFWriterRegistry.register(Lang.JSONLD, RDFFormat.JSONLD);
        RDFWriterRegistry.register(Lang.JSONLD11, RDFFormat.JSONLD11);
        RDFWriterRegistry.register(Lang.RDFJSON, RDFFormat.RDFJSON);
        RDFWriterRegistry.register(Lang.TRIG, RDFFormat.TRIG);
        RDFWriterRegistry.register(Lang.NQUADS, RDFFormat.NQUADS);
        RDFWriterRegistry.register(Lang.RDFNULL, RDFFormat.RDFNULL);
        RDFWriterRegistry.register(Lang.RDFPROTO, RDFFormat.RDF_PROTO);
        RDFWriterRegistry.register(Lang.RDFTHRIFT, RDFFormat.RDF_THRIFT);
        RDFWriterRegistry.register(Lang.TRIX, RDFFormat.TRIX);
        RDFWriterRegistry.register(RDFFormat.TURTLE_PRETTY, wgfactory);
        RDFWriterRegistry.register(RDFFormat.TURTLE_BLOCKS, wgfactory);
        RDFWriterRegistry.register(RDFFormat.TURTLE_FLAT, wgfactory);
        RDFWriterRegistry.register(RDFFormat.TURTLE_LONG, wgfactory);
        RDFWriterRegistry.register(RDFFormat.NTRIPLES, wgfactory);
        RDFWriterRegistry.register(RDFFormat.NTRIPLES_ASCII, wgfactory);
        RDFWriterRegistry.register(RDFFormat.JSONLD11, wgJsonldFactory11);
        RDFWriterRegistry.register(RDFFormat.JSONLD11_PRETTY, wgJsonldFactory11);
        RDFWriterRegistry.register(RDFFormat.JSONLD11_PLAIN, wgJsonldFactory11);
        RDFWriterRegistry.register(RDFFormat.JSONLD11_FLAT, wgJsonldFactory11);
        RDFWriterRegistry.register(RDFFormat.JSONLD11, wdsJsonldFactory11);
        RDFWriterRegistry.register(RDFFormat.JSONLD11_PRETTY, wdsJsonldFactory11);
        RDFWriterRegistry.register(RDFFormat.JSONLD11_PLAIN, wdsJsonldFactory11);
        RDFWriterRegistry.register(RDFFormat.JSONLD11_FLAT, wdsJsonldFactory11);
        RDFWriterRegistry.register(RDFFormat.JSONLD, jsonldWriterGraphDefault);
        RDFWriterRegistry.register(RDFFormat.JSONLD_PRETTY, jsonldWriterGraphDefault);
        RDFWriterRegistry.register(RDFFormat.JSONLD_PLAIN, jsonldWriterGraphDefault);
        RDFWriterRegistry.register(RDFFormat.JSONLD_FLAT, jsonldWriterGraphDefault);
        RDFWriterRegistry.register(RDFFormat.JSONLD, jsonldWriterDatasetDefault);
        RDFWriterRegistry.register(RDFFormat.JSONLD_PRETTY, jsonldWriterDatasetDefault);
        RDFWriterRegistry.register(RDFFormat.JSONLD_PLAIN, jsonldWriterDatasetDefault);
        RDFWriterRegistry.register(RDFFormat.JSONLD_FLAT, jsonldWriterDatasetDefault);
        RDFWriterRegistry.register(RDFFormat.RDFJSON, wgfactory);
        RDFWriterRegistry.register(RDFFormat.RDFXML_PRETTY, wgfactory);
        RDFWriterRegistry.register(RDFFormat.RDFXML_PLAIN, wgfactory);
        RDFWriterRegistry.register(RDFFormat.TRIG_PRETTY, wgfactory);
        RDFWriterRegistry.register(RDFFormat.TRIG_BLOCKS, wgfactory);
        RDFWriterRegistry.register(RDFFormat.TRIG_FLAT, wgfactory);
        RDFWriterRegistry.register(RDFFormat.TRIG_LONG, wgfactory);
        RDFWriterRegistry.register(RDFFormat.NQUADS, wgfactory);
        RDFWriterRegistry.register(RDFFormat.NQUADS_ASCII, wgfactory);
        RDFWriterRegistry.register(RDFFormat.RDFNULL, wgfactory);
        RDFWriterRegistry.register(RDFFormat.RDF_PROTO, wgProtoFactory);
        RDFWriterRegistry.register(RDFFormat.RDF_PROTO_VALUES, wgProtoFactory);
        RDFWriterRegistry.register(RDFFormat.RDF_THRIFT, wgThriftFactory);
        RDFWriterRegistry.register(RDFFormat.RDF_THRIFT_VALUES, wgThriftFactory);
        RDFWriterRegistry.register(RDFFormat.TRIX, wgTriXFactory);
        RDFWriterRegistry.register(RDFFormat.TRIG_PRETTY, wdsfactory);
        RDFWriterRegistry.register(RDFFormat.TRIG_BLOCKS, wdsfactory);
        RDFWriterRegistry.register(RDFFormat.TRIG_FLAT, wdsfactory);
        RDFWriterRegistry.register(RDFFormat.NQUADS, wdsfactory);
        RDFWriterRegistry.register(RDFFormat.NQUADS_ASCII, wdsfactory);
        RDFWriterRegistry.register(RDFFormat.RDFNULL, wdsfactory);
        RDFWriterRegistry.register(RDFFormat.RDF_PROTO, wdsProtoFactory);
        RDFWriterRegistry.register(RDFFormat.RDF_PROTO_VALUES, wdsProtoFactory);
        RDFWriterRegistry.register(RDFFormat.RDF_THRIFT, wdsThriftFactory);
        RDFWriterRegistry.register(RDFFormat.RDF_THRIFT_VALUES, wdsThriftFactory);
        RDFWriterRegistry.register(RDFFormat.TRIX, wdsTriXFactory);
    }

    public static void register(RDFFormat serialization, WriterGraphRIOTFactory graphWriterFactory) {
        registryGraph.put(serialization, graphWriterFactory);
    }

    public static void register(RDFFormat serialization, WriterDatasetRIOTFactory datasetWriterFactory) {
        registryDataset.put(serialization, datasetWriterFactory);
    }

    private static void register(RDFFormat serialization) {
    }

    public static void register(Lang lang, RDFFormat format) {
        RDFWriterRegistry.register(format);
        langToFormat.put(lang, format);
    }

    public static RDFFormat defaultSerialization(Lang lang) {
        return langToFormat.get(lang);
    }

    public static boolean contains(Lang lang) {
        if (!langToFormat.containsKey(lang)) {
            return false;
        }
        RDFFormat fmt = langToFormat.get(lang);
        return RDFWriterRegistry.contains(fmt);
    }

    public static boolean contains(RDFFormat format) {
        return langToFormat.containsKey(format.getLang()) && (registryGraph.containsKey(format) || registryDataset.containsKey(format));
    }

    public static Collection<RDFFormat> registeredGraphFormats() {
        return Set.copyOf(registryGraph.keySet());
    }

    public static Collection<RDFFormat> registeredDatasetFormats() {
        return Set.copyOf(registryDataset.keySet());
    }

    public static Collection<RDFFormat> registeredFormats() {
        HashSet<RDFFormat> x = new HashSet<RDFFormat>();
        x.addAll(registryGraph.keySet());
        x.addAll(registryDataset.keySet());
        return Set.copyOf(x);
    }

    public static Collection<Lang> registeredLangs() {
        return Set.copyOf(langToFormat.keySet());
    }

    public static WriterGraphRIOTFactory getWriterGraphFactory(Lang lang) {
        RDFFormat serialization = RDFWriterRegistry.defaultSerialization(lang);
        if (serialization == null) {
            throw new RiotException("No default serialization for language " + lang);
        }
        return RDFWriterRegistry.getWriterGraphFactory(serialization);
    }

    public static WriterGraphRIOTFactory getWriterGraphFactory(RDFFormat serialization) {
        return registryGraph.get(serialization);
    }

    public static WriterDatasetRIOTFactory getWriterDatasetFactory(Lang lang) {
        RDFFormat serialization = RDFWriterRegistry.defaultSerialization(lang);
        if (serialization == null) {
            throw new RiotException("No default serialization for language " + lang);
        }
        return RDFWriterRegistry.getWriterDatasetFactory(serialization);
    }

    public static WriterDatasetRIOTFactory getWriterDatasetFactory(RDFFormat serialization) {
        if (serialization == null) {
            return null;
        }
        return registryDataset.get(serialization);
    }

    static {
        JenaSystem.init();
        wdsfactoryAsGraph = RDFWriterRegistry.createWriterDatasetFactory();
        RDFWriterRegistry.init$();
    }
}

