/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.model;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public interface RDFNodeList<E extends RDFNode>
extends Resource {
    public Stream<E> members();

    default public boolean contains(E element) {
        Objects.requireNonNull(element);
        try (Stream<E> members = this.members();){
            boolean bl = members.anyMatch(element::equals);
            return bl;
        }
    }

    default public Optional<E> first() {
        try (Stream<E> members = this.members();){
            Optional<E> optional = members.findFirst();
            return optional;
        }
    }

    default public Optional<E> last() {
        return this.members().reduce((f, s) -> s);
    }

    default public long size() {
        return this.as(RDFList.class).size();
    }

    default public boolean isNil() {
        return this.as(RDFList.class).isEmpty();
    }

    default public boolean isEmpty() {
        return this.first().isEmpty();
    }
}

