/**
 */
package org.eclipse.emfcloud.jackson.junit.caravan;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * A functional sample metamodel to illustrate the use of FeatureMapEntry with Json.
 * <!-- end-model-doc -->
 * @see org.eclipse.emfcloud.jackson.junit.caravan.CaravanFactory
 * @model kind="package"
 * @generated
 */
public interface CaravanPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "caravan";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.emfjson.org/jackson/caravan";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "caravan";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	CaravanPackage eINSTANCE = org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.emfcloud.jackson.junit.caravan.impl.DocumentRootImpl <em>Document Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.DocumentRootImpl
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanPackageImpl#getDocumentRoot()
	 * @generated
	 */
	int DOCUMENT_ROOT = 0;

	/**
	 * The feature id for the '<em><b>Mixed</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MIXED = 0;

	/**
	 * The feature id for the '<em><b>XMLNS Prefix Map</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XMLNS_PREFIX_MAP = 1;

	/**
	 * The feature id for the '<em><b>XSI Schema Location</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XSI_SCHEMA_LOCATION = 2;

	/**
	 * The feature id for the '<em><b>Caravan</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__CARAVAN = 3;

	/**
	 * The feature id for the '<em><b>Lone Person</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__LONE_PERSON = 4;

	/**
	 * The number of structural features of the '<em>Document Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Document Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanTypeImpl <em>Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanTypeImpl
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanPackageImpl#getCaravanType()
	 * @generated
	 */
	int CARAVAN_TYPE = 1;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARAVAN_TYPE__GROUP = 0;

	/**
	 * The feature id for the '<em><b>Person</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARAVAN_TYPE__PERSON = 1;

	/**
	 * The feature id for the '<em><b>Dromadery Camel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARAVAN_TYPE__DROMADERY_CAMEL = 2;

	/**
	 * The feature id for the '<em><b>Bactrian Camel</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARAVAN_TYPE__BACTRIAN_CAMEL = 3;

	/**
	 * The number of structural features of the '<em>Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARAVAN_TYPE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CARAVAN_TYPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.emfcloud.jackson.junit.caravan.impl.PersonImpl <em>Person</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.PersonImpl
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanPackageImpl#getPerson()
	 * @generated
	 */
	int PERSON = 2;

	/**
	 * The feature id for the '<em><b>First Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERSON__FIRST_NAME = 0;

	/**
	 * The number of structural features of the '<em>Person</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERSON_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Person</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERSON_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.emfcloud.jackson.junit.caravan.impl.CamelImpl <em>Camel</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CamelImpl
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanPackageImpl#getCamel()
	 * @generated
	 */
	int CAMEL = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL__NAME = 0;

	/**
	 * The number of structural features of the '<em>Camel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Camel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CAMEL_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.emfcloud.jackson.junit.caravan.impl.BactrianCamelImpl <em>Bactrian Camel</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.BactrianCamelImpl
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanPackageImpl#getBactrianCamel()
	 * @generated
	 */
	int BACTRIAN_CAMEL = 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BACTRIAN_CAMEL__NAME = CAMEL__NAME;

	/**
	 * The number of structural features of the '<em>Bactrian Camel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BACTRIAN_CAMEL_FEATURE_COUNT = CAMEL_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Bactrian Camel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BACTRIAN_CAMEL_OPERATION_COUNT = CAMEL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.emfcloud.jackson.junit.caravan.impl.DromaderyCamelImpl <em>Dromadery Camel</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.DromaderyCamelImpl
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanPackageImpl#getDromaderyCamel()
	 * @generated
	 */
	int DROMADERY_CAMEL = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DROMADERY_CAMEL__NAME = CAMEL__NAME;

	/**
	 * The number of structural features of the '<em>Dromadery Camel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DROMADERY_CAMEL_FEATURE_COUNT = CAMEL_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Dromadery Camel</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DROMADERY_CAMEL_OPERATION_COUNT = CAMEL_OPERATION_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot <em>Document Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Document Root</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot
	 * @generated
	 */
	EClass getDocumentRoot();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getMixed <em>Mixed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mixed</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getMixed()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EAttribute getDocumentRoot_Mixed();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getXMLNSPrefixMap <em>XMLNS Prefix Map</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>XMLNS Prefix Map</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getXMLNSPrefixMap()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_XMLNSPrefixMap();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getXSISchemaLocation <em>XSI Schema Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>XSI Schema Location</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getXSISchemaLocation()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_XSISchemaLocation();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getCaravan <em>Caravan</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Caravan</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getCaravan()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_Caravan();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getLonePerson <em>Lone Person</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Lone Person</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.DocumentRoot#getLonePerson()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_LonePerson();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emfcloud.jackson.junit.caravan.CaravanType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.CaravanType
	 * @generated
	 */
	EClass getCaravanType();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.emfcloud.jackson.junit.caravan.CaravanType#getGroup <em>Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Group</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.CaravanType#getGroup()
	 * @see #getCaravanType()
	 * @generated
	 */
	EAttribute getCaravanType_Group();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.emfcloud.jackson.junit.caravan.CaravanType#getPerson <em>Person</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Person</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.CaravanType#getPerson()
	 * @see #getCaravanType()
	 * @generated
	 */
	EReference getCaravanType_Person();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.emfcloud.jackson.junit.caravan.CaravanType#getDromaderyCamel <em>Dromadery Camel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Dromadery Camel</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.CaravanType#getDromaderyCamel()
	 * @see #getCaravanType()
	 * @generated
	 */
	EReference getCaravanType_DromaderyCamel();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.emfcloud.jackson.junit.caravan.CaravanType#getBactrianCamel <em>Bactrian Camel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Bactrian Camel</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.CaravanType#getBactrianCamel()
	 * @see #getCaravanType()
	 * @generated
	 */
	EReference getCaravanType_BactrianCamel();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emfcloud.jackson.junit.caravan.Person <em>Person</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Person</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.Person
	 * @generated
	 */
	EClass getPerson();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emfcloud.jackson.junit.caravan.Person#getFirstName <em>First Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>First Name</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.Person#getFirstName()
	 * @see #getPerson()
	 * @generated
	 */
	EAttribute getPerson_FirstName();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emfcloud.jackson.junit.caravan.Camel <em>Camel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Camel</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.Camel
	 * @generated
	 */
	EClass getCamel();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emfcloud.jackson.junit.caravan.Camel#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.Camel#getName()
	 * @see #getCamel()
	 * @generated
	 */
	EAttribute getCamel_Name();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emfcloud.jackson.junit.caravan.BactrianCamel <em>Bactrian Camel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Bactrian Camel</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.BactrianCamel
	 * @generated
	 */
	EClass getBactrianCamel();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emfcloud.jackson.junit.caravan.DromaderyCamel <em>Dromadery Camel</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Dromadery Camel</em>'.
	 * @see org.eclipse.emfcloud.jackson.junit.caravan.DromaderyCamel
	 * @generated
	 */
	EClass getDromaderyCamel();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	CaravanFactory getCaravanFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.emfcloud.jackson.junit.caravan.impl.DocumentRootImpl <em>Document Root</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.DocumentRootImpl
		 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanPackageImpl#getDocumentRoot()
		 * @generated
		 */
		EClass DOCUMENT_ROOT = eINSTANCE.getDocumentRoot();

		/**
		 * The meta object literal for the '<em><b>Mixed</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DOCUMENT_ROOT__MIXED = eINSTANCE.getDocumentRoot_Mixed();

		/**
		 * The meta object literal for the '<em><b>XMLNS Prefix Map</b></em>' map feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_ROOT__XMLNS_PREFIX_MAP = eINSTANCE.getDocumentRoot_XMLNSPrefixMap();

		/**
		 * The meta object literal for the '<em><b>XSI Schema Location</b></em>' map feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_ROOT__XSI_SCHEMA_LOCATION = eINSTANCE.getDocumentRoot_XSISchemaLocation();

		/**
		 * The meta object literal for the '<em><b>Caravan</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_ROOT__CARAVAN = eINSTANCE.getDocumentRoot_Caravan();

		/**
		 * The meta object literal for the '<em><b>Lone Person</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference DOCUMENT_ROOT__LONE_PERSON = eINSTANCE.getDocumentRoot_LonePerson();

		/**
		 * The meta object literal for the '{@link org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanTypeImpl <em>Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanTypeImpl
		 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanPackageImpl#getCaravanType()
		 * @generated
		 */
		EClass CARAVAN_TYPE = eINSTANCE.getCaravanType();

		/**
		 * The meta object literal for the '<em><b>Group</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CARAVAN_TYPE__GROUP = eINSTANCE.getCaravanType_Group();

		/**
		 * The meta object literal for the '<em><b>Person</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CARAVAN_TYPE__PERSON = eINSTANCE.getCaravanType_Person();

		/**
		 * The meta object literal for the '<em><b>Dromadery Camel</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CARAVAN_TYPE__DROMADERY_CAMEL = eINSTANCE.getCaravanType_DromaderyCamel();

		/**
		 * The meta object literal for the '<em><b>Bactrian Camel</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CARAVAN_TYPE__BACTRIAN_CAMEL = eINSTANCE.getCaravanType_BactrianCamel();

		/**
		 * The meta object literal for the '{@link org.eclipse.emfcloud.jackson.junit.caravan.impl.PersonImpl <em>Person</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.PersonImpl
		 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanPackageImpl#getPerson()
		 * @generated
		 */
		EClass PERSON = eINSTANCE.getPerson();

		/**
		 * The meta object literal for the '<em><b>First Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PERSON__FIRST_NAME = eINSTANCE.getPerson_FirstName();

		/**
		 * The meta object literal for the '{@link org.eclipse.emfcloud.jackson.junit.caravan.impl.CamelImpl <em>Camel</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CamelImpl
		 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanPackageImpl#getCamel()
		 * @generated
		 */
		EClass CAMEL = eINSTANCE.getCamel();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CAMEL__NAME = eINSTANCE.getCamel_Name();

		/**
		 * The meta object literal for the '{@link org.eclipse.emfcloud.jackson.junit.caravan.impl.BactrianCamelImpl <em>Bactrian Camel</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.BactrianCamelImpl
		 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanPackageImpl#getBactrianCamel()
		 * @generated
		 */
		EClass BACTRIAN_CAMEL = eINSTANCE.getBactrianCamel();

		/**
		 * The meta object literal for the '{@link org.eclipse.emfcloud.jackson.junit.caravan.impl.DromaderyCamelImpl <em>Dromadery Camel</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.DromaderyCamelImpl
		 * @see org.eclipse.emfcloud.jackson.junit.caravan.impl.CaravanPackageImpl#getDromaderyCamel()
		 * @generated
		 */
		EClass DROMADERY_CAMEL = eINSTANCE.getDromaderyCamel();

	}

} //CaravanPackage
