/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.provider;

import java.sql.Timestamp;
import java.util.Iterator;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.impl.StringToFileInfoImpl;
import org.eclipse.egerrit.internal.ui.EGerritImages;
import org.eclipse.egerrit.internal.ui.table.provider.BaseTableLabelProvider;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.swt.graphics.Image;

public class FileTableLabelProvider
extends BaseTableLabelProvider {
    private static final String NEW = Messages.FileTableLabelProvider_0;
    private static final String COMMENTS = Messages.FileTableLabelProvider_1;
    private static final String DRAFTS = Messages.FileTableLabelProvider_2;
    private boolean nameFirst = true;

    public FileTableLabelProvider(IObservableMap[] iObservableMaps) {
        super(iObservableMaps);
    }

    public String getColumnText(Object aObj, int aIndex) {
        if (aObj instanceof StringToFileInfoImpl) {
            FileInfo fileInfo = ((StringToFileInfoImpl)aObj).getValue();
            switch (aIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return fileInfo.getStatus();
                }
                case 2: {
                    String path = null;
                    if (this.nameFirst) {
                        path = fileInfo.getPath();
                        int index = path.lastIndexOf(47);
                        if (index != -1) {
                            String firstName;
                            String fileName = path.substring(index + 1);
                            path = firstName = String.valueOf(fileName) + " - " + path.substring(0, index);
                        }
                    } else {
                        path = fileInfo.getPath();
                    }
                    if (fileInfo.getOld_path() != null) {
                        path = String.valueOf(path) + Messages.FileTableLabelProvider_3 + fileInfo.getOld_path() + Messages.FileTableLabelProvider_4;
                    }
                    return path;
                }
                case 3: {
                    String ret = "";
                    if (fileInfo.getDraftComments() != null && !fileInfo.getDraftComments().isEmpty()) {
                        ret = String.valueOf(DRAFTS) + fileInfo.getDraftComments().size() + " ";
                    }
                    if (fileInfo.getComments() != null) {
                        int newCommentCount = 0;
                        Iterator iterator = fileInfo.getComments().iterator();
                        String currentUpdate = "";
                        String currentUser = "";
                        while (iterator.hasNext()) {
                            CommentInfo aComment = (CommentInfo)iterator.next();
                            String authorName = aComment.getAuthor().getUsername();
                            if (currentUser == null || authorName == null || currentUser.compareTo(authorName) != 0) continue;
                            if (currentUpdate.isEmpty()) {
                                currentUpdate = aComment.getUpdated();
                                continue;
                            }
                            if (!Timestamp.valueOf(aComment.getUpdated()).after(Timestamp.valueOf(currentUpdate))) continue;
                            currentUpdate = aComment.getUpdated();
                        }
                        if (!currentUpdate.isEmpty()) {
                            for (CommentInfo aComment2 : fileInfo.getComments()) {
                                if (!Timestamp.valueOf(aComment2.getUpdated()).after(Timestamp.valueOf(currentUpdate))) continue;
                                ++newCommentCount;
                            }
                        }
                        if (ret.isEmpty()) {
                            ret = "                     ";
                        }
                        if (fileInfo.getComments().size() - newCommentCount != 0) {
                            ret = String.valueOf(ret) + COMMENTS + (fileInfo.getComments().size() - newCommentCount) + " ";
                        }
                        if (newCommentCount != 0) {
                            ret = String.valueOf(ret) + NEW + newCommentCount;
                        }
                    }
                    return ret;
                }
                case 4: {
                    StringBuilder sb = new StringBuilder();
                    sb.append('+');
                    sb.append(Integer.toString(fileInfo.getLines_inserted()));
                    sb.append('/');
                    sb.append('-');
                    sb.append(Integer.toString(fileInfo.getLines_deleted()));
                    return sb.toString();
                }
            }
            return "";
        }
        return "";
    }

    private Image getReviewedStateImage(boolean aState) {
        if (aState) {
            return EGerritImages.get("icons/greenCheck.png");
        }
        return null;
    }

    @Override
    public Image getColumnImage(Object aObj, int aIndex) {
        Image image = null;
        String value = null;
        if (aObj instanceof StringToFileInfoImpl) {
            switch (aIndex) {
                case 0: {
                    Boolean isReviewed = ((StringToFileInfoImpl)aObj).getValue().isReviewed();
                    value = isReviewed.toString();
                    if (value == null || value.equals("")) break;
                    return this.getReviewedStateImage(Boolean.valueOf(value.toLowerCase()));
                }
                default: {
                    return image;
                }
            }
        }
        return image;
    }

    public void setFileNameFirst(boolean b) {
        this.nameFirst = b;
    }

    public boolean getFileOrder() {
        return this.nameFirst;
    }
}

