/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.model.internal;

import org.eclipse.fx.ide.model.IFXObjectProperty;
import org.eclipse.fx.ide.model.internal.FXClass;
import org.eclipse.fx.ide.model.internal.FXProperty;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class FXObjectPoperty
extends FXProperty
implements IFXObjectProperty {
    private String erasedFQNType;
    private IType type;
    private Boolean valueOf;
    private IMethod valueOfMethod;
    private boolean valueOfMethodResolved;

    public FXObjectPoperty(FXClass fxClass, String name, IJavaElement javaElement, String erasedFQNType, boolean isStatic) {
        super(fxClass, name, javaElement, isStatic);
        this.erasedFQNType = erasedFQNType;
    }

    public String toString() {
        return "FXObjectPoperty(" + this.getName() + ")";
    }

    @Override
    public String getElementTypeAsString(boolean fqn) {
        return fqn ? this.erasedFQNType : Signature.getSimpleName((String)this.erasedFQNType);
    }

    @Override
    public boolean hasValueOf() {
        if (this.valueOf == null) {
            this.valueOf = this.getValueOfMethod() != null;
        }
        return this.valueOf;
    }

    @Override
    public IMethod getValueOfMethod() {
        if (!this.valueOfMethodResolved) {
            try {
                IMethod[] iMethodArray = this.getElementType().getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod m = iMethodArray[n2];
                    if (Flags.isStatic((int)m.getFlags()) && Flags.isPublic((int)m.getFlags()) && "valueOf".equals(m.getElementName())) {
                        this.valueOfMethod = m;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            this.valueOfMethodResolved = true;
        }
        return this.valueOfMethod;
    }

    @Override
    public IType getElementType() {
        if (this.type == null) {
            try {
                this.type = this.getFXClass().getJavaProject().findType(this.erasedFQNType);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return this.type;
    }
}

