/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.compiler;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ide.fxgraph.fXGraph.ControllerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Element;
import org.eclipse.fx.ide.fxgraph.fXGraph.Import;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueElement;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.fxgraph.fXGraph.Property;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.SimpleValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticCallValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ValueProperty;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class FXGraphGenerator {
    public CharSequence generate(Model m) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _name = m.getPackage().getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _imports = m.getImports();
        for (Import i : _imports) {
            _builder.append("import ");
            String _importedNamespace = i.getImportedNamespace();
            _builder.append(_importedNamespace);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("component ");
        String _name_1 = m.getComponentDef().getName();
        _builder.append(_name_1);
        _builder.append(" ");
        JvmTypeReference _controller = m.getComponentDef().getController();
        boolean bl = _notEquals = !Objects.equals(_controller, null);
        if (_notEquals) {
            _builder.append("controlledby ");
            String _qualifiedName = m.getComponentDef().getController().getQualifiedName();
            _builder.append(_qualifiedName);
        }
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _element = this.element(m.getComponentDef().getRootNode());
        _builder.append((Object)_element, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence element(Element e) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _simpleName = e.getType().getType().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(" ");
        String _name = e.getName();
        boolean bl = _notEquals = !Objects.equals(_name, null);
        if (_notEquals) {
            _builder.append("id ");
            String _name_1 = e.getName();
            _builder.append(_name_1);
            _builder.append(" ");
        }
        _builder.append("{");
        _builder.newLineIfNotEmpty();
        EList _properties = e.getProperties();
        for (Property p : _properties) {
            boolean _notEquals_1;
            _builder.append("\t");
            Property _head = (Property)IterableExtensions.head((Iterable)e.getProperties());
            boolean bl2 = _notEquals_1 = !Objects.equals(_head, p);
            if (_notEquals_1) {
                _builder.append(",");
            }
            String _name_2 = p.getName();
            _builder.append(_name_2, "\t");
            _builder.append(" : ");
            CharSequence _valueProp = this.valueProp(p.getValue());
            _builder.append((Object)_valueProp, "\t");
            _builder.newLineIfNotEmpty();
        }
        EList _defaultChildren = e.getDefaultChildren();
        for (Element p_1 : _defaultChildren) {
            _builder.append("\t");
            if (!e.getProperties().isEmpty() || !Objects.equals(IterableExtensions.head((Iterable)e.getDefaultChildren()), p_1)) {
                _builder.append(",");
            }
            CharSequence _element = this.element(p_1);
            _builder.append((Object)_element, "\t");
            _builder.newLineIfNotEmpty();
        }
        EList _staticProperties = e.getStaticProperties();
        for (StaticValueProperty p_2 : _staticProperties) {
            _builder.append("\t");
            if (!(e.getProperties().isEmpty() && e.getDefaultChildren().isEmpty() && Objects.equals(IterableExtensions.head((Iterable)e.getStaticProperties()), p_2))) {
                _builder.append(",");
            }
            String _name_3 = p_2.getName();
            _builder.append(_name_3, "\t");
            _builder.append(" : ");
            CharSequence _valueProp_1 = this.valueProp(p_2.getValue());
            _builder.append((Object)_valueProp_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        EList _staticCallProperties = e.getStaticCallProperties();
        for (StaticCallValueProperty p_3 : _staticCallProperties) {
            _builder.append("\t");
            if (!e.getProperties().isEmpty() || !e.getDefaultChildren().isEmpty() || e.getStaticProperties().isEmpty() || !Objects.equals(IterableExtensions.head((Iterable)e.getStaticCallProperties()), p_3)) {
                _builder.append(",call ");
            }
            String _simpleName_1 = p_3.getType().getType().getSimpleName();
            _builder.append(_simpleName_1, "\t");
            _builder.append("#");
            String _name_4 = p_3.getName();
            _builder.append(_name_4, "\t");
            _builder.append(" : ");
            CharSequence _valueProp_2 = this.valueProp(p_3.getValue());
            _builder.append((Object)_valueProp_2, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _valueProp(ValueProperty p) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// unhandled type ");
        _builder.append((Object)p);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _valueProp(Element p) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _element = this.element(p);
        _builder.append((Object)_element);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _valueProp(ListValueProperty lp) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[");
        _builder.newLine();
        EList _value = lp.getValue();
        for (ListValueElement p : _value) {
            boolean _notEquals;
            _builder.append("\t");
            CharSequence _listValue = this.listValue((EObject)p);
            _builder.append((Object)_listValue, "\t");
            ListValueElement _last = (ListValueElement)lp.getValue().getLast();
            boolean bl = _notEquals = !Objects.equals(_last, p);
            if (_notEquals) {
                _builder.append(",");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append("]");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _valueProp(ControllerHandledValueProperty cp) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("controllermethod ");
        String _methodname = cp.getMethodname();
        _builder.append(_methodname);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _valueProp(SimpleValueProperty sp) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _booleanValue = sp.getBooleanValue();
        boolean bl = _notEquals = !Objects.equals(_booleanValue, null);
        if (_notEquals) {
            String _booleanValue_1 = sp.getBooleanValue();
            _builder.append(_booleanValue_1);
            _builder.newLineIfNotEmpty();
        } else {
            boolean _notEquals_1;
            String _number = sp.getNumber();
            boolean bl2 = _notEquals_1 = !Objects.equals(_number, null);
            if (_notEquals_1) {
                String _number_1 = sp.getNumber();
                _builder.append(_number_1);
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\"");
                String _stringValue = sp.getStringValue();
                _builder.append(_stringValue);
                _builder.append("\"");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected CharSequence _listValue(Element e) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _element = this.element(e);
        _builder.append((Object)_element);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _listValue(SimpleValueProperty sp) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _valueProp = this.valueProp((ValueProperty)sp);
        _builder.append((Object)_valueProp);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _listValue(ReferenceValueProperty rp) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    @XbaseGenerated
    public CharSequence valueProp(ValueProperty cp) {
        if (cp instanceof ControllerHandledValueProperty) {
            return this._valueProp((ControllerHandledValueProperty)cp);
        }
        if (cp instanceof Element) {
            return this._valueProp((Element)cp);
        }
        if (cp instanceof ListValueProperty) {
            return this._valueProp((ListValueProperty)cp);
        }
        if (cp instanceof SimpleValueProperty) {
            return this._valueProp((SimpleValueProperty)cp);
        }
        if (cp != null) {
            return this._valueProp(cp);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(cp).toString());
    }

    @XbaseGenerated
    public CharSequence listValue(EObject e) {
        if (e instanceof Element) {
            return this._listValue((Element)e);
        }
        if (e instanceof ReferenceValueProperty) {
            return this._listValue((ReferenceValueProperty)e);
        }
        if (e instanceof SimpleValueProperty) {
            return this._listValue((SimpleValueProperty)e);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(e).toString());
    }
}

