/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.gmodel.generator;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fx.ide.gmodel.gModelDSL.GDomainElement;
import org.eclipse.fx.ide.gmodel.gModelDSL.GDomainMap;
import org.eclipse.fx.ide.gmodel.gModelDSL.GDomainProperty;
import org.eclipse.fx.ide.gmodel.gModelDSL.GModel;
import org.eclipse.fx.ide.gmodel.generator.Util;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class GsonGenerator
implements IGenerator {
    public void doGenerate(Resource input, final IFileSystemAccess fsa) {
        EList _contents = input.getContents();
        EObject _head = (EObject)IterableExtensions.head((Iterable)_contents);
        final GModel root = (GModel)_head;
        String _name = root.getName();
        String _replace = _name.replace(".", "/");
        String _plus = String.valueOf(_replace) + "/gson/GsonBase.java";
        CharSequence _generateBase = this.generateBase(root);
        fsa.generateFile(_plus, _generateBase);
        EList<GDomainElement> _typeList = root.getTypeList();
        Consumer<GDomainElement> _function = new Consumer<GDomainElement>(){

            @Override
            public void accept(GDomainElement t) {
                String _name = root.getName();
                String _replace = _name.replace(".", "/");
                String _plus = String.valueOf(_replace) + "/gson/Gson";
                String _name_1 = t.getName();
                String _plus_1 = String.valueOf(_plus) + _name_1;
                String _plus_2 = String.valueOf(_plus_1) + "Impl.java";
                CharSequence _generateType = GsonGenerator.this.generateType(t, root);
                fsa.generateFile(_plus_2, _generateType);
            }
        };
        _typeList.forEach((Consumer)_function);
        String _name_1 = root.getName();
        String _replace_1 = _name_1.replace(".", "/");
        String _plus_1 = String.valueOf(_replace_1) + "/gson/GsonElementFactory.java";
        CharSequence _generateDeserializer = this.generateDeserializer(root);
        fsa.generateFile(_plus_1, _generateDeserializer);
    }

    public CharSequence generateBase(GModel m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)".gson;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import com.google.gson.JsonArray;");
        _builder.newLine();
        _builder.append((Object)"import com.google.gson.JsonElement;");
        _builder.newLine();
        _builder.append((Object)"import com.google.gson.JsonObject;");
        _builder.newLine();
        _builder.append((Object)"import java.util.List;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public interface GsonBase {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static JsonArray toJsonArray(List<JsonElement> list) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"JsonArray ar = new JsonArray();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"list.stream().forEach(ar::add);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ar;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static JsonArray toDomainJsonArray(List<?> list) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"JsonArray ar = new JsonArray();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"list.stream().map( e -> (GsonBase)e ).map(GsonBase::toJSONObject).forEach(ar::add);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return ar;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public JsonObject toJSONObject();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateType(GDomainElement e, GModel m) {
        boolean _notEquals_7;
        boolean _notEquals_6;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)".gson;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import ");
        String _name_1 = m.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)".*;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.google.gson.JsonObject;");
        _builder.newLine();
        _builder.newLine();
        EList<GDomainElement> _superTypeList = e.getSuperTypeList();
        Set<GDomainElement> superHierarchy = Util.collectHierarchicalList(_superTypeList);
        _builder.newLineIfNotEmpty();
        EList<GDomainProperty> _propertyList = e.getPropertyList();
        final HashSet<GDomainProperty> properties = new HashSet<GDomainProperty>((Collection<GDomainProperty>)_propertyList);
        _builder.newLineIfNotEmpty();
        Consumer<GDomainElement> _function = new Consumer<GDomainElement>(){

            @Override
            public void accept(GDomainElement s) {
                EList<GDomainProperty> _propertyList = s.getPropertyList();
                properties.addAll(_propertyList);
            }
        };
        superHierarchy.forEach(_function);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public final class Gson");
        String _name_2 = e.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"Impl implements GsonBase, ");
        String _name_3 = e.getName();
        _builder.append((Object)_name_3, "");
        EList<GDomainElement> _superTypeList_1 = e.getSuperTypeList();
        boolean _isEmpty = _superTypeList_1.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)", ");
            Functions.Function1<GDomainElement, String> _function_1 = new Functions.Function1<GDomainElement, String>(){

                public String apply(GDomainElement v) {
                    return v.getName();
                }
            };
            List _sortBy = IterableExtensions.sortBy(superHierarchy, (Functions.Function1)_function_1);
            Functions.Function1<GDomainElement, String> _function_2 = new Functions.Function1<GDomainElement, String>(){

                public String apply(GDomainElement v) {
                    return v.getName();
                }
            };
            List _map = ListExtensions.map((List)_sortBy, (Functions.Function1)_function_2);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
            _builder.append((Object)_join, "");
        }
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Gson");
        String _name_4 = e.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)"Impl(JsonObject jsonObject) {");
        _builder.newLineIfNotEmpty();
        GDomainMap _map_1 = e.getMap();
        boolean bl2 = _notEquals = !Objects.equal((Object)_map_1, null);
        if (_notEquals) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"this.propertyMap = toMap(jsonObject);");
            _builder.newLine();
        } else {
            Functions.Function1<GDomainProperty, String> _function_3 = new Functions.Function1<GDomainProperty, String>(){

                public String apply(GDomainProperty p) {
                    return p.getName();
                }
            };
            List _sortBy_1 = IterableExtensions.sortBy(properties, (Functions.Function1)_function_3);
            for (GDomainProperty p : _sortBy_1) {
                _builder.append((Object)"\t\t");
                CharSequence _generatePropertyInit = this.generatePropertyInit(p);
                _builder.append((Object)_generatePropertyInit, "\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        GDomainMap _map_2 = e.getMap();
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)_map_2, null);
        if (_notEquals_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public Gson");
            String _name_5 = e.getName();
            _builder.append((Object)_name_5, "\t");
            _builder.append((Object)"Impl(java.util.Map<String,");
            GDomainMap _map_3 = e.getMap();
            String _plainType = GsonGenerator.getPlainType(_map_3);
            _builder.append((Object)_plainType, "\t");
            _builder.append((Object)"> propertyMap) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.propertyMap = propertyMap;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"public Gson");
            String _name_6 = e.getName();
            _builder.append((Object)_name_6, "\t");
            _builder.append((Object)"Impl(");
            Functions.Function1<GDomainProperty, String> _function_4 = new Functions.Function1<GDomainProperty, String>(){

                public String apply(GDomainProperty p) {
                    return p.getName();
                }
            };
            List _sortBy_2 = IterableExtensions.sortBy(properties, (Functions.Function1)_function_4);
            Functions.Function1<GDomainProperty, String> _function_5 = new Functions.Function1<GDomainProperty, String>(){

                public String apply(GDomainProperty p) {
                    String _type = GsonGenerator.getType(p);
                    String _plus = String.valueOf(_type) + " ";
                    String _name = p.getName();
                    return String.valueOf(_plus) + _name;
                }
            };
            List _map_4 = ListExtensions.map((List)_sortBy_2, (Functions.Function1)_function_5);
            String _join_1 = IterableExtensions.join((Iterable)_map_4, (CharSequence)", ");
            _builder.append((Object)_join_1, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            Functions.Function1<GDomainProperty, String> _function_6 = new Functions.Function1<GDomainProperty, String>(){

                public String apply(GDomainProperty p) {
                    return p.getName();
                }
            };
            List _sortBy_3 = IterableExtensions.sortBy(properties, (Functions.Function1)_function_6);
            for (GDomainProperty p_1 : _sortBy_3) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"this.");
                String _name_7 = p_1.getName();
                _builder.append((Object)_name_7, "\t\t");
                _builder.append((Object)" = ");
                String _name_8 = p_1.getName();
                _builder.append((Object)_name_8, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public JsonObject toJSONObject() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"JsonObject o = new JsonObject();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"o.addProperty( \"$gtype\", \"");
        String _name_9 = e.getName();
        _builder.append((Object)_name_9, "\t\t");
        _builder.append((Object)"\" );");
        _builder.newLineIfNotEmpty();
        GDomainMap _map_5 = e.getMap();
        boolean bl4 = _notEquals_2 = !Objects.equal((Object)_map_5, null);
        if (_notEquals_2) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"for( java.util.Map.Entry<String,");
            GDomainMap _map_6 = e.getMap();
            String _plainType_1 = GsonGenerator.getPlainType(_map_6);
            _builder.append((Object)_plainType_1, "\t\t");
            _builder.append((Object)"> e : this.propertyMap ) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"o.add( e.getKey(), ((GsonBase)e.getValue()).toJSONObject() );");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            Functions.Function1<GDomainProperty, String> _function_7 = new Functions.Function1<GDomainProperty, String>(){

                public String apply(GDomainProperty p) {
                    return p.getName();
                }
            };
            List _sortBy_4 = IterableExtensions.sortBy(properties, (Functions.Function1)_function_7);
            for (GDomainProperty p_2 : _sortBy_4) {
                _builder.append((Object)"\t\t");
                CharSequence _generatePropertyToJson = this.generatePropertyToJson(p_2);
                _builder.append((Object)_generatePropertyToJson, "\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return o;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String toString() {");
        _builder.newLine();
        GDomainMap _map_7 = e.getMap();
        boolean bl5 = _notEquals_3 = !Objects.equal((Object)_map_7, null);
        if (_notEquals_3) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return getClass().getSimpleName() + \"@\" + Integer.toHexString(hashCode()) + \" { \"");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"+ \"propertyMap : \" + propertyMap");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"+\" }\";");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return getClass().getSimpleName() + \"@\" + Integer.toHexString(hashCode()) + \" { \"");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t\t");
            Functions.Function1<GDomainProperty, String> _function_8 = new Functions.Function1<GDomainProperty, String>(){

                public String apply(GDomainProperty p) {
                    return p.getName();
                }
            };
            List _sortBy_5 = IterableExtensions.sortBy(properties, (Functions.Function1)_function_8);
            Functions.Function1<GDomainProperty, String> _function_9 = new Functions.Function1<GDomainProperty, String>(){

                public String apply(GDomainProperty p) {
                    boolean _notEquals;
                    String _xifexpression = null;
                    String _builtIn = p.getBuiltIn();
                    boolean bl = _notEquals = !Objects.equal((Object)_builtIn, null);
                    if (_notEquals) {
                        String _name = p.getName();
                        String _plus = " + \"" + _name;
                        String _plus_1 = String.valueOf(_plus) + " : \" + ";
                        String _name_1 = p.getName();
                        _xifexpression = String.valueOf(_plus_1) + _name_1;
                    } else {
                        String _xifexpression_1 = null;
                        boolean _isList = p.isList();
                        if (_isList) {
                            String _name_2 = p.getName();
                            String _plus_2 = " + \"" + _name_2;
                            String _plus_3 = String.valueOf(_plus_2) + " : \" + ";
                            String _name_3 = p.getName();
                            String _plus_4 = String.valueOf(_plus_3) + _name_3;
                            _xifexpression_1 = String.valueOf(_plus_4) + ".stream().map( e -> e.getClass().getSimpleName() + \"@\" + Integer.toHexString(e.hashCode()) ).collect(java.util.stream.Collectors.toList())";
                        } else {
                            String _name_4 = p.getName();
                            String _plus_5 = " + \"" + _name_4;
                            String _plus_6 = String.valueOf(_plus_5) + " : \" + (";
                            String _name_5 = p.getName();
                            String _plus_7 = String.valueOf(_plus_6) + _name_5;
                            String _plus_8 = String.valueOf(_plus_7) + " == null ? null : ";
                            String _name_6 = p.getName();
                            String _plus_9 = String.valueOf(_plus_8) + _name_6;
                            String _plus_10 = String.valueOf(_plus_9) + ".getClass().getSimpleName() + \"@\" + Integer.toHexString(";
                            String _name_7 = p.getName();
                            String _plus_11 = String.valueOf(_plus_10) + _name_7;
                            _xifexpression_1 = String.valueOf(_plus_11) + ".hashCode()))";
                        }
                        _xifexpression = _xifexpression_1;
                    }
                    return _xifexpression;
                }
            };
            List _map_8 = ListExtensions.map((List)_sortBy_5, (Functions.Function1)_function_9);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)" ");
            _builder_1.append((Object)"+ \", \"");
            _builder_1.newLine();
            String _join_2 = IterableExtensions.join((Iterable)_map_8, (CharSequence)_builder_1);
            _builder.append((Object)_join_2, "\t\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"+\" }\";");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        GDomainMap _map_9 = e.getMap();
        boolean bl6 = _notEquals_4 = !Objects.equal((Object)_map_9, null);
        if (_notEquals_4) {
            boolean _notEquals_5;
            _builder.append((Object)"\t");
            _builder.append((Object)"private static java.util.Map<String,");
            GDomainMap _map_10 = e.getMap();
            String _plainType_2 = GsonGenerator.getPlainType(_map_10);
            _builder.append((Object)_plainType_2, "\t");
            _builder.append((Object)"> toMap(JsonObject o) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"java.util.Map<String,");
            GDomainMap _map_11 = e.getMap();
            String _plainType_3 = GsonGenerator.getPlainType(_map_11);
            _builder.append((Object)_plainType_3, "\t\t");
            _builder.append((Object)"> rv = new java.util.HashMap<>();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"for( java.util.Map.Entry<String,com.google.gson.JsonElement> e : o.entrySet() ) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if( e.getKey().startsWith(\"$\") ) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"continue;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            GDomainMap _map_12 = e.getMap();
            GDomainElement _ref = _map_12.getRef();
            boolean bl7 = _notEquals_5 = !Objects.equal((Object)_ref, null);
            if (_notEquals_5) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t");
                _builder.append((Object)"rv.put( e.getKey(), GsonElementFactory.create");
                GDomainMap _map_13 = e.getMap();
                GDomainElement _ref_1 = _map_13.getRef();
                String _name_10 = _ref_1.getName();
                _builder.append((Object)_name_10, "\t\t\t");
                _builder.append((Object)"(e.getValue().getAsJsonObject()) );");
                _builder.newLineIfNotEmpty();
            } else {
                GDomainMap _map_14 = e.getMap();
                String _plainType_4 = GsonGenerator.getPlainType(_map_14);
                boolean _equals = Objects.equal((Object)_plainType_4, (Object)"boolean");
                if (_equals) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"rv.put( e.getKey(), e.getValue().getAsBoolean() );");
                    _builder.newLine();
                } else {
                    GDomainMap _map_15 = e.getMap();
                    String _plainType_5 = GsonGenerator.getPlainType(_map_15);
                    boolean _equals_1 = Objects.equal((Object)_plainType_5, (Object)"int");
                    if (_equals_1) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"rv.put( e.getKey(), e.getValue().getAsInt() );");
                        _builder.newLine();
                    } else {
                        GDomainMap _map_16 = e.getMap();
                        String _plainType_6 = GsonGenerator.getPlainType(_map_16);
                        boolean _equals_2 = Objects.equal((Object)_plainType_6, (Object)"double");
                        if (_equals_2) {
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"rv.put( e.getKey(), e.getValue().getAsDouble() );");
                            _builder.newLine();
                        } else {
                            GDomainMap _map_17 = e.getMap();
                            String _plainType_7 = GsonGenerator.getPlainType(_map_17);
                            boolean _equals_3 = Objects.equal((Object)_plainType_7, (Object)"String");
                            if (_equals_3) {
                                _builder.append((Object)"\t");
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"rv.put( e.getKey(), e.getValue().getAsString() );");
                                _builder.newLine();
                            }
                        }
                    }
                }
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return rv;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private java.util.Map<String,");
            GDomainMap _map_18 = e.getMap();
            String _plainType_8 = GsonGenerator.getPlainType(_map_18);
            _builder.append((Object)_plainType_8, "\t");
            _builder.append((Object)"> propertyMap;");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"public java.util.Map<String,");
            GDomainMap _map_19 = e.getMap();
            String _plainType_9 = GsonGenerator.getPlainType(_map_19);
            _builder.append((Object)_plainType_9, "\t");
            _builder.append((Object)"> getPropertyMap() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return this.propertyMap;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            Functions.Function1<GDomainProperty, String> _function_10 = new Functions.Function1<GDomainProperty, String>(){

                public String apply(GDomainProperty p) {
                    return p.getName();
                }
            };
            List _sortBy_6 = IterableExtensions.sortBy(properties, (Functions.Function1)_function_10);
            for (GDomainProperty p_3 : _sortBy_6) {
                _builder.append((Object)"\t");
                CharSequence _generatePropertyEntry = this.generatePropertyEntry(p_3);
                _builder.append((Object)_generatePropertyEntry, "\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        Resource _eResource = m.eResource();
        URI _uRI = _eResource.getURI();
        String _lastSegment = _uRI.lastSegment();
        Resource _eResource_1 = m.eResource();
        URI _uRI_1 = _eResource_1.getURI();
        String _lastSegment_1 = _uRI_1.lastSegment();
        int _length = _lastSegment_1.length();
        int _minus = _length - 5;
        String name = _lastSegment.substring(0, _minus);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static class Builder implements ");
        String _name_11 = e.getName();
        _builder.append((Object)_name_11, "\t");
        _builder.append((Object)".Builder {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"private final ");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)"GModel instance;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public Builder(");
        _builder.append((Object)name, "\t\t");
        _builder.append((Object)"GModel instance) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"this.instance = instance;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        GDomainMap _map_20 = e.getMap();
        boolean bl8 = _notEquals_6 = !Objects.equal((Object)_map_20, null);
        if (_notEquals_6) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"java.util.Map<String,");
            GDomainMap _map_21 = e.getMap();
            String _plainType_10 = GsonGenerator.getPlainType(_map_21);
            _builder.append((Object)_plainType_10, "\t\t");
            _builder.append((Object)"> propertyMap = new java.util.HashMap<>();");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"public Builder propertyMap(java.util.Map<String,");
            GDomainMap _map_22 = e.getMap();
            String _plainType_11 = GsonGenerator.getPlainType(_map_22);
            _builder.append((Object)_plainType_11, "\t\t");
            _builder.append((Object)"> propertyMap) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.propertyMap.putAll(propertyMap);");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return this;");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"public Builder propertyMap(String key, ");
            GDomainMap _map_23 = e.getMap();
            String _plainType_12 = GsonGenerator.getPlainType(_map_23);
            _builder.append((Object)_plainType_12, "\t\t");
            _builder.append((Object)" value) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.propertyMap.put(key,value);");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return this;");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"public Builder propertyMap(String key, java.util.function.Function<");
            GDomainMap _map_24 = e.getMap();
            String _plainType_13 = GsonGenerator.getPlainType(_map_24);
            _builder.append((Object)_plainType_13, "\t\t");
            _builder.append((Object)".Builder,");
            GDomainMap _map_25 = e.getMap();
            String _plainType_14 = GsonGenerator.getPlainType(_map_25);
            _builder.append((Object)_plainType_14, "\t\t");
            _builder.append((Object)"> provider) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.propertyMap.put(key,provider.apply( new Gson");
            GDomainMap _map_26 = e.getMap();
            String _plainType_15 = GsonGenerator.getPlainType(_map_26);
            _builder.append((Object)_plainType_15, "\t\t\t");
            _builder.append((Object)"Impl.Builder(instance) ) );");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return this;");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"public Builder propertyMap(java.util.function.Function<");
            _builder.append((Object)name, "\t\t");
            _builder.append((Object)"GModel,java.util.Map<String,");
            GDomainMap _map_27 = e.getMap();
            String _plainType_16 = GsonGenerator.getPlainType(_map_27);
            _builder.append((Object)_plainType_16, "\t\t");
            _builder.append((Object)">> provider) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"this.propertyMap.putAll(provider.apply( instance ) );");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return this;");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            Functions.Function1<GDomainProperty, String> _function_11 = new Functions.Function1<GDomainProperty, String>(){

                public String apply(GDomainProperty p) {
                    return p.getName();
                }
            };
            List _sortBy_7 = IterableExtensions.sortBy(properties, (Functions.Function1)_function_11);
            for (GDomainProperty p_4 : _sortBy_7) {
                boolean _isList = p_4.isList();
                if (_isList) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"private final ");
                    String _type = GsonGenerator.getType(p_4);
                    _builder.append((Object)_type, "\t\t");
                    _builder.append((Object)" ");
                    String _name_12 = p_4.getName();
                    _builder.append((Object)_name_12, "\t\t");
                    _builder.append((Object)" = new java.util.ArrayList<>();");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"public Builder ");
                    String _name_13 = p_4.getName();
                    _builder.append((Object)_name_13, "\t\t");
                    _builder.append((Object)"(");
                    String _type_1 = GsonGenerator.getType(p_4);
                    _builder.append((Object)_type_1, "\t\t");
                    _builder.append((Object)" ");
                    String _name_14 = p_4.getName();
                    _builder.append((Object)_name_14, "\t\t");
                    _builder.append((Object)") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"this.");
                    String _name_15 = p_4.getName();
                    _builder.append((Object)_name_15, "\t\t\t");
                    _builder.append((Object)".addAll(");
                    String _name_16 = p_4.getName();
                    _builder.append((Object)_name_16, "\t\t\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return this;");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"public Builder append");
                    String _name_17 = p_4.getName();
                    String _firstUpper = StringExtensions.toFirstUpper((String)_name_17);
                    _builder.append((Object)_firstUpper, "\t\t");
                    _builder.append((Object)"(");
                    String _plainType_17 = GsonGenerator.getPlainType(p_4);
                    _builder.append((Object)_plainType_17, "\t\t");
                    _builder.append((Object)" ");
                    String _name_18 = p_4.getName();
                    _builder.append((Object)_name_18, "\t\t");
                    _builder.append((Object)") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"this.");
                    String _name_19 = p_4.getName();
                    _builder.append((Object)_name_19, "\t\t\t");
                    _builder.append((Object)".add(");
                    String _name_20 = p_4.getName();
                    _builder.append((Object)_name_20, "\t\t\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return this;");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    String _builtIn = p_4.getBuiltIn();
                    boolean _equals_4 = Objects.equal((Object)_builtIn, null);
                    if (!_equals_4) continue;
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"public Builder ");
                    String _name_21 = p_4.getName();
                    _builder.append((Object)_name_21, "\t\t");
                    _builder.append((Object)"(java.util.function.Function<");
                    _builder.append((Object)name, "\t\t");
                    _builder.append((Object)"GModel,java.util.List<");
                    String _plainType_18 = GsonGenerator.getPlainType(p_4);
                    _builder.append((Object)_plainType_18, "\t\t");
                    _builder.append((Object)">> provider) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    String _name_22 = p_4.getName();
                    _builder.append((Object)_name_22, "\t\t\t");
                    _builder.append((Object)"( provider.apply( instance ) );");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return this;");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"public Builder append");
                    String _name_23 = p_4.getName();
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_23);
                    _builder.append((Object)_firstUpper_1, "\t\t");
                    _builder.append((Object)"(java.util.function.Function<");
                    String _plainType_19 = GsonGenerator.getPlainType(p_4);
                    _builder.append((Object)_plainType_19, "\t\t");
                    _builder.append((Object)".Builder,");
                    String _plainType_20 = GsonGenerator.getPlainType(p_4);
                    _builder.append((Object)_plainType_20, "\t\t");
                    _builder.append((Object)"> provider) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"append");
                    String _name_24 = p_4.getName();
                    String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_24);
                    _builder.append((Object)_firstUpper_2, "\t\t\t");
                    _builder.append((Object)"( provider.apply( new Gson");
                    String _plainType_21 = GsonGenerator.getPlainType(p_4);
                    _builder.append((Object)_plainType_21, "\t\t\t");
                    _builder.append((Object)"Impl.Builder(instance) ) );");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return this;");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    continue;
                }
                _builder.append((Object)"\t\t");
                _builder.append((Object)"private ");
                String _type_2 = GsonGenerator.getType(p_4);
                _builder.append((Object)_type_2, "\t\t");
                _builder.append((Object)" ");
                String _name_25 = p_4.getName();
                _builder.append((Object)_name_25, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"public Builder ");
                String _name_26 = p_4.getName();
                _builder.append((Object)_name_26, "\t\t");
                _builder.append((Object)"(");
                String _type_3 = GsonGenerator.getType(p_4);
                _builder.append((Object)_type_3, "\t\t");
                _builder.append((Object)" ");
                String _name_27 = p_4.getName();
                _builder.append((Object)_name_27, "\t\t");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"this.");
                String _name_28 = p_4.getName();
                _builder.append((Object)_name_28, "\t\t\t");
                _builder.append((Object)" = ");
                String _name_29 = p_4.getName();
                _builder.append((Object)_name_29, "\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return this;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public ");
        String _name_30 = e.getName();
        _builder.append((Object)_name_30, "\t\t");
        _builder.append((Object)" build() {");
        _builder.newLineIfNotEmpty();
        GDomainMap _map_28 = e.getMap();
        boolean bl9 = _notEquals_7 = !Objects.equal((Object)_map_28, null);
        if (_notEquals_7) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"return new Gson");
            String _name_31 = e.getName();
            _builder.append((Object)_name_31, "\t\t\t");
            _builder.append((Object)"Impl(propertyMap);");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"return new Gson");
            String _name_32 = e.getName();
            _builder.append((Object)_name_32, "\t\t\t");
            _builder.append((Object)"Impl(");
            Functions.Function1<GDomainProperty, String> _function_12 = new Functions.Function1<GDomainProperty, String>(){

                public String apply(GDomainProperty p) {
                    return p.getName();
                }
            };
            List _sortBy_8 = IterableExtensions.sortBy(properties, (Functions.Function1)_function_12);
            Functions.Function1<GDomainProperty, String> _function_13 = new Functions.Function1<GDomainProperty, String>(){

                public String apply(GDomainProperty p) {
                    return p.getName();
                }
            };
            List _map_29 = ListExtensions.map((List)_sortBy_8, (Functions.Function1)_function_13);
            String _join_3 = IterableExtensions.join((Iterable)_map_29, (CharSequence)", ");
            _builder.append((Object)_join_3, "\t\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePropertyToJson(GDomainProperty p) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isList = p.isList();
        if (_isList) {
            String _plainType = GsonGenerator.getPlainType(p);
            boolean _equals = Objects.equal((Object)_plainType, (Object)"boolean");
            if (_equals) {
                _builder.append((Object)"o.add( \"");
                String _name = p.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"\", GsonBase.toJsonArray(get");
                String _name_1 = p.getName();
                String _firstUpper = StringExtensions.toFirstUpper((String)_name_1);
                _builder.append((Object)_firstUpper, "");
                _builder.append((Object)"().stream().map(com.google.gson.JsonPrimitive::new).collect(java.util.stream.Collectors.toList())) );");
                _builder.newLineIfNotEmpty();
            } else {
                String _plainType_1 = GsonGenerator.getPlainType(p);
                boolean _equals_1 = Objects.equal((Object)_plainType_1, (Object)"int");
                if (_equals_1) {
                    _builder.append((Object)"o.add( \"");
                    String _name_2 = p.getName();
                    _builder.append((Object)_name_2, "");
                    _builder.append((Object)"\", GsonBase.toJsonArray(get");
                    String _name_3 = p.getName();
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_3);
                    _builder.append((Object)_firstUpper_1, "");
                    _builder.append((Object)"().stream().map(com.google.gson.JsonPrimitive::new).collect(java.util.stream.Collectors.toList())) );");
                    _builder.newLineIfNotEmpty();
                } else {
                    String _plainType_2 = GsonGenerator.getPlainType(p);
                    boolean _equals_2 = Objects.equal((Object)_plainType_2, (Object)"double");
                    if (_equals_2) {
                        _builder.append((Object)"o.add( \"");
                        String _name_4 = p.getName();
                        _builder.append((Object)_name_4, "");
                        _builder.append((Object)"\", GsonBase.toJsonArray(get");
                        String _name_5 = p.getName();
                        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_5);
                        _builder.append((Object)_firstUpper_2, "");
                        _builder.append((Object)"().stream().map(com.google.gson.JsonPrimitive::new).collect(java.util.stream.Collectors.toList())) );");
                        _builder.newLineIfNotEmpty();
                    } else {
                        String _plainType_3 = GsonGenerator.getPlainType(p);
                        boolean _equals_3 = Objects.equal((Object)_plainType_3, (Object)"String");
                        if (_equals_3) {
                            _builder.append((Object)"o.add( \"");
                            String _name_6 = p.getName();
                            _builder.append((Object)_name_6, "");
                            _builder.append((Object)"\", GsonBase.toJsonArray(get");
                            String _name_7 = p.getName();
                            String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_7);
                            _builder.append((Object)_firstUpper_3, "");
                            _builder.append((Object)"().stream().map(com.google.gson.JsonPrimitive::new).collect(java.util.stream.Collectors.toList())) );");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append((Object)"o.add( \"");
                            String _name_8 = p.getName();
                            _builder.append((Object)_name_8, "");
                            _builder.append((Object)"\", GsonBase.toDomainJsonArray(get");
                            String _name_9 = p.getName();
                            String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_9);
                            _builder.append((Object)_firstUpper_4, "");
                            _builder.append((Object)"()) );");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                }
            }
        } else {
            String _type = GsonGenerator.getType(p);
            boolean _equals_4 = Objects.equal((Object)_type, (Object)"boolean");
            if (_equals_4) {
                _builder.append((Object)"o.addProperty( \"");
                String _name_10 = p.getName();
                _builder.append((Object)_name_10, "");
                _builder.append((Object)"\", is");
                String _name_11 = p.getName();
                String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_11);
                _builder.append((Object)_firstUpper_5, "");
                _builder.append((Object)"() );");
                _builder.newLineIfNotEmpty();
            } else {
                String _type_1 = GsonGenerator.getType(p);
                boolean _equals_5 = Objects.equal((Object)_type_1, (Object)"int");
                if (_equals_5) {
                    _builder.append((Object)"o.addProperty( \"");
                    String _name_12 = p.getName();
                    _builder.append((Object)_name_12, "");
                    _builder.append((Object)"\", get");
                    String _name_13 = p.getName();
                    String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_13);
                    _builder.append((Object)_firstUpper_6, "");
                    _builder.append((Object)"() );");
                    _builder.newLineIfNotEmpty();
                } else {
                    String _type_2 = GsonGenerator.getType(p);
                    boolean _equals_6 = Objects.equal((Object)_type_2, (Object)"double");
                    if (_equals_6) {
                        _builder.append((Object)"o.addProperty( \"");
                        String _name_14 = p.getName();
                        _builder.append((Object)_name_14, "");
                        _builder.append((Object)"\", get");
                        String _name_15 = p.getName();
                        String _firstUpper_7 = StringExtensions.toFirstUpper((String)_name_15);
                        _builder.append((Object)_firstUpper_7, "");
                        _builder.append((Object)"() );");
                        _builder.newLineIfNotEmpty();
                    } else {
                        String _type_3 = GsonGenerator.getType(p);
                        boolean _equals_7 = Objects.equal((Object)_type_3, (Object)"String");
                        if (_equals_7) {
                            _builder.append((Object)"o.addProperty( \"");
                            String _name_16 = p.getName();
                            _builder.append((Object)_name_16, "");
                            _builder.append((Object)"\", get");
                            String _name_17 = p.getName();
                            String _firstUpper_8 = StringExtensions.toFirstUpper((String)_name_17);
                            _builder.append((Object)_firstUpper_8, "");
                            _builder.append((Object)"() );");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append((Object)"o.add( \"");
                            String _name_18 = p.getName();
                            _builder.append((Object)_name_18, "");
                            _builder.append((Object)"\", get");
                            String _name_19 = p.getName();
                            String _firstUpper_9 = StringExtensions.toFirstUpper((String)_name_19);
                            _builder.append((Object)_firstUpper_9, "");
                            _builder.append((Object)"() == null ? null : ((GsonBase)get");
                            String _name_20 = p.getName();
                            String _firstUpper_10 = StringExtensions.toFirstUpper((String)_name_20);
                            _builder.append((Object)_firstUpper_10, "");
                            _builder.append((Object)"()).toJSONObject() );");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                }
            }
        }
        return _builder;
    }

    public CharSequence generatePropertyInit(GDomainProperty p) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isList = p.isList();
        if (_isList) {
            String _plainType = GsonGenerator.getPlainType(p);
            boolean _equals = Objects.equal((Object)_plainType, (Object)"boolean");
            if (_equals) {
                _builder.append((Object)"this.");
                String _name = p.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)" = jsonObject.has(\"");
                String _name_1 = p.getName();
                _builder.append((Object)_name_1, "");
                _builder.append((Object)"\") ? java.util.Collections.unmodifiableList(java.util.stream.StreamSupport.stream( jsonObject.getAsJsonArray(\"");
                String _name_2 = p.getName();
                _builder.append((Object)_name_2, "");
                _builder.append((Object)"\").spliterator(), false )");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t\t\t");
                _builder.append((Object)".map( e -> e.getAsBoolean()).collect(java.util.stream.Collectors.toList())) : java.util.Collections.emptyList();");
                _builder.newLine();
            } else {
                String _plainType_1 = GsonGenerator.getPlainType(p);
                boolean _equals_1 = Objects.equal((Object)_plainType_1, (Object)"int");
                if (_equals_1) {
                    _builder.append((Object)"this.");
                    String _name_3 = p.getName();
                    _builder.append((Object)_name_3, "");
                    _builder.append((Object)" = jsonObject.has(\"");
                    String _name_4 = p.getName();
                    _builder.append((Object)_name_4, "");
                    _builder.append((Object)"\") ? java.util.Collections.unmodifiableList(java.util.stream.StreamSupport.stream( jsonObject.getAsJsonArray(\"");
                    String _name_5 = p.getName();
                    _builder.append((Object)_name_5, "");
                    _builder.append((Object)"\").spliterator(), false )");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t\t\t\t");
                    _builder.append((Object)".map( e -> e.getAsInt()).collect(java.util.stream.Collectors.toList())) : java.util.Collections.emptyList();");
                    _builder.newLine();
                } else {
                    String _plainType_2 = GsonGenerator.getPlainType(p);
                    boolean _equals_2 = Objects.equal((Object)_plainType_2, (Object)"double");
                    if (_equals_2) {
                        _builder.append((Object)"this.");
                        String _name_6 = p.getName();
                        _builder.append((Object)_name_6, "");
                        _builder.append((Object)" = jsonObject.has(\"");
                        String _name_7 = p.getName();
                        _builder.append((Object)_name_7, "");
                        _builder.append((Object)"\") ? java.util.Collections.unmodifiableList(java.util.stream.StreamSupport.stream( jsonObject.getAsJsonArray(\"");
                        String _name_8 = p.getName();
                        _builder.append((Object)_name_8, "");
                        _builder.append((Object)"\").spliterator(), false )");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t\t\t\t\t");
                        _builder.append((Object)".map( e -> e.getAsDouble()).collect(java.util.stream.Collectors.toList())) : java.util.Collections.emptyList();");
                        _builder.newLine();
                    } else {
                        String _plainType_3 = GsonGenerator.getPlainType(p);
                        boolean _equals_3 = Objects.equal((Object)_plainType_3, (Object)"String");
                        if (_equals_3) {
                            _builder.append((Object)"this.");
                            String _name_9 = p.getName();
                            _builder.append((Object)_name_9, "");
                            _builder.append((Object)" = jsonObject.has(\"");
                            String _name_10 = p.getName();
                            _builder.append((Object)_name_10, "");
                            _builder.append((Object)"\") ? java.util.Collections.unmodifiableList(java.util.stream.StreamSupport.stream( jsonObject.getAsJsonArray(\"");
                            String _name_11 = p.getName();
                            _builder.append((Object)_name_11, "");
                            _builder.append((Object)"\").spliterator(), false )");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t\t\t\t\t");
                            _builder.append((Object)".map( e -> e.getAsString()).collect(java.util.stream.Collectors.toList())) : java.util.Collections.emptyList();");
                            _builder.newLine();
                        } else {
                            _builder.append((Object)"this.");
                            String _name_12 = p.getName();
                            _builder.append((Object)_name_12, "");
                            _builder.append((Object)" = jsonObject.has(\"");
                            String _name_13 = p.getName();
                            _builder.append((Object)_name_13, "");
                            _builder.append((Object)"\") ? java.util.Collections.unmodifiableList(java.util.stream.StreamSupport.stream( jsonObject.getAsJsonArray(\"");
                            String _name_14 = p.getName();
                            _builder.append((Object)_name_14, "");
                            _builder.append((Object)"\").spliterator(), false )");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t\t\t\t\t");
                            _builder.append((Object)".map( e -> GsonElementFactory.create");
                            GDomainElement _ref = p.getRef();
                            String _name_15 = _ref.getName();
                            _builder.append((Object)_name_15, "\t\t\t\t\t\t");
                            _builder.append((Object)"(e.getAsJsonObject())).collect(java.util.stream.Collectors.toList())) : java.util.Collections.emptyList();");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                }
            }
        } else {
            String _type = GsonGenerator.getType(p);
            boolean _equals_4 = Objects.equal((Object)_type, (Object)"boolean");
            if (_equals_4) {
                boolean _notEquals;
                _builder.append((Object)"this.");
                String _name_16 = p.getName();
                _builder.append((Object)_name_16, "");
                _builder.append((Object)" = jsonObject.has(\"");
                String _name_17 = p.getName();
                _builder.append((Object)_name_17, "");
                _builder.append((Object)"\") ? jsonObject.get(\"");
                String _name_18 = p.getName();
                _builder.append((Object)_name_18, "");
                _builder.append((Object)"\").getAsBoolean() : ");
                String _value = Util.getValue(p);
                boolean bl = _notEquals = !Objects.equal((Object)_value, null);
                if (_notEquals) {
                    String _value_1 = Util.getValue(p);
                    _builder.append((Object)_value_1, "");
                } else {
                    _builder.append((Object)"false");
                }
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            } else {
                String _type_1 = GsonGenerator.getType(p);
                boolean _equals_5 = Objects.equal((Object)_type_1, (Object)"int");
                if (_equals_5) {
                    boolean _notEquals_1;
                    _builder.append((Object)"this.");
                    String _name_19 = p.getName();
                    _builder.append((Object)_name_19, "");
                    _builder.append((Object)" = jsonObject.has(\"");
                    String _name_20 = p.getName();
                    _builder.append((Object)_name_20, "");
                    _builder.append((Object)"\") ? jsonObject.get(\"");
                    String _name_21 = p.getName();
                    _builder.append((Object)_name_21, "");
                    _builder.append((Object)"\").getAsInt() : ");
                    String _value_2 = Util.getValue(p);
                    boolean bl = _notEquals_1 = !Objects.equal((Object)_value_2, null);
                    if (_notEquals_1) {
                        String _value_3 = Util.getValue(p);
                        _builder.append((Object)_value_3, "");
                    } else {
                        _builder.append((Object)"0");
                    }
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                } else {
                    String _type_2 = GsonGenerator.getType(p);
                    boolean _equals_6 = Objects.equal((Object)_type_2, (Object)"double");
                    if (_equals_6) {
                        boolean _notEquals_2;
                        _builder.append((Object)"this.");
                        String _name_22 = p.getName();
                        _builder.append((Object)_name_22, "");
                        _builder.append((Object)" = jsonObject.has(\"");
                        String _name_23 = p.getName();
                        _builder.append((Object)_name_23, "");
                        _builder.append((Object)"\") ? jsonObject.get(\"");
                        String _name_24 = p.getName();
                        _builder.append((Object)_name_24, "");
                        _builder.append((Object)"\").getAsDouble() : ");
                        String _value_4 = Util.getValue(p);
                        boolean bl = _notEquals_2 = !Objects.equal((Object)_value_4, null);
                        if (_notEquals_2) {
                            String _value_5 = Util.getValue(p);
                            _builder.append((Object)_value_5, "");
                        } else {
                            _builder.append((Object)"0.0");
                        }
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                    } else {
                        String _type_3 = GsonGenerator.getType(p);
                        boolean _equals_7 = Objects.equal((Object)_type_3, (Object)"String");
                        if (_equals_7) {
                            boolean _notEquals_3;
                            _builder.append((Object)"this.");
                            String _name_25 = p.getName();
                            _builder.append((Object)_name_25, "");
                            _builder.append((Object)" = jsonObject.has(\"");
                            String _name_26 = p.getName();
                            _builder.append((Object)_name_26, "");
                            _builder.append((Object)"\") ? jsonObject.get(\"");
                            String _name_27 = p.getName();
                            _builder.append((Object)_name_27, "");
                            _builder.append((Object)"\").getAsString() : ");
                            String _value_6 = Util.getValue(p);
                            boolean bl = _notEquals_3 = !Objects.equal((Object)_value_6, null);
                            if (_notEquals_3) {
                                String _value_7 = Util.getValue(p);
                                _builder.append((Object)_value_7, "");
                            } else {
                                _builder.append((Object)"null");
                            }
                            _builder.append((Object)";");
                            _builder.newLineIfNotEmpty();
                        } else {
                            boolean _notEquals_4;
                            _builder.append((Object)"this.");
                            String _name_28 = p.getName();
                            _builder.append((Object)_name_28, "");
                            _builder.append((Object)" = jsonObject.has(\"");
                            String _name_29 = p.getName();
                            _builder.append((Object)_name_29, "");
                            _builder.append((Object)"\") ? GsonElementFactory.create");
                            GDomainElement _ref_1 = p.getRef();
                            String _name_30 = _ref_1.getName();
                            _builder.append((Object)_name_30, "");
                            _builder.append((Object)"(jsonObject.getAsJsonObject(\"");
                            String _name_31 = p.getName();
                            _builder.append((Object)_name_31, "");
                            _builder.append((Object)"\")) : ");
                            String _value_8 = Util.getValue(p);
                            boolean bl = _notEquals_4 = !Objects.equal((Object)_value_8, null);
                            if (_notEquals_4) {
                                String _value_9 = Util.getValue(p);
                                _builder.append((Object)_value_9, "");
                            } else {
                                _builder.append((Object)"null");
                            }
                            _builder.append((Object)";");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                }
            }
        }
        return _builder;
    }

    public CharSequence generatePropertyEntry(GDomainProperty p) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"private final ");
        String _type = GsonGenerator.getType(p);
        _builder.append((Object)_type, "");
        _builder.append((Object)" ");
        String _name = p.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public ");
        String _type_1 = GsonGenerator.getType(p);
        _builder.append((Object)_type_1, "");
        _builder.append((Object)" ");
        String _type_2 = GsonGenerator.getType(p);
        boolean _equals = Objects.equal((Object)_type_2, (Object)"boolean");
        if (_equals) {
            _builder.append((Object)"is");
        } else {
            _builder.append((Object)"get");
        }
        String _name_1 = p.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name_1);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return this.");
        String _name_2 = p.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateDeserializer(GModel m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)".gson;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import ");
        String _name_1 = m.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)".*;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.google.gson.JsonObject;");
        _builder.newLine();
        _builder.append((Object)"import com.google.gson.JsonArray;");
        _builder.newLine();
        _builder.newLine();
        Resource _eResource = m.eResource();
        URI _uRI = _eResource.getURI();
        String _lastSegment = _uRI.lastSegment();
        Resource _eResource_1 = m.eResource();
        URI _uRI_1 = _eResource_1.getURI();
        String _lastSegment_1 = _uRI_1.lastSegment();
        int _length = _lastSegment_1.length();
        int _minus = _length - 5;
        String name = _lastSegment.substring(0, _minus);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public final class GsonElementFactory implements ");
        _builder.append((Object)name, "");
        _builder.append((Object)"GModel {");
        _builder.newLineIfNotEmpty();
        EList<GDomainElement> _typeList = m.getTypeList();
        for (GDomainElement t : _typeList) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public static ");
            String _name_2 = t.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)" create");
            String _name_3 = t.getName();
            _builder.append((Object)_name_3, "\t");
            _builder.append((Object)"(JsonObject o) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"if( o.has(\"$gtype\") ) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"switch( o.get(\"$gtype\").getAsString() ) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"case \"");
            String _name_4 = t.getName();
            _builder.append((Object)_name_4, "\t\t\t\t");
            _builder.append((Object)"\":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"return new Gson");
            String _name_5 = t.getName();
            _builder.append((Object)_name_5, "\t\t\t\t\t");
            _builder.append((Object)"Impl(o);");
            _builder.newLineIfNotEmpty();
            List<GDomainElement> _allImpl = GsonGenerator.getAllImpl(t, m);
            for (GDomainElement sub : _allImpl) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"case \"");
                String _name_6 = sub.getName();
                _builder.append((Object)_name_6, "\t\t\t\t");
                _builder.append((Object)"\":");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return new Gson");
                String _name_7 = sub.getName();
                _builder.append((Object)_name_7, "\t\t\t\t\t");
                _builder.append((Object)"Impl(o);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"default:");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"throw new IllegalStateException();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"} else {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"return new Gson");
            String _name_8 = t.getName();
            _builder.append((Object)_name_8, "\t\t\t");
            _builder.append((Object)"Impl(o);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_9 = t.getName();
            _builder.append((Object)_name_9, "\t");
            _builder.append((Object)".Builder ");
            String _name_10 = t.getName();
            _builder.append((Object)_name_10, "\t");
            _builder.append((Object)"Builder() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return new Gson");
            String _name_11 = t.getName();
            _builder.append((Object)_name_11, "\t\t");
            _builder.append((Object)"Impl.Builder(this);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
        }
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public <T extends ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"Base> T createObject(java.io.Reader json) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"JsonObject o = new com.google.gson.Gson().fromJson( json, JsonObject.class);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return _createObject(o);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@SuppressWarnings(\"unchecked\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static <T extends ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"Base> T _createObject(JsonObject o) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if( o.has(\"$gtype\") ) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"switch( o.get(\"$gtype\").getAsString() ) {");
        _builder.newLine();
        EList<GDomainElement> _typeList_1 = m.getTypeList();
        for (GDomainElement t_1 : _typeList_1) {
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"case \"");
            String _name_12 = t_1.getName();
            _builder.append((Object)_name_12, "\t\t\t\t");
            _builder.append((Object)"\":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return (T) create");
            String _name_13 = t_1.getName();
            _builder.append((Object)_name_13, "\t\t\t\t\t");
            _builder.append((Object)"(o);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return (T) create");
        EList<GDomainElement> _typeList_2 = m.getTypeList();
        GDomainElement _head = (GDomainElement)IterableExtensions.head(_typeList_2);
        String _name_14 = _head.getName();
        _builder.append((Object)_name_14, "\t\t");
        _builder.append((Object)"(o);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public <T extends ");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"Base> java.util.List<T> createList(java.io.Reader json) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"JsonArray ar = new com.google.gson.Gson().fromJson( json, JsonArray.class);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return java.util.stream.StreamSupport.stream(ar.spliterator(), false)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)".map( e -> (JsonObject)e)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)".map( GsonElementFactory::<T>_createObject)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)".collect(java.util.stream.Collectors.toList());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String toString(");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"Base o) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new com.google.gson.GsonBuilder().setPrettyPrinting().create().toJson( ((GsonBase)o).toJSONObject() );");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String toString(java.util.List<");
        _builder.append((Object)name, "\t");
        _builder.append((Object)"Base> o) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new com.google.gson.GsonBuilder().setPrettyPrinting().create().toJson( GsonBase.toDomainJsonArray(o) );");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public static List<GDomainElement> getAllImpl(final GDomainElement e, GModel m) {
        EList<GDomainElement> _typeList = m.getTypeList();
        Functions.Function1<GDomainElement, Boolean> _function = new Functions.Function1<GDomainElement, Boolean>(){

            public Boolean apply(GDomainElement it) {
                return !Objects.equal((Object)it, (Object)e);
            }
        };
        Iterable _filter = IterableExtensions.filter(_typeList, (Functions.Function1)_function);
        Functions.Function1<GDomainElement, Boolean> _function_1 = new Functions.Function1<GDomainElement, Boolean>(){

            public Boolean apply(GDomainElement it) {
                EList<GDomainElement> _superTypeList = it.getSuperTypeList();
                Set<GDomainElement> _collectHierarchicalList = Util.collectHierarchicalList(_superTypeList);
                return _collectHierarchicalList.contains(e);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
        return IterableExtensions.toList((Iterable)_filter_1);
    }

    public static String getType(GDomainProperty p) {
        boolean _isList = p.isList();
        if (_isList) {
            String _plainType = GsonGenerator.getPlainType(p);
            String _plus = "java.util.List<" + _plainType;
            return String.valueOf(_plus) + ">";
        }
        return GsonGenerator.getPlainType(p);
    }

    public static String getPlainType(GDomainProperty p) {
        boolean _notEquals;
        String _xifexpression = null;
        String _builtIn = p.getBuiltIn();
        boolean bl = _notEquals = !Objects.equal((Object)_builtIn, null);
        if (_notEquals) {
            String _builtIn_1 = p.getBuiltIn();
            _xifexpression = Util.toJavaType(_builtIn_1);
        } else {
            GDomainElement _ref = p.getRef();
            _xifexpression = _ref.getName();
        }
        return _xifexpression;
    }

    public static String getPlainType(GDomainMap p) {
        boolean _notEquals;
        String _xifexpression = null;
        String _builtIn = p.getBuiltIn();
        boolean bl = _notEquals = !Objects.equal((Object)_builtIn, null);
        if (_notEquals) {
            String _builtIn_1 = p.getBuiltIn();
            _xifexpression = Util.toJavaType(_builtIn_1);
        } else {
            GDomainElement _ref = p.getRef();
            _xifexpression = _ref.getName();
        }
        return _xifexpression;
    }
}

