/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx.key;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javax.inject.Inject;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.fx.ui.keybindings.Binding;
import org.eclipse.fx.ui.keybindings.KeyLookup;
import org.eclipse.fx.ui.keybindings.KeySequence;
import org.eclipse.fx.ui.keybindings.KeyStroke;
import org.eclipse.fx.ui.keybindings.TriggerSequence;
import org.eclipse.fx.ui.keybindings.e4.EBindingService;
import org.eclipse.fx.ui.keybindings.service.BindingFactory;
import org.eclipse.fx.ui.services.commands.NativeStrategy;
import org.eclipse.fx.ui.workbench.fx.key.FxKeySupport;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class KeyBindingDispatcher {
    private final @NonNull IEclipseContext context;
    private final @NonNull EventHandler<KeyEvent> keyHandler = new KeyDownFilter();
    private @Nullable EBindingService bindingService;
    private @NonNull KeySequence state;
    private final @NonNull BindingFactory factory;
    private final @NonNull KeyLookup lookup;
    private @Nullable EHandlerService handlerService;

    @Inject
    public KeyBindingDispatcher(@NonNull IEclipseContext context, @NonNull BindingFactory factory, @NonNull KeyLookup lookup) {
        this.context = context;
        this.factory = factory;
        this.lookup = lookup;
        this.state = factory.getKeySequenceInstance();
    }

    public @NonNull EventHandler<KeyEvent> getKeyHandler() {
        return this.keyHandler;
    }

    private static boolean isModifierKey(KeyEvent event) {
        switch (event.getCode()) {
            case SHIFT: 
            case CONTROL: 
            case ALT: 
            case COMMAND: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasModifierPressed(KeyEvent event) {
        return event.isAltDown() || event.isControlDown() || event.isMetaDown() || event.isShiftDown();
    }

    void filterKeySequenceBindings(@NonNull KeyEvent event) {
        if (KeyBindingDispatcher.isModifierKey(event)) {
            return;
        }
        List<@NonNull KeyStroke> keyStrokes = this.generatePossibleKeyStrokes(event);
        this.processKeyEvent(keyStrokes, event);
    }

    private @NonNull List<@NonNull KeyStroke> generatePossibleKeyStrokes(@NonNull KeyEvent event) {
        int thirdAccelerator;
        ArrayList<@NonNull KeyStroke> keyStrokes = new ArrayList<KeyStroke>(3);
        if (!KeyBindingDispatcher.hasModifierPressed(event) && event.getCode() == KeyCode.UNDEFINED) {
            return keyStrokes;
        }
        int firstAccelerator = FxKeySupport.convertEventToUnmodifiedAccelerator(event);
        keyStrokes.add(FxKeySupport.convertAcceleratorToKeyStroke(this.factory, this.lookup, firstAccelerator));
        if (event.getCode() == KeyCode.DELETE) {
            return keyStrokes;
        }
        int secondAccelerator = FxKeySupport.convertEventToUnshiftedModifiedAccelerator(event);
        if (secondAccelerator != firstAccelerator) {
            keyStrokes.add(FxKeySupport.convertAcceleratorToKeyStroke(this.factory, this.lookup, secondAccelerator));
        }
        if ((thirdAccelerator = FxKeySupport.convertEventToModifiedAccelerator(event)) != secondAccelerator && thirdAccelerator != firstAccelerator) {
            keyStrokes.add(FxKeySupport.convertAcceleratorToKeyStroke(this.factory, this.lookup, thirdAccelerator));
        }
        return keyStrokes;
    }

    void processKeyEvent(@NonNull List<@NonNull KeyStroke> keyStrokes, @NonNull KeyEvent event) {
        boolean eatKey = false;
        if (!keyStrokes.isEmpty()) {
            eatKey = this.press(keyStrokes, event);
        }
        if (eatKey) {
            event.consume();
        }
    }

    private boolean press(@NonNull List<@NonNull KeyStroke> potentialKeyStrokes, @NonNull KeyEvent event) {
        KeySequence errorSequence = null;
        Collection errorMatch = null;
        KeySequence sequenceBeforeKeyStroke = this.state;
        Iterator<@NonNull KeyStroke> iterator = potentialKeyStrokes.iterator();
        while (iterator.hasNext()) {
            KeySequence sequenceAfterKeyStroke = this.factory.getKeySequenceInstance(sequenceBeforeKeyStroke, iterator.next());
            if (this.isPartialMatch(sequenceAfterKeyStroke)) {
                this.incrementState(sequenceAfterKeyStroke);
                return true;
            }
            if (this.isPerfectMatch(sequenceAfterKeyStroke)) {
                ParameterizedCommand cmd = this.getPerfectMatch(sequenceAfterKeyStroke);
                try {
                    return this.executeCommand(cmd, (Event)event) || !sequenceBeforeKeyStroke.isEmpty();
                }
                catch (CommandException e) {
                    return true;
                }
            }
            Collection matches = this.getBindingService().getConflictsFor((TriggerSequence)sequenceAfterKeyStroke);
            if (matches == null || matches.isEmpty()) continue;
            errorSequence = sequenceAfterKeyStroke;
            errorMatch = matches;
        }
        this.resetState(true);
        if (sequenceBeforeKeyStroke.isEmpty() && errorSequence != null) {
            this.openKeyAssistShell(errorMatch);
        }
        return !sequenceBeforeKeyStroke.isEmpty();
    }

    private @Nullable ParameterizedCommand getPerfectMatch(@NonNull KeySequence keySequence) {
        Binding perfectMatch = this.getBindingService().getPerfectMatch((TriggerSequence)keySequence);
        return perfectMatch == null ? null : perfectMatch.getParameterizedCommand();
    }

    private boolean isPartialMatch(@NonNull KeySequence keySequence) {
        return this.getBindingService().isPartialMatch((TriggerSequence)keySequence);
    }

    private boolean isPerfectMatch(@NonNull KeySequence keySequence) {
        return this.getBindingService().isPerfectMatch((TriggerSequence)keySequence);
    }

    private void resetState(boolean clearRememberedState) {
        this.state = this.factory.getKeySequenceInstance();
    }

    private @NonNull EBindingService getBindingService() {
        EBindingService bindingService = this.bindingService;
        if (bindingService == null) {
            bindingService = (EBindingService)this.context.get(EBindingService.class.getName());
            if (bindingService == null) {
                throw new IllegalStateException("EBindingService service must not be null");
            }
            this.bindingService = bindingService;
        }
        return bindingService;
    }

    private void incrementState(@NonNull KeySequence sequence) {
        this.state = sequence;
    }

    private final void openKeyAssistShell(Collection<Binding> bindings) {
    }

    private final boolean executeCommand(ParameterizedCommand parameterizedCommand, Event trigger) throws CommandException {
        boolean commandHandled;
        this.resetState(false);
        EHandlerService handlerService = this.getHandlerService();
        Command command = parameterizedCommand.getCommand();
        IEclipseContext staticContext = EclipseContextFactory.create((String)"keys-staticContext");
        staticContext.set(Event.class, (Object)trigger);
        boolean commandDefined = command.isDefined();
        try {
            commandHandled = HandlerServiceImpl.lookUpHandler((IEclipseContext)this.context, (String)command.getId()) != null;
            try {
                Object o = handlerService.executeHandler(parameterizedCommand, staticContext);
                if (o == NativeStrategy.PROCEED) {
                    return false;
                }
            }
            catch (Exception e) {
                commandHandled = false;
                e.printStackTrace();
            }
        }
        finally {
            staticContext.dispose();
        }
        return commandDefined && commandHandled;
    }

    private @NonNull EHandlerService getHandlerService() {
        EHandlerService handlerService = this.handlerService;
        if (handlerService == null) {
            handlerService = (EHandlerService)this.context.get(EHandlerService.class.getName());
            if (handlerService == null) {
                throw new IllegalStateException("EHandlerService must not be null");
            }
            this.handlerService = handlerService;
        }
        return handlerService;
    }

    public class KeyDownFilter
    implements EventHandler<KeyEvent> {
        private transient boolean enabled = true;

        public void handle(KeyEvent event) {
            if (!this.enabled) {
                return;
            }
            KeyBindingDispatcher.this.filterKeySequenceBindings(event);
        }

        public final boolean isEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

