/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ClipPathUnits implements Enumerator
{
    USER_SPACE_ON_USE(0, "userSpaceOnUse", "userSpaceOnUse"),
    OBJECT_BOUNDING_BOX(1, "objectBoundingBox", "objectBoundingBox");

    public static final int USER_SPACE_ON_USE_VALUE = 0;
    public static final int OBJECT_BOUNDING_BOX_VALUE = 1;
    private static final ClipPathUnits[] VALUES_ARRAY;
    public static final List<ClipPathUnits> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ClipPathUnits[]{USER_SPACE_ON_USE, OBJECT_BOUNDING_BOX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ClipPathUnits get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClipPathUnits result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClipPathUnits getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClipPathUnits result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClipPathUnits get(int value) {
        switch (value) {
            case 0: {
                return USER_SPACE_ON_USE;
            }
            case 1: {
                return OBJECT_BOUNDING_BOX;
            }
        }
        return null;
    }

    private ClipPathUnits(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

