/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.generator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandFacade;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.AbstractGeneratorFragment;
import org.eclipse.xtext.generator.BindFactory;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.IStubGenerating;
import org.eclipse.xtext.generator.LanguageConfig;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.xbase.XbaseGeneratorFragment;
import org.eclipse.xtext.util.Strings;

public class GeneratorFragment
extends AbstractGeneratorFragment
implements IStubGenerating {
    private boolean generateStub = true;
    private boolean generateMwe = false;
    private boolean generateJavaMain = false;
    private boolean generateXtendMain = false;

    public void setGenerateJavaMain(boolean generateJavaMain) {
        this.generateJavaMain = generateJavaMain;
    }

    public void setGenerateXtendMain(boolean generateXtendMain) {
        this.generateXtendMain = generateXtendMain;
    }

    public void setGenerateMwe(boolean generateMwe) {
        this.generateMwe = generateMwe;
    }

    @Deprecated
    public void setGeneratorStub(boolean isGenerateStub) {
        this.setGenerateStub(isGenerateStub);
    }

    @Override
    public void setGenerateStub(boolean isGenerateStub) {
        this.generateStub = isGenerateStub;
    }

    @Override
    public boolean isGenerateStub() {
        return this.generateStub;
    }

    public boolean isGenerateStub(Grammar grammar) {
        if (XbaseGeneratorFragment.doesUseXbase(grammar)) {
            return false;
        }
        return this.isGenerateStub();
    }

    public boolean isGenerateJavaMain(Grammar grammar) {
        if (XbaseGeneratorFragment.doesUseXbase(grammar)) {
            return false;
        }
        return this.generateJavaMain;
    }

    public boolean isGenerateXtendMain(Grammar grammar) {
        if (XbaseGeneratorFragment.doesUseXbase(grammar)) {
            return false;
        }
        return this.generateXtendMain;
    }

    public boolean isGenerateMwe(Grammar grammar) {
        if (XbaseGeneratorFragment.doesUseXbase(grammar)) {
            return false;
        }
        return this.generateMwe;
    }

    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.generateJavaMain && this.generateXtendMain) {
            issues.addWarning("Options 'generateJavaMain' and 'generateXtendMain' are mutually exclusive. Generating Xtend only.");
            this.generateJavaMain = false;
        }
    }

    @Override
    public void addToPluginXmlUi(LanguageConfig config, XpandExecutionContext ctx) {
        Grammar grammar = config.getGrammar();
        ArrayList parameters = Lists.newArrayList();
        parameters.addAll(this.getParameters(grammar));
        parameters.add(config.getFileExtensions(grammar));
        XpandFacade.create((XpandExecutionContext)ctx).evaluate2(this.getTemplate() + "::addToPluginXmlUi", (Object)grammar, (List)parameters);
    }

    @Override
    protected List<Object> getParameters(Grammar grammar) {
        return Lists.newArrayList((Object[])new Object[]{this.isGenerateStub(grammar), this.isGenerateMwe(grammar), this.isGenerateJavaMain(grammar), this.isGenerateXtendMain(grammar)});
    }

    @Override
    public Set<Binding> getGuiceBindingsRt(Grammar grammar) {
        if (this.isGenerateStub(grammar)) {
            return new BindFactory().addTypeToType(IGenerator.class.getName(), GeneratorFragment.getGeneratorName(grammar, this.getNaming())).getBindings();
        }
        return Collections.emptySet();
    }

    @Override
    public String[] getImportedPackagesRt(Grammar grammar) {
        return Strings.EMPTY_ARRAY;
    }

    @Override
    public String[] getRequiredBundlesRt(Grammar grammar) {
        if (this.isGenerateStub(grammar)) {
            return new String[]{"org.eclipse.xtext.xbase.lib"};
        }
        return Strings.EMPTY_ARRAY;
    }

    @Override
    public String[] getRequiredBundlesUi(Grammar grammar) {
        return new String[]{"org.eclipse.xtext.builder"};
    }

    public static String getGeneratorName(Grammar grammar, Naming naming) {
        return naming.basePackageRuntime(grammar) + ".generator." + GrammarUtil.getSimpleName((Grammar)grammar) + "Generator";
    }

    @Override
    public Set<Binding> getGuiceBindingsUi(Grammar grammar) {
        return new BindFactory().addTypeToType("org.eclipse.xtext.builder.IXtextBuilderParticipant", "org.eclipse.xtext.builder.BuilderParticipant").addTypeToInstance("org.eclipse.core.resources.IWorkspaceRoot", "org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRoot()").addConfiguredBinding("BuilderPreferenceStoreInitializer", "binder.bind(org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreInitializer.class).annotatedWith(com.google.inject.name.Names.named(\"builderPreferenceInitializer\")).to(org.eclipse.xtext.builder.preferences.BuilderPreferenceAccess.Initializer.class)").getBindings();
    }

    @Override
    public String[] getExportedPackagesRt(Grammar grammar) {
        if (this.isGenerateStub(grammar) || this.isGenerateJavaMain(grammar)) {
            return new String[]{Strings.skipLastToken((String)GeneratorFragment.getGeneratorName(grammar, this.getNaming()), (String)".")};
        }
        return new String[0];
    }
}

