/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.profiler;

import java.text.DecimalFormat;
import org.slf4j.profiler.DurationUnit;
import org.slf4j.profiler.StopWatch;

class Util {
    static final long NANOS_IN_ONE_MICROSECOND = 1000L;
    static final long NANOS_IN_ONE_MILLISECOND = 1000000L;
    static final long NANOS_IN_ONE_SECOND = 1000000000L;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.000");

    Util() {
    }

    static DurationUnit selectDurationUnitForDisplay(StopWatch sw) {
        return Util.selectDurationUnitForDisplay(sw.elapsedTime());
    }

    static DurationUnit selectDurationUnitForDisplay(long durationInNanos) {
        if (durationInNanos < 10000L) {
            return DurationUnit.NANOSECOND;
        }
        if (durationInNanos < 10000000L) {
            return DurationUnit.MICROSECOND;
        }
        if (durationInNanos < 10000000000L) {
            return DurationUnit.MILLISSECOND;
        }
        return DurationUnit.SECOND;
    }

    public static double convertToMicros(long nanos) {
        return (double)nanos / 1000.0;
    }

    public static double convertToMillis(long nanos) {
        return (double)nanos / 1000000.0;
    }

    public static double convertToSeconds(long nanos) {
        return (double)nanos / 1.0E9;
    }

    static String durationInDurationUnitsAsStr(StringBuilder buf, StopWatch sw) {
        DurationUnit du = Util.selectDurationUnitForDisplay(sw);
        return Util.durationInDurationUnitsAsStr(sw.elapsedTime(), du);
    }

    static String durationInDurationUnitsAsStr(long nanos, DurationUnit durationUnit) {
        StringBuilder buf = new StringBuilder();
        switch (durationUnit) {
            case NANOSECOND: {
                buf.append(nanos);
                break;
            }
            case MICROSECOND: {
                double micros = Util.convertToMicros(nanos);
                buf.append(DECIMAL_FORMAT.format(micros));
                break;
            }
            case MILLISSECOND: {
                double millis = Util.convertToMillis(nanos);
                buf.append(DECIMAL_FORMAT.format(millis));
                break;
            }
            case SECOND: {
                double seconds = Util.convertToSeconds(nanos);
                buf.append(DECIMAL_FORMAT.format(seconds));
            }
        }
        return buf.toString();
    }

    static void appendDurationUnitAsStr(StringBuilder buf, DurationUnit durationUnit) {
        switch (durationUnit) {
            case NANOSECOND: {
                buf.append("nanoseconds.");
                break;
            }
            case MICROSECOND: {
                buf.append("microseconds.");
                break;
            }
            case MILLISSECOND: {
                buf.append("milliseconds.");
                break;
            }
            case SECOND: {
                buf.append(" seconds.");
            }
        }
    }
}

