/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.langs.contrib;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.LanguageDef;
import org.eclipse.fx.code.editor.configuration.text.ConfigurationModelProvider;
import org.eclipse.fx.code.editor.services.URIProvider;
import org.eclipse.fx.core.log.LoggerCreator;
import org.osgi.service.component.annotations.Component;

@Component
public class LangsConfigurationModelProvider
implements ConfigurationModelProvider {
    private final Map<String, URL> definitionURI = new HashMap<String, URL>();
    private final Map<String, LanguageDef> definitionCache = new HashMap<String, LanguageDef>();

    public LangsConfigurationModelProvider() {
        try {
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/adoc.json"), "adoc");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/ceylon.json"), "ceylon");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/dart.json"), "dart");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/go.json"), "go");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/groovy.json"), "groovy");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/java.json"), "java");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/js.json"), "js");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/kotlin.json"), "kotlin");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/lua.json"), "lua");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/php.json"), "php");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/py.json"), "py");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/rust.json"), "rust");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/swift.json"), "swift");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/ts.json"), "ts");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/xml.json"), "xml");
            this.register(new URL("platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/xml.json"), "html");
        }
        catch (Throwable t) {
            LoggerCreator.createLogger(LangsConfigurationModelProvider.class).error("Invalid URL", t);
        }
    }

    private void register(URL uri, String fileSuffix) {
        this.definitionURI.put(fileSuffix, uri);
    }

    public boolean applies(Input<?> input) {
        String uri;
        String[] parts;
        String lastSegment;
        int idx;
        if (input instanceof URIProvider && (idx = (lastSegment = (parts = (uri = ((URIProvider)input).getURI()).split("/"))[parts.length - 1]).lastIndexOf(46)) != -1) {
            boolean rv = this.definitionURI.containsKey(lastSegment.substring(idx + 1));
            return rv;
        }
        return false;
    }

    public LanguageDef getModel(Input<?> input) {
        String uri;
        String[] parts;
        String lastSegment;
        int idx;
        if (input instanceof URIProvider && (idx = (lastSegment = (parts = (uri = ((URIProvider)input).getURI()).split("/"))[parts.length - 1]).lastIndexOf(46)) != -1) {
            return this.getModelByExtension(lastSegment.substring(idx + 1));
        }
        return null;
    }

    public LanguageDef getModelByExtension(String extension) {
        return this.definitionCache.computeIfAbsent(extension, e -> {
            try {
                return (LanguageDef)EditorGModel.create().createObject((Reader)new InputStreamReader(this.definitionURI.get(e).openStream()));
            }
            catch (Exception e1) {
                LoggerCreator.createLogger(LangsConfigurationModelProvider.class).error("Unable to load json file '" + this.definitionURI.get(e) + "'", (Throwable)e1);
                return null;
            }
        });
    }
}

