/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.AboutToHide;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MDynamicMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.workbench.renderers.base.BaseItemContainerRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseItemRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.EventProcessor;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenuElement;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPopupMenu;
import org.eclipse.fx.ui.workbench.services.ELifecycleService;
import org.eclipse.fx.ui.workbench.services.lifecycle.annotation.PreClose;
import org.eclipse.fx.ui.workbench.services.lifecycle.annotation.PreShow;
import org.eclipse.jdt.annotation.NonNull;

public abstract class BasePopupMenuRenderer<N>
extends BaseItemContainerRenderer<MPopupMenu, MMenuElement, WPopupMenu<N>>
implements EventProcessor.ChildrenHandler<MPopupMenu, MMenuElement> {
    @Inject
    ELifecycleService lifecycleService;
    @Inject
    private IContributionFactory contributionFactory;
    @Log
    @Inject
    private Logger logger;
    private static final String DYNAMIC_MENU_CONTRIBUTION = "DYNAMIC_MENU_CONTRIBUTION";
    private Set<MPopupMenu> currentVisibleMenus = new HashSet<MPopupMenu>();

    @Override
    protected void do_init(@NonNull IEventBroker broker) {
    }

    @Override
    protected void initWidget(MPopupMenu element, WPopupMenu<N> widget) {
        super.initWidget(element, widget);
        widget.setShowingCallback(() -> this.handleShowing(element));
        widget.setHidingCallback(() -> this.handleHiding(element));
    }

    void handleHiding(@NonNull MPopupMenu element) {
        this.currentVisibleMenus.remove(element);
        IEclipseContext modelContext = this.getModelContext((MUIElement)element);
        if (modelContext == null) {
            this.getLogger().error("Model context is null");
            return;
        }
        IEclipseContext context = modelContext.createChild("lifecycle");
        context.set(MPopupMenu.class, (Object)element);
        this.lifecycleService.validateAnnotation(PreClose.class, (MUIElement)element, context);
        MMenuElement[] mMenuElementArray = element.getChildren().toArray(new MMenuElement[0]);
        int n = mMenuElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            MDynamicMenuContribution dc;
            Object contrib;
            MMenuElement e = mMenuElementArray[n2];
            if (e instanceof MDynamicMenuContribution && (contrib = (dc = (MDynamicMenuContribution)e).getObject()) != null) {
                List previous = (List)dc.getTransientData().remove(DYNAMIC_MENU_CONTRIBUTION);
                context.set(List.class, (Object)previous);
                try {
                    ContextInjectionFactory.invoke((Object)contrib, AboutToHide.class, (IEclipseContext)context, null);
                    if (previous != null && !previous.isEmpty()) {
                        element.getChildren().removeAll(previous);
                    }
                }
                catch (Throwable t) {
                    this.getLogger().debug("Unable to process the AboutToHide", t);
                }
            }
            ++n2;
        }
        context.dispose();
    }

    void handleShowing(@NonNull MPopupMenu element) {
        this.currentVisibleMenus.add(element);
        IEclipseContext modelContext = this.getModelContext((MUIElement)element);
        if (modelContext == null) {
            this.getLogger().error("The model context is null");
            return;
        }
        IEclipseContext context = modelContext.createChild("lifecycle");
        context.set(MPopupMenu.class, (Object)element);
        this.lifecycleService.validateAnnotation(PreShow.class, (MUIElement)element, context);
        MMenuElement[] mMenuElementArray = element.getChildren().toArray(new MMenuElement[0]);
        int n = mMenuElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            MMenuElement e = mMenuElementArray[n2];
            if (e instanceof MDynamicMenuContribution) {
                Object contrib;
                MDynamicMenuContribution dc = (MDynamicMenuContribution)e;
                if (dc.getObject() == null && dc.getContributionURI() != null) {
                    try {
                        dc.setObject(this.contributionFactory.create(dc.getContributionURI(), context));
                    }
                    catch (Throwable t) {
                        this.getLogger().debug("Unable to create contribution", t);
                    }
                }
                if ((contrib = dc.getObject()) != null) {
                    ArrayList list = new ArrayList();
                    context.set(List.class, list);
                    try {
                        ContextInjectionFactory.invoke((Object)contrib, AboutToShow.class, (IEclipseContext)context, null);
                        int idx = element.getChildren().indexOf(e);
                        element.getChildren().addAll(idx, list);
                        dc.getTransientData().put(DYNAMIC_MENU_CONTRIBUTION, list);
                    }
                    catch (Throwable t) {
                        this.getLogger().debug("Unable to process AboutToShow", t);
                    }
                }
            }
            ++n2;
        }
        for (MMenuElement e : element.getChildren()) {
            if (!(e.getRenderer() instanceof BaseItemRenderer)) continue;
            BaseItemRenderer r = (BaseItemRenderer)e.getRenderer();
            r.checkEnablement(e);
        }
        context.dispose();
    }

    @Override
    protected boolean skipEnablementCheck() {
        return this.currentVisibleMenus.isEmpty();
    }

    @Override
    protected boolean isShowing(MMenuElement item) {
        return this.currentVisibleMenus.contains(item.getParent());
    }

    @Override
    public void doProcessContent(MPopupMenu element) {
        WPopupMenu menu = (WPopupMenu)this.getWidget((MUIElement)element);
        if (menu == null) {
            this.getLogger().error("No widget found for '" + element + "'");
            return;
        }
        for (MMenuElement e : element.getChildren()) {
            WMenuElement widget;
            if (!e.isToBeRendered() || (widget = (WMenuElement)this.engineCreateWidget(e)) == null || !this.isChildAndRenderedVisible((MUIElement)e)) continue;
            menu.addElement(widget);
        }
    }

    @Override
    public void handleChildrenRemove(@NonNull MPopupMenu parent, @NonNull Collection<@NonNull MMenuElement> elements) {
        for (MMenuElement element : elements) {
            if (!this.isChildAndRenderedVisible((MUIElement)element) || element.getWidget() == null) continue;
            this.hideChild(parent, (MUIElement)element);
        }
    }

    @Override
    public void handleChildrenAddition(MPopupMenu parent, Collection<MMenuElement> elements) {
        for (MMenuElement element : elements) {
            if (!this.isChildAndRenderedVisible((MUIElement)element)) continue;
            if (element.getWidget() == null) {
                this.engineCreateWidget(element);
                continue;
            }
            this.childRendered(parent, (MUIElement)element);
        }
    }

    @Override
    public void do_childRendered(@NonNull MPopupMenu parentElement, @NonNull MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement)) {
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        WPopupMenu menu = (WPopupMenu)this.getWidget((MUIElement)parentElement);
        if (menu == null) {
            this.getLogger().error("No widget found for '" + parentElement + "'");
            return;
        }
        WMenuElement menuElement = (WMenuElement)element.getWidget();
        if (menuElement != null) {
            menu.addElement(idx, menuElement);
        } else {
            this.getLogger().error("The widget of the element '" + element + "' is null");
        }
    }

    @Override
    protected boolean isChildAndRenderedVisible(MUIElement u) {
        return super.isChildAndRenderedVisible(u) && !(u instanceof MDynamicMenuContribution);
    }

    @Override
    public void do_hideChild(MPopupMenu container, MUIElement changedObj) {
        WPopupMenu menu = (WPopupMenu)this.getWidget((MUIElement)container);
        if (menu == null) {
            return;
        }
        WMenuElement widget = (WMenuElement)changedObj.getWidget();
        if (widget != null) {
            menu.removeElement(widget);
        }
    }
}

