/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.di;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.util.BuilderFactory;
import javafx.util.Callback;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.fx.core.fxml.ExtendedFXMLLoader;
import org.eclipse.fx.osgi.util.OSGiFXMLLoader;
import org.eclipse.fx.ui.di.FXMLBuilder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public abstract class InjectingFXMLLoader<N>
implements FXMLBuilder<N> {
    @Nullable ResourceBundle resourceBundle;
    @Nullable BuilderFactory builderFactory;

    public static <N> @NonNull InjectingFXMLLoader<N> create(@NonNull IEclipseContext context, @NonNull Class<?> requester, @NonNull String relativeFxmlPath) {
        return InjectingFXMLLoader.create(context, requester, relativeFxmlPath, false);
    }

    public static <N> @NonNull InjectingFXMLLoader<N> create(final @NonNull IEclipseContext context, final @NonNull Class<?> requester, final @NonNull String relativeFxmlPath, boolean useExtendedFXMLLoader) {
        if (useExtendedFXMLLoader) {
            return InjectingFXMLLoader.create(context, FrameworkUtil.getBundle(requester), String.valueOf(requester.getName().substring(0, requester.getName().lastIndexOf(46)).replace('.', '/')) + "/" + relativeFxmlPath, useExtendedFXMLLoader);
        }
        return new InjectingFXMLLoader<N>(){

            @Override
            public N load() throws IOException {
                return OSGiFXMLLoader.load((Class)requester, (String)relativeFxmlPath, (ResourceBundle)this.resourceBundle, (BuilderFactory)this.builderFactory, (Callback)new ControllerFactory(context));
            }

            @Override
            public <C> FXMLBuilder.Data<N, C> loadWithController() throws IOException {
                final OSGiFXMLLoader.FXMLData d = OSGiFXMLLoader.loadWithController((Class)requester, (String)relativeFxmlPath, (ResourceBundle)this.resourceBundle, (BuilderFactory)this.builderFactory, (Callback)new ControllerFactory(context));
                return new FXMLBuilder.Data<N, C>(){

                    @Override
                    public C getController() {
                        return d.controller;
                    }

                    @Override
                    public N getNode() {
                        return d.node;
                    }
                };
            }
        };
    }

    public static <N> InjectingFXMLLoader<N> create(@NonNull IEclipseContext context, @NonNull Bundle bundle, @NonNull String bundleRelativeFxmlPath) {
        return InjectingFXMLLoader.create(context, bundle, bundleRelativeFxmlPath, false);
    }

    public static <N> @NonNull InjectingFXMLLoader<N> create(final @NonNull IEclipseContext context, final @NonNull Bundle bundle, final @NonNull String bundleRelativeFxmlPath, boolean useExtendedFXMLLoader) {
        if (useExtendedFXMLLoader) {
            return new InjectingFXMLLoader<N>(){

                @Override
                public N load() throws IOException {
                    return ExtendedFXMLLoader.loadWithController((ClassLoader)((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader(), (ResourceBundle)this.resourceBundle, (Callback)new ControllerFactory(context), (String)bundleRelativeFxmlPath).getNode();
                }

                @Override
                public <C> FXMLBuilder.Data<N, C> loadWithController() throws IOException {
                    final ExtendedFXMLLoader.Data data = ExtendedFXMLLoader.loadWithController((ClassLoader)((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader(), (ResourceBundle)this.resourceBundle, (Callback)new ControllerFactory(context), (String)bundleRelativeFxmlPath);
                    return new FXMLBuilder.Data<N, C>(){

                        @Override
                        public N getNode() {
                            return data.getNode();
                        }

                        @Override
                        public C getController() {
                            return data.getController();
                        }
                    };
                }
            };
        }
        return new InjectingFXMLLoader<N>(){

            @Override
            public N load() throws IOException {
                return OSGiFXMLLoader.load((Bundle)bundle, (String)bundleRelativeFxmlPath, (ResourceBundle)this.resourceBundle, (BuilderFactory)this.builderFactory, (Callback)new ControllerFactory(context));
            }

            @Override
            public <C> FXMLBuilder.Data<N, C> loadWithController() throws IOException {
                final OSGiFXMLLoader.FXMLData d = OSGiFXMLLoader.loadWithController((Bundle)bundle, (String)bundleRelativeFxmlPath, (ResourceBundle)this.resourceBundle, (BuilderFactory)this.builderFactory, (Callback)new ControllerFactory(context));
                return new FXMLBuilder.Data<N, C>(){

                    @Override
                    public C getController() {
                        return d.controller;
                    }

                    @Override
                    public N getNode() {
                        return d.node;
                    }
                };
            }
        };
    }

    public static <N> @NonNull InjectingFXMLLoader<N> create(final @NonNull IEclipseContext context, final @NonNull ClassLoader classloader, final @NonNull URL url) {
        return new InjectingFXMLLoader<N>(){

            @Override
            public N load() throws IOException {
                return OSGiFXMLLoader.load((ClassLoader)classloader, (URL)url, (ResourceBundle)this.resourceBundle, (BuilderFactory)this.builderFactory, (Callback)new ControllerFactory(context));
            }

            @Override
            public <C> FXMLBuilder.Data<N, C> loadWithController() throws IOException {
                final OSGiFXMLLoader.FXMLData d = OSGiFXMLLoader.loadWithController((ClassLoader)classloader, (URL)url, (ResourceBundle)this.resourceBundle, (BuilderFactory)this.builderFactory, (Callback)new ControllerFactory(context));
                return new FXMLBuilder.Data<N, C>(){

                    @Override
                    public C getController() {
                        return d.controller;
                    }

                    @Override
                    public N getNode() {
                        return d.node;
                    }
                };
            }
        };
    }

    @Override
    public @NonNull InjectingFXMLLoader<N> resourceBundle(@NonNull ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        return this;
    }

    @Override
    public @NonNull InjectingFXMLLoader<N> builderFactory(@NonNull BuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
        return this;
    }

    static class ControllerFactory
    implements Callback<Class<?>, Object> {
        private final IEclipseContext context;

        public ControllerFactory(IEclipseContext context) {
            this.context = context;
        }

        public Object call(Class<?> param) {
            Object o;
            if (param.isInterface() || (param.getModifiers() & 0x400) == 1024) {
                o = this.context.get(param.getName());
            } else {
                o = ContextInjectionFactory.make(param, (IEclipseContext)this.context);
                this.context.set(o.getClass().getName(), o);
            }
            return o;
        }
    }
}

