/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class StringUtil {
    public static final String WEBSOCKET_SUBPROTOCOLS_0 = "MBWS.huawei.com";
    public static final String WEBSOCKET_SUBPROTOCOLS_1 = "MBLWS.huawei.com";
    public static final String WEBSOCKET_SUBPROTOCOLS_2 = "soap";
    public static final String WEBSOCKET_SUBPROTOCOLS_3 = "wamp";
    public static final String WEBSOCKET_SUBPROTOCOLS_4 = "v10.stomp";
    public static final String WEBSOCKET_SUBPROTOCOLS_5 = "v11.stomp";
    public static final String WEBSOCKET_SUBPROTOCOLS_6 = "v12.stomp";
    public static final String WEBSOCKET_SUBPROTOCOLS_7 = "ocpp1.2";
    public static final String WEBSOCKET_SUBPROTOCOLS_8 = "ocpp1.5";
    public static final String WEBSOCKET_SUBPROTOCOLS_9 = "ocpp2.0";
    public static final String[] WEBSOCKET_SUBPROTOCOLS = new String[]{"MBWS.huawei.com", "MBLWS.huawei.com", "soap", "wamp", "v10.stomp", "v11.stomp", "v12.stomp", "ocpp1.2", "ocpp1.5", "ocpp2.0"};

    public static String objectsToString(Object ... objects) {
        return StringUtil.objectsToStringWithDelimiter(" ", objects);
    }

    public static String objectsToStringWithDelimiter(String delimiter, Object ... objects) {
        StringBuilder sb = new StringBuilder();
        if (objects != null) {
            for (Object o : objects) {
                if (o.getClass().isArray()) {
                    sb.append(StringUtil.objectsToStringWithDelimiter(delimiter, (Object[])o));
                    continue;
                }
                if (Collection.class.isInstance(o)) {
                    sb.append(StringUtil.collectionToStringWithDelimiter(delimiter, (Collection)o));
                    continue;
                }
                sb.append(o).append(delimiter);
            }
        }
        return sb.toString().trim();
    }

    public static String collectionToStringWithDelimiter(String delimiter, Collection<?> objects) {
        return objects == null ? "" : StringUtil.objectsToStringWithDelimiter(delimiter, objects.toArray());
    }

    public static String collectionToString(Collection<?> objects) {
        return StringUtil.collectionToStringWithDelimiter(" ", objects);
    }

    public static boolean contains(List<String> where, List<String> what, boolean caseSensitive) {
        String whereInOne = StringUtil.objectsToStringWithDelimiter("", where);
        if (!caseSensitive) {
            whereInOne = whereInOne.toLowerCase();
        }
        for (String whatItem : what) {
            boolean found = false;
            found = caseSensitive ? whereInOne.contains(whatItem) : whereInOne.contains(whatItem.toLowerCase());
            if (found) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean contains(List<T> where, List<T> what, Comparator<? super T> comparator) {
        where = new ArrayList<T>(where);
        what = new ArrayList<T>(what);
        Collections.sort(what, comparator);
        Collections.sort(where, comparator);
        Iterator<T> j = where.iterator();
        for (T whatItem : what) {
            T whereItem;
            do {
                if (j.hasNext()) continue;
                return false;
            } while (comparator.compare(whatItem, whereItem = j.next()) != 0);
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean contains(List<T> where, List<T> what) {
        where = new ArrayList<T>(where);
        what = new ArrayList<T>(what);
        Collections.sort(what);
        Collections.sort(where);
        return StringUtil.containsInOrder(where, what);
    }

    public static <T extends Comparable<? super T>> boolean containsInOrder(List<T> where, List<T> what) {
        Iterator<T> j = where.iterator();
        for (Comparable whatItem : what) {
            Comparable whereItem;
            do {
                if (j.hasNext()) continue;
                return false;
            } while (whatItem.compareTo(whereItem = (Comparable)j.next()) != 0);
        }
        return true;
    }
}

