/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.websocket.common.client.BinaryAndTextClientEndpoint;
import com.sun.ts.tests.websocket.common.client.ClientEndpoint;
import com.sun.ts.tests.websocket.common.client.EndpointCallback;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.StringPingMessage;
import com.sun.ts.tests.websocket.common.impl.StringPongMessage;
import com.sun.ts.tests.websocket.common.impl.WaitingSendHandler;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextEncoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.PongMessageClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async.AsyncEndpointCallback;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async.PokingEndpointCallback;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async.ThrowingStringBeanEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async.WSCServerSideServer;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async.WSCThrowingServerSideServer;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.RemoteEndpoint;
import java.io.IOException;
import java.util.LinkedList;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 7620798773325933328L;
    static final String[] RESPONSE = WSCServerSideServer.RESPONSE;
    static final String ECHO = "echo";

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_jakarta_websocket_remoteendpoint_async_web.war");
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{WaitingSendHandler.class});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_ee_jakarta_websocket_remoteendpoint_async_web");
    }

    @Test
    public void sendTimeoutOnServerTest() throws Exception {
        this.invoke("server", OPS.TIMEOUT.name(), new String[]{RESPONSE[0]});
    }

    @Test
    public void sendTimeoutOnClientTest() throws Exception {
        AsyncEndpointCallback callback = new AsyncEndpointCallback(){

            @Override
            void doAsync(RemoteEndpoint.Async asyncRemote) throws Exception {
                String ret = WSCServerSideServer.timeout(asyncRemote);
                WebSocketCommonClient.assertEquals((Object)RESPONSE[0], (Object)ret, (Object[])new Object[]{"getSendTimeout did not return what was set by setSendTimeout"});
                WebSocketCommonClient.logMsg((Object[])new Object[]{"getSendTimeout and setSendTimeout work as expected"});
                asyncRemote.sendText((String)WSClientIT.this.entity.getEntityAt(String.class, 0));
            }
        };
        this.setClientCallback(callback);
        this.invoke("client", ECHO, new String[]{ECHO});
    }

    @Test
    public void sendBinaryOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDBINARY);
    }

    @Test
    public void sendBinaryOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDBINARY);
    }

    @Test
    public void sendBinaryThrowsIAEOnServerTest() throws Exception {
        this.invoke("server", OPS.SENDBINARYTHROWS.name(), new String[]{RESPONSE[0]});
    }

    @Test
    public void sendBinaryThrowsIAEOnClientTest() throws Exception {
        this.sendOnClientThrows(OPS.SENDBINARYTHROWS);
    }

    @Test
    public void sendBinaryWithHandlerOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDBINARYHANDLER);
    }

    @Test
    public void sendBinaryWithHandlerOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDBINARYHANDLER);
    }

    @Test
    public void sendBinaryWithHandlerThrowsIAEOnServerWhenNullDataTest() throws Exception {
        this.invoke("server", OPS.SENDBINARYHANDLERTHROWSONDATA.name(), new String[]{RESPONSE[0]});
    }

    @Test
    public void sendBinaryWithHandlerThrowsIAEOnServerWhenNullHandlerTest() throws Exception {
        this.invoke("server", OPS.SENDBINARYHANDLERTHROWSONHANDLER.name(), new String[]{RESPONSE[0]});
    }

    @Test
    public void sendBinaryWithHandlerThrowsIAEOnClientWhenNullDataTest() throws Exception {
        this.sendOnClientThrows(OPS.SENDBINARYHANDLERTHROWSONDATA);
    }

    @Test
    public void sendBinaryWithHandlerThrowsIAEOnClientWhenNullHandlerTest() throws Exception {
        this.sendOnClientThrows(OPS.SENDBINARYHANDLERTHROWSONHANDLER);
    }

    @Test
    public void sendObjectOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT);
    }

    @Test
    public void sendObjectOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT);
    }

    @Test
    public void sendObjectBooleanOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_BOOL, false);
    }

    @Test
    public void sendObjectBooleanOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_BOOL, String.valueOf(false));
    }

    @Test
    public void sendObjectByteOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_BYTE, -100);
    }

    @Test
    public void sendObjectByteOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_BYTE, "-100");
    }

    @Test
    public void sendObjectCharOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_CHAR, String.valueOf('j'));
    }

    @Test
    public void sendObjectCharOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_CHAR, String.valueOf('j'));
    }

    @Test
    public void sendObjectDoubleOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_DOUBLE, -105.0);
    }

    @Test
    public void sendObjectDoubleOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_DOUBLE, "-105");
    }

    @Test
    public void sendObjectFloatOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_FLOAT, Float.valueOf(-104.0f));
    }

    @Test
    public void sendObjectFloatOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_FLOAT, "-104");
    }

    @Test
    public void sendObjectIntOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_INT, -102);
    }

    @Test
    public void sendObjectIntOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_INT, "-102");
    }

    @Test
    public void sendObjectLongOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_LONG, -103L);
    }

    @Test
    public void sendObjectLongOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_LONG, "-103");
    }

    @Test
    public void sendObjectShortOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_SHORT, -101);
    }

    @Test
    public void sendObjectShortOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_SHORT, "-101");
    }

    @Test
    public void sendObjectThrowsIAEOnServerTest() throws Exception {
        this.invoke("server", OPS.SENDOBJECTTHROWS.name(), new String[]{RESPONSE[0]});
    }

    @Test
    public void sendObjectThrowsIAEOnClientTest() throws Exception {
        this.sendOnClientThrows(OPS.SENDOBJECTTHROWS);
    }

    @Test
    public void sendObjectHasExecutionExceptionOnServerTest() throws Exception {
        this.setClientEndpoint(BinaryAndTextClientEndpoint.class);
        this.invoke("throwing", OPS.SENDOBJECTEXECUTIONEXCEPTION.name(), new String[]{RESPONSE[0]});
    }

    @Test
    public void sendObjectHasExecutionExceptionOnClientTest() throws Exception {
        this.sendOnClientHasExecutionException(OPS.SENDOBJECTEXECUTIONEXCEPTION);
    }

    @Test
    public void sendObjectWithHandlerOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECTHANDLER);
    }

    @Test
    public void sendObjectWithHandlerOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECTHANDLER);
    }

    @Test
    public void sendObjectWithHandlerThrowsIAEOnServerWhenDataIsNullTest() throws Exception {
        this.invoke("server", OPS.SENDOBJECTHANDLERTHROWSONDATA.name(), new String[]{RESPONSE[0]});
    }

    @Test
    public void sendObjectWithHandlerThrowsIAEOnServerWhenHandlerIsNullTest() throws Exception {
        this.invoke("server", OPS.SENDOBJECTHANDLERTHROWSONHANDLER.name(), new String[]{RESPONSE[0]});
    }

    @Test
    public void sendObjectWithHandlerThrowsIAEOnClientWhenDataIsNullTest() throws Exception {
        this.sendOnClientThrows(OPS.SENDOBJECTHANDLERTHROWSONDATA);
    }

    @Test
    public void sendObjectWithHandlerThrowsIAEOnClientWhenHandlerIsNullTest() throws Exception {
        this.sendOnClientThrows(OPS.SENDOBJECTHANDLERTHROWSONHANDLER);
    }

    @Test
    public void sendObjectWithHandlerHasExceptionOnServerTest() throws Exception {
        this.setClientEndpoint(BinaryAndTextClientEndpoint.class);
        this.invoke("throwing", OPS.SENDOBJECTHANDLEREXECUTIONEXCEPTION.name(), new String[]{RESPONSE[0]});
    }

    @Test
    public void sendObjectWithHandlerHasExecutionExceptionOnClientTest() throws Exception {
        this.sendOnClientHasExecutionException(OPS.SENDOBJECTHANDLEREXECUTIONEXCEPTION);
    }

    @Test
    public void sendTextOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDTEXT);
    }

    @Test
    public void sendTextOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDTEXT);
    }

    @Test
    public void sendTextThrowsIAEOnServerTest() throws Exception {
        this.invoke("server", OPS.SENDTEXTTHROWS.name(), new String[]{RESPONSE[0]});
    }

    @Test
    public void sendTextThrowsIAEOnClientTest() throws Exception {
        this.sendOnClientThrows(OPS.SENDTEXTTHROWS);
    }

    @Test
    public void sendTextWithHandlerOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDTEXTHANDLER);
    }

    @Test
    public void sendTextWithHandlerOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDTEXTHANDLER);
    }

    @Test
    public void sendTextWithHandlerThrowsIAEOnServerWhenDataIsNullTest() throws Exception {
        this.invoke("server", OPS.SENDTEXTHANDLERTHROWSONDATA.name(), new String[]{RESPONSE[0]});
    }

    @Test
    public void sendTextWithHandlerThrowsIAEOnServerWhenHandlerIsNullTest() throws Exception {
        this.invoke("server", OPS.SENDTEXTHANDLERTHROWSONHANDLER.name(), new String[]{RESPONSE[0]});
    }

    @Test
    public void sendTextWithHandlerThrowsIAEOnClientWhenDataIsNullTest() throws Exception {
        this.sendOnClientThrows(OPS.SENDTEXTHANDLERTHROWSONDATA);
    }

    @Test
    public void sendTextWithHandlerThrowsIAEOnClientWhenHandlerIsNullTest() throws Exception {
        this.sendOnClientThrows(OPS.SENDTEXTHANDLERTHROWSONHANDLER);
    }

    @Test
    public void batchingAllowedOnServerTest() throws Exception {
        this.sendOnServer(OPS.BATCHING_ALLOWED);
    }

    @Test
    public void batchingAllowedOnClientTest() throws Exception {
        this.sendOnClient(OPS.BATCHING_ALLOWED);
    }

    @Test
    public void sendPingOnServerTest() throws Exception {
        this.setCountDownLatchCount(2);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, OPS.SEND_PING.name());
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"server"}));
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, this.search(new Object[]{RESPONSE[0], OPS.SEND_PING}));
        this.invoke();
    }

    @Test
    public void sendPingOnClientTest() throws Exception {
        this.setClientEndpoint(PongMessageClientEndpoint.class);
        this.sendOnClient(OPS.SEND_PING);
    }

    @Test
    public void sendPingDelaysTimoutOnServerTest() throws Exception {
        StringPingMessage ping = new StringPingMessage(OPS.POKE.name());
        this.setClientEndpoint(PongMessageClientEndpoint.class);
        this.invoke("server", OPS.IDLE.name(), OPS.IDLE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(ping, OPS.POKE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(ping, OPS.POKE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(ping, OPS.POKE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(OPS.POKE.name(), OPS.POKE.name(), true);
    }

    @Test
    public void sendPingDelaysTimoutOnClientTest() throws Exception {
        this.setClientEndpoint(PongMessageClientEndpoint.class);
        this.invoke("server", OPS.POKE.name(), OPS.POKE.name(), false);
        this.getSession().setMaxIdleTimeout(1500L);
        this.setCountDownLatchCount(5);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, OPS.PING_4_TIMES.name());
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, new String[]{OPS.POKE.name(), OPS.POKE.name(), OPS.POKE.name(), OPS.POKE.name()});
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING_IGNORE_CASE, new String[0]);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING_IGNORE_CASE, RESPONSE[0]);
        this.invokeAgain(true);
    }

    @Test
    public void sendPingThrowsOnServerTest() throws Exception {
        this.invoke("server", OPS.SEND_PING_THROWS, new String[]{RESPONSE[0]});
    }

    @Test
    public void sendPingThrowsOnClientTest() throws Exception {
        this.sendOnClientThrows(OPS.SEND_PING_THROWS);
    }

    @Test
    public void sendPongOnServerTest() throws Exception {
        this.sendOnServer(OPS.SEND_PONG, OPS.SEND_PONG.name(), PongMessageClientEndpoint.class);
    }

    @Test
    public void sendPongOnClientTest() throws Exception {
        this.sendOnClient(OPS.SEND_PONG);
    }

    @Test
    public void sendPongDelaysTimoutOnServerTest() throws Exception {
        StringPongMessage ping = new StringPongMessage(OPS.POKE.name());
        this.setClientEndpoint(PongMessageClientEndpoint.class);
        this.invoke("server", OPS.IDLE.name(), OPS.IDLE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(ping, OPS.POKE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(ping, OPS.POKE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(ping, OPS.POKE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(OPS.POKE.name(), OPS.POKE.name(), true);
    }

    @Test
    public void sendPongDelaysTimoutOnClientTest() throws Exception {
        this.setClientEndpoint(PongMessageClientEndpoint.class);
        this.invoke("server", OPS.POKE.name(), OPS.POKE.name(), false);
        this.getSession().setMaxIdleTimeout(1500L);
        this.setCountDownLatchCount(5);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, OPS.PONG_4_TIMES.name());
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, new String[]{OPS.POKE.name(), OPS.POKE.name(), OPS.POKE.name(), OPS.POKE.name()});
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING_IGNORE_CASE, new String[0]);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING_IGNORE_CASE, RESPONSE[0]);
        this.invokeAgain(true);
    }

    @Test
    public void sendPongThrowsOnServerTest() throws Exception {
        this.invoke("server", OPS.SEND_PONG_THROWS, new String[]{RESPONSE[0]});
    }

    @Test
    public void sendPongThrowsOnClientTest() throws Exception {
        this.sendOnClientThrows(OPS.SEND_PONG_THROWS);
    }

    private String search(Object ... ops) {
        return StringUtil.objectsToStringWithDelimiter((String)"|", (Object[])ops);
    }

    private void sendOnServer(OPS ops) throws Exception {
        this.sendOnServer(ops, (Object)ops);
    }

    private void sendOnServer(OPS ops, Object search) throws Exception {
        this.sendOnServer(ops, search, BinaryAndTextClientEndpoint.class);
    }

    private void sendOnServer(OPS ops, Object search, Class<? extends ClientEndpoint<?>> endpoint) throws Exception {
        this.setCountDownLatchCount(3);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ops.name());
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(new String[]{"server"}));
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, this.search(new Object[]{search, OPS.POKE, RESPONSE[0]}));
        PokingEndpointCallback callback = new PokingEndpointCallback(this.entity);
        this.setClientCallback((EndpointCallback)callback);
        this.setClientEndpoint(endpoint);
        this.invoke();
    }

    private void sendOnClient(OPS op) throws Exception {
        this.sendOnClient(op, op.name());
    }

    private void sendOnClient(final OPS op, String search) throws Exception {
        AsyncEndpointCallback callback = new AsyncEndpointCallback(){

            @Override
            void doAsync(RemoteEndpoint.Async asyncRemote) throws Exception {
                String ret = null;
                String method = null;
                switch (op) {
                    case SENDBINARY: {
                        ret = WSCServerSideServer.sendBinary(asyncRemote);
                        method = "sendBinary(ByteBuffer)";
                        break;
                    }
                    case SENDBINARYHANDLER: {
                        ret = WSCServerSideServer.sendBinaryWithHandler(asyncRemote);
                        method = "sendBinary(ByteBuffer, SendHandler)";
                        break;
                    }
                    case SENDOBJECT: {
                        ret = WSCServerSideServer.sendObject(asyncRemote);
                        method = "sendObject(Object)";
                        break;
                    }
                    case SENDOBJECTHANDLER: {
                        ret = WSCServerSideServer.sendObjectWithHandler(asyncRemote);
                        method = "sendObject(Object, SendHandler)";
                        break;
                    }
                    case SENDOBJECT_BOOL: {
                        ret = WSCServerSideServer.sendObject(asyncRemote, Boolean.TYPE);
                        method = "sendObject(boolean)";
                        break;
                    }
                    case SENDOBJECT_BYTE: {
                        ret = WSCServerSideServer.sendObject(asyncRemote, Byte.TYPE);
                        method = "sendObject(byte)";
                        break;
                    }
                    case SENDOBJECT_CHAR: {
                        ret = WSCServerSideServer.sendObject(asyncRemote, Character.TYPE);
                        method = "sendObject(char)";
                        break;
                    }
                    case SENDOBJECT_DOUBLE: {
                        ret = WSCServerSideServer.sendObject(asyncRemote, Double.TYPE);
                        method = "sendObject(double)";
                        break;
                    }
                    case SENDOBJECT_FLOAT: {
                        ret = WSCServerSideServer.sendObject(asyncRemote, Float.TYPE);
                        method = "sendObject(float)";
                        break;
                    }
                    case SENDOBJECT_INT: {
                        ret = WSCServerSideServer.sendObject(asyncRemote, Integer.TYPE);
                        method = "sendObject(int)";
                        break;
                    }
                    case SENDOBJECT_LONG: {
                        ret = WSCServerSideServer.sendObject(asyncRemote, Long.TYPE);
                        method = "sendObject(long)";
                        break;
                    }
                    case SENDOBJECT_SHORT: {
                        ret = WSCServerSideServer.sendObject(asyncRemote, Short.TYPE);
                        method = "sendObject(short)";
                        break;
                    }
                    case SENDTEXT: {
                        ret = WSCServerSideServer.sendText(asyncRemote);
                        method = "sendText(String)";
                        break;
                    }
                    case SENDTEXTHANDLER: {
                        ret = WSCServerSideServer.sendTextWithHandler(asyncRemote);
                        method = "sendText(String, SendHandler)";
                        break;
                    }
                    case BATCHING_ALLOWED: {
                        ret = WSCServerSideServer.batchingAllowed(asyncRemote);
                        method = "setBatchingAllowed(!getBatchingAllowed)";
                        break;
                    }
                    case SEND_PING: {
                        ret = WSCServerSideServer.sendPing(asyncRemote);
                        method = "sendPing(ByteBuffer)";
                        break;
                    }
                    case SEND_PONG: {
                        ret = WSCServerSideServer.sendPong(asyncRemote);
                        method = "sendPong(ByteBuffer)";
                        break;
                    }
                    default: {
                        new Exception("Method " + String.valueOf((Object)op) + " not implemented");
                    }
                }
                WebSocketCommonClient.assertEquals((Object)RESPONSE[0], (Object)ret, (Object[])new Object[]{method, "did not endup as expected"});
                WebSocketCommonClient.logMsg((Object[])new Object[]{method, "works as expected"});
            }
        };
        this.setClientCallback(callback);
        LinkedList<Class<StringBeanTextEncoder>> list = new LinkedList<Class<StringBeanTextEncoder>>();
        list.add(StringBeanTextEncoder.class);
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().encoders(list).build();
        this.setClientEndpointConfig(config);
        this.invoke("client", "anything", new String[]{search});
    }

    private void sendOnClientHasExecutionException(final OPS op) throws Exception {
        AsyncEndpointCallback callback = new AsyncEndpointCallback(){

            @Override
            void doAsync(RemoteEndpoint.Async asyncRemote) throws Exception {
                String ret = null;
                String method = null;
                switch (op) {
                    case SENDOBJECTEXECUTIONEXCEPTION: {
                        ret = WSCThrowingServerSideServer.sendObjectHasExecutionException(asyncRemote);
                        method = "sendObject(Object)";
                        break;
                    }
                    case SENDOBJECTHANDLEREXECUTIONEXCEPTION: {
                        ret = WSCThrowingServerSideServer.sendObjectWithSendHandlerHasExecutionException(asyncRemote);
                        method = "sendObject(Object, SendHandler)";
                        break;
                    }
                    default: {
                        new Exception("Method " + String.valueOf((Object)op) + " not implemented");
                    }
                }
                WebSocketCommonClient.assertEquals((Object)RESPONSE[0], (Object)ret, (Object[])new Object[]{method, "did not endup with ExecutionException"});
                WebSocketCommonClient.logMsg((Object[])new Object[]{method, "end up with  ExecutionException as expected"});
                asyncRemote.sendText((String)WSClientIT.this.entity.getEntityAt(String.class, 0));
            }
        };
        this.setClientCallback(callback);
        LinkedList<Class<ThrowingStringBeanEncoder>> list = new LinkedList<Class<ThrowingStringBeanEncoder>>();
        list.add(ThrowingStringBeanEncoder.class);
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().encoders(list).build();
        this.setClientEndpointConfig(config);
        this.invoke("client", ECHO, new String[]{ECHO});
    }

    private void sendOnClientThrows(final OPS op) throws Exception {
        AsyncEndpointCallback callback = new AsyncEndpointCallback(){

            @Override
            void doAsync(RemoteEndpoint.Async asyncRemote) throws Exception {
                String ret = null;
                String method = null;
                switch (op) {
                    case SENDBINARYTHROWS: {
                        ret = WSCServerSideServer.sendBinaryThrows(asyncRemote);
                        method = "sendBinary(ByteBuffer)";
                        break;
                    }
                    case SENDBINARYHANDLERTHROWSONDATA: {
                        ret = WSCServerSideServer.sendBinaryWithHandlerThrowsOnData(asyncRemote);
                        method = "sendBinary(ByteBuffer, SendHandler)";
                        break;
                    }
                    case SENDBINARYHANDLERTHROWSONHANDLER: {
                        ret = WSCServerSideServer.sendBinaryWithHandlerThrowsOnHandler(asyncRemote);
                        method = "sendBinary(ByteBuffer, SendHandler)";
                        break;
                    }
                    case SENDOBJECTTHROWS: {
                        ret = WSCServerSideServer.sendObjectThrows(asyncRemote);
                        method = "sendObject(Object)";
                        break;
                    }
                    case SENDOBJECTHANDLERTHROWSONDATA: {
                        ret = WSCServerSideServer.sendObjectWithHandlerThrowsOnData(asyncRemote);
                        method = "sendObject(Object, SendHandler)";
                        break;
                    }
                    case SENDOBJECTHANDLERTHROWSONHANDLER: {
                        ret = WSCServerSideServer.sendObjectWithHandlerThrowsOnHandler(asyncRemote);
                        method = "sendObject(object, SendHandler)";
                        break;
                    }
                    case SENDTEXTTHROWS: {
                        ret = WSCServerSideServer.sendTextThrows(asyncRemote);
                        method = "sendText(String)";
                        break;
                    }
                    case SENDTEXTHANDLERTHROWSONDATA: {
                        ret = WSCServerSideServer.sendTextWithHandlerThrowsOnData(asyncRemote);
                        method = "sendText(String, SendHandler)";
                        break;
                    }
                    case SENDTEXTHANDLERTHROWSONHANDLER: {
                        ret = WSCServerSideServer.sendTextWithHandlerThrowsOnHandler(asyncRemote);
                        method = "sendText(String, SendHandler)";
                        break;
                    }
                    case SEND_PING_THROWS: {
                        ret = WSCServerSideServer.sendPingThrows(asyncRemote);
                        method = "sendPing(<too_long_message>)";
                        break;
                    }
                    case SEND_PONG_THROWS: {
                        ret = WSCServerSideServer.sendPongThrows(asyncRemote);
                        method = "sendPong(<too_long_message>)";
                        break;
                    }
                    default: {
                        new Exception("Method " + String.valueOf((Object)op) + " not implemented");
                    }
                }
                WebSocketCommonClient.assertEquals((Object)RESPONSE[0], (Object)ret, (Object[])new Object[]{method, "does not throw IllegalArgumentException as expected"});
                WebSocketCommonClient.logMsg((Object[])new Object[]{method, "throws IllegalArgumentException as expected"});
                asyncRemote.sendText((String)WSClientIT.this.entity.getEntityAt(String.class, 0));
            }
        };
        this.setClientCallback(callback);
        this.invoke("client", ECHO, new String[]{ECHO});
    }
}

