/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.srlistener;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import servlet.tck.common.util.ServletTestUtil;

public class ForwardedServlet
extends HttpServlet {
    private static final String TEST_HEADER = "testname";
    private static final Class[] TEST_ARGS = new Class[]{HttpServletRequest.class, HttpServletResponse.class};

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String test = req.getParameter(TEST_HEADER);
        try {
            Method method = ((Object)((Object)this)).getClass().getMethod(test, TEST_ARGS);
            method.invoke((Object)this, req, res);
        }
        catch (InvocationTargetException ite) {
            throw new ServletException(ite.getTargetException());
        }
        catch (NoSuchMethodException nsme) {
            throw new ServletException("Test: " + test + " does not exist");
        }
        catch (Throwable t) {
            throw new ServletException("Error executing test: " + test, t);
        }
    }

    public void simple(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter pw = res.getWriter();
        pw.print("ForwardedServlet Invoked, simple method");
        System.out.println("In ForwardedServlet, simple method");
        ServletTestUtil.printResult(pw, true);
    }

    public void forwardagain(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/forward/SecondForwardedServlet?testname=simple";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        System.out.println("In forwardedServlet, forwardagain method");
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void include(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String path = "/include/IncludedServlet?testname=simple";
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
        System.out.println("In forwardedServlet, include method");
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void error(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        System.out.println("In ForwardedServlet, error method");
        res.sendError(403);
    }
}

