/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.core_syntax.actions.output;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    private static final String CONTEXT_ROOT = "/jsp_core_act_output_web";

    public URLClientIT() throws Exception {
        this.setContextRoot(CONTEXT_ROOT);
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_core_act_output_web.war");
        archive.addClasses(new Class[]{JspTestUtil.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_core_act_output_web.xml"));
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/simpleDefaultTest.jspx")), "simpleDefaultTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeMultipleDoctypeTest.jspx")), "negativeMultipleDoctypeTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeDoctypeSystemNoRoot.jspx")), "negativeDoctypeSystemNoRoot.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeDoctypeRootNoSystem.jspx")), "negativeDoctypeRootNoSystem.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeDoctypePublicNoSystemTest.jspx")), "negativeDoctypePublicNoSystemTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputUsageContextTest4.jsp")), "JspOutputUsageContextTest4.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputUsageContextTest3.jspx")), "JspOutputUsageContextTest3.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputUsageContextTest2.jsp")), "JspOutputUsageContextTest2.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputUsageContextTest1.jsp")), "JspOutputUsageContextTest1.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputOmitDeclValidValuesTest8.jsp")), "JspOutputOmitDeclValidValuesTest8.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputOmitDeclValidValuesTest7.jsp")), "JspOutputOmitDeclValidValuesTest7.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputOmitDeclValidValuesTest6.jsp")), "JspOutputOmitDeclValidValuesTest6.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputOmitDeclValidValuesTest5.jsp")), "JspOutputOmitDeclValidValuesTest5.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputOmitDeclValidValuesTest4.jspx")), "JspOutputOmitDeclValidValuesTest4.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputOmitDeclValidValuesTest3.jspx")), "JspOutputOmitDeclValidValuesTest3.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputOmitDeclValidValuesTest2.jspx")), "JspOutputOmitDeclValidValuesTest2.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputOmitDeclValidValuesTest1.jspx")), "JspOutputOmitDeclValidValuesTest1.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputOmitDeclDefaultTest.jspx")), "JspOutputOmitDeclDefaultTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputOmitDeclDefaultTagTest.jsp")), "JspOutputOmitDeclDefaultTagTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputJspRootOmitDeclDefaultTest.jspx")), "JspOutputJspRootOmitDeclDefaultTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputBodyTest2.jsp")), "JspOutputBodyTest2.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspOutputBodyTest1.jspx")), "JspOutputBodyTest1.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/doctypeSystemTest.jspx")), "doctypeSystemTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/doctypeSystemPublicTest.jspx")), "doctypeSystemPublicTest.jspx");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspOutputUsageXMLTag.tagx", "tags/JspOutputUsageXMLTag.tagx");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspOutputUsageTag.tag", "tags/JspOutputUsageTag.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspOutputOmitDeclYesTag.tagx", "tags/JspOutputOmitDeclYesTag.tagx");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspOutputOmitDeclTrueTag.tagx", "tags/JspOutputOmitDeclTrueTag.tagx");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspOutputOmitDeclNoTag.tagx", "tags/JspOutputOmitDeclNoTag.tagx");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspOutputOmitDeclFalseTag.tagx", "tags/JspOutputOmitDeclFalseTag.tagx");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspOutputDefaultTag.tagx", "tags/JspOutputDefaultTag.tagx");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/JspOutputBodyTag.tagx", "tags/JspOutputBodyTag.tagx");
        return archive;
    }

    @Test
    public void jspOutputUsageContextTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputUsageContextTest1.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputUsageContextTest2.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputUsageContextTest3.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<?xml version=\"1.0\" encoding=\"UTF-8\"|?>|<root></root>");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputUsageContextTest4.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<?xml version=\"1.0\" encoding=\"UTF-8\"|?>|<root></root>");
        this.invoke();
    }

    @Test
    public void jspOutputOmitDeclValidValuesTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputOmitDeclValidValuesTest1.jspx HTTP/1.1");
        TEST_PROPS.setProperty("unexpected_response_match", "<?xml");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputOmitDeclValidValuesTest2.jspx HTTP/1.1");
        TEST_PROPS.setProperty("unexpected_response_match", "<?xml");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputOmitDeclValidValuesTest3.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<?xml version=\"1.0\" encoding=\"UTF-8\"|?>");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputOmitDeclValidValuesTest4.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<?xml version=\"1.0\" encoding=\"UTF-8\"|?>");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputOmitDeclValidValuesTest5.jsp HTTP/1.1");
        TEST_PROPS.setProperty("unexpected_response_match", "<?xml");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputOmitDeclValidValuesTest6.jsp HTTP/1.1");
        TEST_PROPS.setProperty("unexpected_response_match", "<?xml");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputOmitDeclValidValuesTest7.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<?xml version=\"1.0\" encoding=\"UTF-8\"|?>");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputOmitDeclValidValuesTest8.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<?xml version=\"1.0\" encoding=\"UTF-8\"|?>");
        this.invoke();
    }

    @Test
    public void jspOutputJspRootOmitDeclDefaultTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputJspRootOmitDeclDefaultTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("unexpected_response_match", "<?xml");
        this.invoke();
    }

    @Test
    public void jspOutputOmitDeclDefaultTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputOmitDeclDefaultTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<?xml version=\"1.0\" encoding=\"UTF-8\"|?>");
        this.invoke();
    }

    @Test
    public void jspOutputOmitDeclDefaultTagTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputOmitDeclDefaultTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<?xml version=\"1.0\" encoding=\"UTF-8\"|?>");
        this.invoke();
    }

    @Test
    public void jspOutputBodyTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputBodyTest1.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/JspOutputBodyTest2.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void simpleDefaultTest() throws Exception {
        String testName = "simpleDefaultTest";
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/" + testName + ".jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<?xml version=\"1.0\" encoding=\"UTF-8\"|?>");
        this.invoke();
    }

    @Test
    public void doctypeSystemTest() throws Exception {
        String testName = "doctypeSystemTest";
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/" + testName + ".jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<!DOCTYPE html SYSTEM |http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd|Example XHTML Document");
        this.invoke();
    }

    @Test
    public void doctypeSystemPublicTest() throws Exception {
        String testName = "doctypeSystemPublicTest";
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/" + testName + ".jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "<!DOCTYPE html PUBLIC |-//W3C//DTD XHTML Basic 1.0//EN|http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd|Example XHTML Document");
        this.invoke();
    }

    @Test
    public void negativeDoctypeRootTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/negativeDoctypeRootNoSystem.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/negativeDoctypeSystemNoRoot.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeDoctypePublicNoSystemTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/negativeDoctypePublicNoSystemTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeMultipleDoctypeTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_core_act_output_web/negativeMultipleDoctypeTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }
}

