/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.junit.SecurityActions;
import org.jboss.arquillian.junit.event.BeforeRules;
import org.jboss.arquillian.junit.event.RulesEnrichment;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.test.spi.event.enrichment.AfterEnrichment;
import org.jboss.arquillian.test.spi.event.enrichment.BeforeEnrichment;
import org.jboss.arquillian.test.spi.event.enrichment.EnrichmentEvent;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesEnricher {
    private static Logger log = Logger.getLogger(RulesEnricher.class.getName());
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Event<EnrichmentEvent> enrichmentEvent;

    public void enrichRulesAndTestInstance(@Observes RulesEnrichment event) throws Exception {
        Object testInstance = event.getTestInstance();
        List<Object> toEnrich = this.getRuleInstances(testInstance);
        if (toEnrich == null) {
            return;
        }
        toEnrich.add(testInstance);
        this.enrichInstances(toEnrich);
    }

    public void enrichStatement(@Observes BeforeRules event) throws Exception {
        ArrayList<Object> toEnrich = new ArrayList<Object>();
        if (RunRules.class.isInstance(event.getStatementInstance())) {
            toEnrich.add(SecurityActions.getField(RunRules.class, "statement").get(event.getStatementInstance()));
        } else {
            toEnrich.add(event.getStatementInstance());
        }
        this.enrichInstances(toEnrich);
    }

    public void enrichInstances(List<Object> toEnrich) {
        Collection testEnrichers = ((ServiceLoader)this.serviceLoader.get()).all(TestEnricher.class);
        for (Object instance : toEnrich) {
            this.enrichmentEvent.fire((Object)new BeforeEnrichment(instance));
            for (TestEnricher enricher : testEnrichers) {
                enricher.enrich(instance);
            }
            this.enrichmentEvent.fire((Object)new AfterEnrichment(instance));
        }
    }

    private List<Object> getRuleInstances(Object testInstance) throws Exception {
        ArrayList<Object> ruleInstances = new ArrayList<Object>();
        List<Field> fieldsWithRuleAnnotation = SecurityActions.getFieldsWithAnnotation(testInstance.getClass(), Rule.class);
        if (fieldsWithRuleAnnotation.isEmpty()) {
            List<Method> methodsWithAnnotation = SecurityActions.getMethodsWithAnnotation(testInstance.getClass(), Rule.class);
            if (methodsWithAnnotation.isEmpty()) {
                return null;
            }
            log.warning("Please note that methods annotated with @Rule are not fully supported in Arquillian. Specifically, if you want to enrich a field in your Rule implementation class.");
            return ruleInstances;
        }
        for (Field field : fieldsWithRuleAnnotation) {
            Object fieldInstance = field.get(testInstance);
            if (!this.isRule(fieldInstance)) continue;
            ruleInstances.add(fieldInstance);
        }
        return ruleInstances;
    }

    private boolean isRule(Object instance) {
        return MethodRule.class.isInstance(instance) || TestRule.class.isInstance(instance);
    }
}

