/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.orm20;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.orm20.LockModeType;
import org.jboss.shrinkwrap.descriptor.api.orm20.NamedQuery;
import org.jboss.shrinkwrap.descriptor.api.orm20.QueryHint;
import org.jboss.shrinkwrap.descriptor.impl.orm20.QueryHintImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedQueryImpl<T>
implements Child<T>,
NamedQuery<T> {
    private T t;
    private Node childNode;

    public NamedQueryImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public NamedQueryImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    public T up() {
        return this.t;
    }

    public NamedQuery<T> description(String description) {
        this.childNode.getOrCreate("description").text(description);
        return this;
    }

    public String getDescription() {
        return this.childNode.getTextValueForPatternName("description");
    }

    public NamedQuery<T> removeDescription() {
        this.childNode.removeChildren("description");
        return this;
    }

    public NamedQuery<T> query(String query) {
        this.childNode.getOrCreate("query").text(query);
        return this;
    }

    public String getQuery() {
        return this.childNode.getTextValueForPatternName("query");
    }

    public NamedQuery<T> removeQuery() {
        this.childNode.removeChildren("query");
        return this;
    }

    public NamedQuery<T> lockMode(LockModeType lockMode) {
        this.childNode.getOrCreate("lock-mode").text((Object)lockMode);
        return this;
    }

    public NamedQuery<T> lockMode(String lockMode) {
        this.childNode.getOrCreate("lock-mode").text(lockMode);
        return this;
    }

    public LockModeType getLockMode() {
        return LockModeType.getFromStringValue((String)this.childNode.getTextValueForPatternName("lock-mode"));
    }

    public String getLockModeAsString() {
        return this.childNode.getTextValueForPatternName("lock-mode");
    }

    public NamedQuery<T> removeLockMode() {
        this.childNode.removeAttribute("lock-mode");
        return this;
    }

    public QueryHint<NamedQuery<T>> getOrCreateHint() {
        List nodeList = this.childNode.get("hint");
        if (nodeList != null && nodeList.size() > 0) {
            return new QueryHintImpl<NamedQuery<T>>(this, "hint", this.childNode, (Node)nodeList.get(0));
        }
        return this.createHint();
    }

    public QueryHint<NamedQuery<T>> createHint() {
        return new QueryHintImpl<NamedQuery<T>>(this, "hint", this.childNode);
    }

    public List<QueryHint<NamedQuery<T>>> getAllHint() {
        ArrayList<QueryHint<NamedQuery<T>>> list = new ArrayList<QueryHint<NamedQuery<T>>>();
        List nodeList = this.childNode.get("hint");
        for (Node node : nodeList) {
            QueryHintImpl<NamedQueryImpl> type = new QueryHintImpl<NamedQueryImpl>(this, "hint", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    public NamedQuery<T> removeAllHint() {
        this.childNode.removeChildren("hint");
        return this;
    }

    public NamedQuery<T> name(String name) {
        this.childNode.attribute("name", name);
        return this;
    }

    public String getName() {
        return this.childNode.getAttribute("name");
    }

    public NamedQuery<T> removeName() {
        this.childNode.removeAttribute("name");
        return this;
    }
}

