/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Transaction;

@Service(name="_lifecycle")
@PerLookup
@ExecuteOn(value={RuntimeType.INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="_lifecycle", description="_lifecycle")})
public class InstanceLifecycleModuleCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InstanceLifecycleModuleCommand.class);
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    public String target = "server";
    @Param(optional=true)
    public String virtualservers = null;
    @Param(optional=true, defaultValue="true")
    public Boolean enabled = true;
    @Param(separator=58)
    public Properties appprops = null;
    @Inject
    Deployment deployment;
    @Inject
    Applications applications;
    @Inject
    private Domain domain;

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        accessChecks.add(new AccessRequired.AccessCheck(DeploymentCommandUtils.getTargetResourceNameForNewAppRef(this.domain, this.target), "write"));
        return accessChecks;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        try {
            Application application = this.applications.getApplication(this.name);
            Transaction t = new Transaction();
            DeployCommandParameters commandParams = new DeployCommandParameters();
            commandParams.name = this.name;
            commandParams.target = this.target;
            commandParams.enabled = this.enabled;
            commandParams.virtualservers = this.virtualservers;
            DeploymentContextImpl lifecycleContext = new DeploymentContextImpl(report, null, (OpsParams)commandParams, null);
            lifecycleContext.getAppProps().putAll((Map<?, ?>)this.appprops);
            if (application != null) {
                this.deployment.registerAppInDomainXML(null, (DeploymentContext)lifecycleContext, t, true);
            } else {
                t = this.deployment.prepareAppConfigChanges((DeploymentContext)lifecycleContext);
                this.deployment.registerAppInDomainXML(null, (DeploymentContext)lifecycleContext, t);
            }
        }
        catch (Exception e) {
            report.failure(logger, e.getMessage());
        }
    }
}

