/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.loadbalancer.admin.cli.LbLogUtil;
import org.glassfish.loadbalancer.admin.cli.helper.LbConfigHelper;
import org.glassfish.loadbalancer.admin.cli.reader.api.LoadbalancerReader;
import org.glassfish.loadbalancer.admin.cli.reader.impl.LoadbalancerReaderImpl;
import org.glassfish.loadbalancer.config.LbConfig;
import org.glassfish.loadbalancer.config.LoadBalancer;
import org.jvnet.hk2.annotations.Service;

@Service(name="export-http-lb-config")
@PerLookup
@I18n(value="export.http.lb.config")
@RestEndpoints(value={@RestEndpoint(configBean=LbConfig.class, opType=RestEndpoint.OpType.POST, path="export-http-lb-config", description="export-http-lb-config"), @RestEndpoint(configBean=LoadBalancer.class, opType=RestEndpoint.OpType.POST, path="export-http-lb-config", description="export-http-lb-config", params={@RestParam(name="lbname", value="$parent")})})
public class ExportHttpLbConfig
implements AdminCommand {
    @Param(name="lbtargets", separator=44, optional=true)
    List<String> target;
    @Param(name="config", optional=true)
    String lbConfigName;
    @Param(name="lbname", optional=true)
    String lbName;
    @Param(name="retrievefile", optional=true, defaultValue="false")
    boolean retrieveFile;
    @Param(name="file_name", optional=true, primary=true)
    String fileName;
    @Param(name="property", optional=true, separator=58)
    Properties properties;
    @Inject
    Domain domain;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    ServerEnvironment env;
    private static final String DEFAULT_LB_XML_FILE_NAME = "loadbalancer.xml";

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            String msg = this.process(context);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(msg);
        }
        catch (Throwable t) {
            String msg = LbLogUtil.getStringManager().getString("ExportHttpLbConfigFailed", (Object)t.getMessage());
            LbLogUtil.getLogger().log(Level.WARNING, msg);
            if (LbLogUtil.getLogger().isLoggable(Level.FINE)) {
                LbLogUtil.getLogger().log(Level.FINE, "Exception when exporting http lb config", t);
            }
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(t.getMessage());
            report.setFailureCause(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process(AdminCommandContext context) throws Exception {
        File lbConfigFile;
        LoadbalancerReader lbr = null;
        if (this.lbName != null && this.lbConfigName == null && this.target == null) {
            LoadBalancer lb = LbConfigHelper.getLoadBalancer(this.domain, this.lbName);
            lbr = LbConfigHelper.getLbReader(this.domain, this.appRegistry, lb.getLbConfigName());
        } else if (this.lbConfigName != null && this.lbName == null && this.target == null) {
            lbr = LbConfigHelper.getLbReader(this.domain, this.appRegistry, this.lbConfigName);
        } else if (this.target != null && this.lbName == null && this.lbConfigName == null) {
            HashSet<String> clusters = new HashSet<String>();
            clusters.addAll(this.target);
            lbr = new LoadbalancerReaderImpl(this.domain, this.appRegistry, clusters, this.properties);
        } else {
            String msg = LbLogUtil.getStringManager().getString("ExportHttpLbConfigInvalidArgs");
            throw new Exception(msg);
        }
        if (this.fileName == null) {
            String configName = lbr.getName();
            this.fileName = configName != null ? "loadbalancer.xml." + configName : DEFAULT_LB_XML_FILE_NAME;
        }
        if (!(lbConfigFile = new File(this.fileName)).isAbsolute() && !this.retrieveFile) {
            boolean isMkdirSuccess;
            File loadbalancerDir = new File(this.env.getInstanceRoot(), "load-balancer");
            if (!loadbalancerDir.exists() && !(isMkdirSuccess = loadbalancerDir.mkdir())) {
                String msg = LbLogUtil.getStringManager().getString("directoryCreationFailed");
                throw new Exception(msg);
            }
            lbConfigFile = new File(loadbalancerDir, this.fileName);
        }
        File tmpLbXmlFile = null;
        if (this.retrieveFile) {
            tmpLbXmlFile = File.createTempFile("load-balancer", ".xml");
            tmpLbXmlFile.deleteOnExit();
        } else {
            if (lbConfigFile.exists()) {
                String msg = LbLogUtil.getStringManager().getString("FileExists", (Object)lbConfigFile.getPath());
                throw new Exception(msg);
            }
            if (!lbConfigFile.getParentFile().exists()) {
                String msg = LbLogUtil.getStringManager().getString("ParentFileMissing", (Object)lbConfigFile.getParent());
                throw new Exception(msg);
            }
            tmpLbXmlFile = lbConfigFile;
        }
        FileOutputStream fo = null;
        try {
            String msg;
            LbConfig lbConfig;
            fo = new FileOutputStream(tmpLbXmlFile);
            LbConfigHelper.exportXml(lbr, fo);
            if (this.retrieveFile) {
                this.retrieveLbConfig(context, lbConfigFile, tmpLbXmlFile);
            }
            if ((lbConfig = lbr.getLbConfig()) != null) {
                lbConfig.setLastExported();
            }
            String string = msg = LbLogUtil.getStringManager().getString("GeneratedFileLocation", (Object)lbConfigFile.toString());
            return string;
        }
        finally {
            if (fo != null) {
                fo.close();
                fo = null;
            }
        }
    }

    private void retrieveLbConfig(AdminCommandContext context, File lbConfigFile, File tmpLbXmlFile) throws Exception {
        File localFile = lbConfigFile;
        Properties props = new Properties();
        File parent = localFile.getParentFile();
        if (parent == null) {
            parent = localFile;
        }
        props.setProperty("file-xfer-root", parent.getPath().replace('\\', '/'));
        URI parentURI = parent.toURI();
        try {
            context.getOutboundPayload().attachFile("text/xml", parentURI.relativize(localFile.toURI()), "sync-load-balancer-xml", props, tmpLbXmlFile);
        }
        catch (IOException ex) {
            String msg = LbLogUtil.getStringManager().getString("RetrieveFailed", (Object)lbConfigFile.getAbsolutePath());
            throw new Exception(msg, ex);
        }
    }
}

