/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.util;

import java.nio.ByteBuffer;

public final class DumpUtils {
    public static String dumpBytes(ByteBuffer[] bb) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < bb.length; ++i) {
            stringBuffer.append(DumpUtils.dumpBytes(bb[i]));
        }
        return stringBuffer.toString();
    }

    public static String dumpBytes(ByteBuffer buffer) {
        return DumpUtils.dumpBytes(buffer, buffer.position(), buffer.limit() - buffer.position());
    }

    public static String dumpBytes(ByteBuffer buffer, int offset, int length) {
        byte[] array = new byte[length];
        int position = buffer.position();
        buffer.position(offset);
        buffer.get(array);
        buffer.position(position);
        return DumpUtils.dumpBytes(array);
    }

    public static String dumpOctets(ByteBuffer[] bb) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < bb.length; ++i) {
            stringBuffer.append(DumpUtils.dumpOctets(bb[i]));
        }
        return stringBuffer.toString();
    }

    public static String dumpOctets(ByteBuffer buffer) {
        return DumpUtils.dumpOctets(buffer, buffer.position(), buffer.limit() - buffer.position());
    }

    public static String dumpOctets(ByteBuffer buffer, int offset, int length) {
        byte[] array = new byte[length];
        int position = buffer.position();
        buffer.position(offset);
        buffer.get(array);
        buffer.position(position);
        return DumpUtils.dumpBytes(array);
    }

    public static String dump(ByteBuffer[] bb) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < bb.length; ++i) {
            stringBuffer.append(DumpUtils.dump(bb[i]));
        }
        return stringBuffer.toString();
    }

    public static String dump(ByteBuffer buffer) {
        return DumpUtils.dump(buffer, buffer.position(), buffer.limit() - buffer.position());
    }

    public static String dump(ByteBuffer buffer, int offset, int length) {
        byte[] array = new byte[length];
        int position = buffer.position();
        buffer.position(offset);
        buffer.get(array);
        buffer.position(position);
        return DumpUtils.dump(array);
    }

    public static String dump(byte[] buffer) {
        return DumpUtils.dump(buffer, 0, buffer.length);
    }

    public static String dump(byte[] buffer, int offset, int length) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int value = buffer[offset + i] & 0xFF;
            String strValue = Integer.toHexString(value).toUpperCase();
            String str = "00".substring(strValue.length()) + strValue;
            stringBuffer.append(str);
            stringBuffer.append('(');
            stringBuffer.append((char)value);
            stringBuffer.append(')');
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String dumpOctets(byte[] buffer) {
        return DumpUtils.dumpOctets(buffer, 0, buffer.length);
    }

    public static String dumpOctets(byte[] buffer, int offset, int length) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int value = buffer[offset + i] & 0xFF;
            String strValue = Integer.toHexString(value).toUpperCase();
            String str = "00".substring(strValue.length()) + strValue;
            stringBuffer.append(str);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String dumpBytes(byte[] buffer) {
        return DumpUtils.dumpBytes(buffer, 0, buffer.length);
    }

    public static String dumpBytes(byte[] buffer, int offset, int length) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int value = buffer[offset + i] & 0xFF;
            stringBuffer.append((char)value);
        }
        return stringBuffer.toString();
    }
}

