/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import org.glassfish.web.deployment.descriptor.MultipartConfigDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MultipartConfigNode
extends DeploymentDescriptorNode<MultipartConfigDescriptor> {
    private MultipartConfigDescriptor descriptor;

    public MultipartConfigDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new MultipartConfigDescriptor();
        }
        return this.descriptor;
    }

    protected Map<String, String> getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("location", "setLocation");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("max-file-size".equals(element.getQName())) {
            this.descriptor.setMaxFileSize(Long.valueOf(value));
        } else if ("max-request-size".equals(element.getQName())) {
            this.descriptor.setMaxRequestSize(Long.valueOf(value));
        } else if ("file-size-threshold".equals(element.getQName())) {
            this.descriptor.setFileSizeThreshold(Integer.valueOf(value));
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, MultipartConfigDescriptor descriptor) {
        Element myNode = MultipartConfigNode.appendChild((Node)parent, (String)nodeName);
        MultipartConfigNode.appendTextChild((Node)myNode, (String)"location", (String)descriptor.getLocation());
        if (descriptor.getMaxFileSize() != null) {
            MultipartConfigNode.appendTextChild((Node)myNode, (String)"max-file-size", (String)descriptor.getMaxFileSize().toString());
        }
        if (descriptor.getMaxRequestSize() != null) {
            MultipartConfigNode.appendTextChild((Node)myNode, (String)"max-request-size", (String)descriptor.getMaxRequestSize().toString());
        }
        if (descriptor.getFileSizeThreshold() != null) {
            MultipartConfigNode.appendTextChild((Node)myNode, (String)"file-size-threshold", (String)descriptor.getFileSizeThreshold().toString());
        }
        return myNode;
    }
}

