/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.pluralattribute;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.pluralattribute.Uni1XMPerson;
import ee.jakarta.tck.persistence.core.metamodelapi.pluralattribute.Uni1XMProject;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import java.lang.reflect.Member;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void getCollectionType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
            if (mType != null) {
                this.logTrace("Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mType.getCollection("projects", Uni1XMProject.class);
                PluralAttribute.CollectionType pluralColType = pluralAttrib.getCollectionType();
                this.logTrace("collection Type = " + String.valueOf(pluralAttrib.getCollectionType()));
                if (pluralColType == PluralAttribute.CollectionType.COLLECTION) {
                    this.logTrace("Received Expected Collection type = " + String.valueOf(pluralColType));
                    pass = true;
                } else {
                    this.logTrace("Received UnExpected Collection type = " + String.valueOf(pluralColType));
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionType Test  failed");
        }
    }

    public void getElementType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
            if (mType != null) {
                this.logTrace("Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mType.getCollection("projects", Uni1XMProject.class);
                this.logTrace("collection Element Type = " + pluralAttrib.getElementType().getJavaType().getName());
                String elementTypeName = pluralAttrib.getElementType().getJavaType().getName();
                if (elementTypeName.equals("ee.jakarta.tck.persistence.core.metamodelapi.pluralattribute.Uni1XMProject")) {
                    this.logTrace("Received Expected Element type = " + elementTypeName);
                    pass = true;
                } else {
                    this.logTrace("Received UnExpected Element type = " + elementTypeName);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getElementType Test  failed");
        }
    }

    public void isCollection() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                this.logTrace("Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                boolean b = pluralAttrib.isCollection();
                if (b) {
                    this.logTrace("Received expected result:" + b);
                    pass = true;
                } else {
                    this.logErr("Expected: true, actual: " + b);
                }
            } else {
                this.logErr("managedType() returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isCollection Test failed");
        }
    }

    public void isAssociation() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                this.logTrace("Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                boolean b = pluralAttrib.isAssociation();
                if (b) {
                    this.logTrace("Received expected result:" + b);
                    pass = true;
                } else {
                    this.logErr("Expected: true, actual: " + b);
                }
            } else {
                this.logErr("managedType() returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isAssociation Test failed");
        }
    }

    public void getPersistentAttributeType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                this.logTrace("Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    Attribute.PersistentAttributeType pAttribType = pluralAttrib.getPersistentAttributeType();
                    if (pAttribType == Attribute.PersistentAttributeType.ONE_TO_MANY) {
                        this.logTrace("Received expected result " + String.valueOf(pAttribType));
                        pass = true;
                    } else {
                        this.logErr("Expected: " + Attribute.PersistentAttributeType.ONE_TO_MANY.toString() + ", actual:" + String.valueOf(pAttribType));
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPersistentAttributeType Test failed");
        }
    }

    public void getName() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                this.logTrace("Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    String name = pluralAttrib.getName();
                    if (name.equals("projects")) {
                        this.logTrace("Received expected result" + name);
                        pass = true;
                    } else {
                        this.logErr("Expected: projects, actual:" + name);
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getName Test failed");
        }
    }

    public void getJavaType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                this.logTrace("Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    Class pPluralAttribJavaType = pluralAttrib.getJavaType();
                    if (pPluralAttribJavaType.getName().equals("java.util.Collection")) {
                        this.logTrace("Received expected result " + String.valueOf(pPluralAttribJavaType));
                        pass = true;
                    } else {
                        this.logErr("Expected: java.util.Collection, actual:" + String.valueOf(pPluralAttribJavaType));
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaType Test failed");
        }
    }

    public void getJavaMember() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                this.logTrace("Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    this.logTrace("Singular attribute JavaMember = " + pluralAttrib.getJavaMember().getName());
                    Member javaMember = pluralAttrib.getJavaMember();
                    if (javaMember.getName().equals("projects")) {
                        this.logTrace("Received expected result " + javaMember.getName());
                        pass = true;
                    } else {
                        this.logErr("Expected: projects, actual:" + javaMember.getName());
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaMember Test  failed");
        }
    }

    public void getBindableType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                this.logTrace("Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    this.logTrace("attribute Name = " + pluralAttrib.getName());
                    Bindable.BindableType bType = pluralAttrib.getBindableType();
                    if (bType != null) {
                        if (bType.name().equals(Bindable.BindableType.PLURAL_ATTRIBUTE.name())) {
                            this.logTrace("Received expected result:" + bType.name());
                            pass = true;
                        } else {
                            this.logErr("Expected: " + Bindable.BindableType.PLURAL_ATTRIBUTE.name() + ", actual:" + bType.name());
                        }
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getBindableType Test  failed");
        }
    }

    public void getBindableJavaType() throws Exception {
        boolean pass = false;
        String expected = "ee.jakarta.tck.persistence.core.metamodelapi.pluralattribute.Uni1XMProject";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                this.logTrace("Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    this.logTrace("attribute Name = " + pluralAttrib.getName());
                    Class cType = pluralAttrib.getBindableJavaType();
                    if (cType != null) {
                        if (cType.getName().equals(expected)) {
                            this.logTrace("Received expected result:" + cType.getName());
                            pass = true;
                        } else {
                            this.logErr("Expected: " + expected + ", actual:" + cType.getName());
                        }
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getBindableJavaType Test  failed");
        }
    }

    public void getDeclaringType() throws Exception {
        boolean pass = false;
        String expected = "ee.jakarta.tck.persistence.core.metamodelapi.pluralattribute.Uni1XMPerson";
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeUni1XMPerson = metaModel.managedType(Uni1XMPerson.class);
            if (mTypeUni1XMPerson != null) {
                this.logTrace("Obtained Non-null ManagedType");
                CollectionAttribute pluralAttrib = mTypeUni1XMPerson.getCollection("projects", Uni1XMProject.class);
                if (pluralAttrib != null) {
                    ManagedType type = pluralAttrib.getDeclaringType();
                    if (type != null) {
                        String name = type.getJavaType().getName();
                        if (name.equals(expected)) {
                            this.logTrace("Received expected result:" + name);
                            pass = true;
                        } else {
                            this.logErr("Expected: " + expected + ", actual:" + name);
                        }
                    } else {
                        this.logErr("getDeclaringType() returned null");
                    }
                } else {
                    this.logErr("getCollection(...) returned null");
                }
            } else {
                this.logErr("managedType() returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaringType Test  failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        try {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception re) {
            this.logErr("Unexpected Exception in removeTestData:", re);
        }
    }
}

