/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedQueueSession;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import jakarta.jms.BytesMessage;
import jakarta.jms.IllegalStateException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;

public class ClosedQueueSessionTests
extends ServiceEETest {
    private static final String TestName = "com.sun.ts.tests.jms.core.closedQueueSession.ClosedQueueSessionTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedQueueSessionTests theTests = new ClosedQueueSessionTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void createAndCloseSession(int type, String user, String password) throws Exception {
        if (type == 0 || type == 2) {
            this.tool = new JmsTool(type, user, password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logMsg("Closing QueueSession");
            this.tool.getDefaultQueueSession().close();
        } else if (type == 15) {
            this.tool = new JmsTool(type, user, password, this.mode);
            this.tool.getDefaultConnection().start();
            this.logMsg("Closing Session");
            this.tool.getDefaultSession().close();
        } else {
            this.logErr("Unspecified type");
        }
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing QueueConnection");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void closedQueueSessionCloseTest() throws Exception {
        try {
            TestUtil.logTrace((String)"Before create and close");
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to call close on closed session.");
            this.tool.getDefaultQueueSession().close();
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("fault " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCloseTest");
        }
    }

    public void closedQueueSessionCreateBrowserTest() throws Exception {
        String testName = "closedQueueSessionCreateBrowserTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create QueueBrowser with closed session.");
            try {
                QueueBrowser queueBrowser = this.tool.getDefaultQueueSession().createBrowser(this.tool.getDefaultQueue());
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            throw new Exception("closedQueueSessionCreateBrowserTest", e);
        }
    }

    public void closedQueueSessionCreateBrowserMsgSelectorTest() throws Exception {
        String testName = "closedQueueSessionCreateBrowserMsgSelectorTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create QueueBrowser with closed session.");
            try {
                QueueBrowser queueBrowser = this.tool.getDefaultQueueSession().createBrowser(this.tool.getDefaultQueue(), "TEST = 'test'");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateBrowserMsgSelectorTest");
        }
    }

    public void closedQueueSessionCreateQueueTest() throws Exception {
        String testName = "closedQueueSessionCreateQueueTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create queue with closed session.");
            try {
                Queue queue = this.tool.getDefaultQueueSession().createQueue(testName);
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateQueueTest");
        }
    }

    public void closedQueueSessionCreateReceiverTest() throws Exception {
        String testName = "closedQueueSessionCreateReceiverTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create Receiver with closed session.");
            try {
                QueueReceiver queueReceiver = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateReceiverTest");
        }
    }

    public void closedQueueSessionCreateReceiverMsgSelectorTest() throws Exception {
        String testName = "closedQueueSessionCreateReceiverMsgSelectorTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create Receiver with closed session.");
            try {
                QueueReceiver queueReceiver = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue(), "TEST = 'test'");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateReceiverMsgSelectorTest");
        }
    }

    public void closedQueueSessionCreateSenderTest() throws Exception {
        String testName = "closedQueueSessionCreateSenderTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create Sender with closed session.");
            try {
                QueueSender queueSender = this.tool.getDefaultQueueSession().createSender(this.tool.getDefaultQueue());
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateSenderTest");
        }
    }

    public void closedQueueSessionCreateTempQueueTest() throws Exception {
        String testName = "closedQueueSessionCreateTempQueueTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create TemporaryQueue with closed session.");
            try {
                TemporaryQueue temporaryQueue = this.tool.getDefaultQueueSession().createTemporaryQueue();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateTempQueueTest");
        }
    }

    public void closedQueueSessionCreateMessageTest() throws Exception {
        String testName = "closedQueueSessionCreateMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create message with closed session.");
            try {
                Message message = this.tool.getDefaultQueueSession().createMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateMessageTest");
        }
    }

    public void closedQueueSessionCreateBytesMessageTest() throws Exception {
        String testName = "closedQueueSessionCreateBytesMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create BytesMessage with closed session.");
            try {
                BytesMessage bytesMessage = this.tool.getDefaultQueueSession().createBytesMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateBytesMessageTest");
        }
    }

    public void closedQueueSessionCreateMapMessageTest() throws Exception {
        String testName = "closedQueueSessionCreateMapMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create MapMessage with closed session.");
            try {
                MapMessage mapMessage = this.tool.getDefaultQueueSession().createMapMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateMapMessageTest");
        }
    }

    public void closedQueueSessionCreateObjectMessageTest() throws Exception {
        String testName = "closedQueueSessionCreateObjectMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create ObjectMessage with closed session.");
            try {
                ObjectMessage m = this.tool.getDefaultQueueSession().createObjectMessage();
                if (m != null) {
                    TestUtil.logTrace((String)("m=" + m));
                }
                TestUtil.logTrace((String)"FAIL: expected IllegalStateException");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateObjectMessageTest");
        }
    }

    public void closedQueueSessionCreateObject2MessageTest() throws Exception {
        String testName = "closedQueueSessionCreateObject2MessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create ObjectMessage(object) with closed session.");
            try {
                String s = "Simple object";
                ObjectMessage m = this.tool.getDefaultQueueSession().createObjectMessage((Serializable)((Object)s));
                if (m != null) {
                    TestUtil.logTrace((String)("m=" + m));
                }
                TestUtil.logTrace((String)"FAIL: expected IllegalStateException");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateObject2MessageTest");
        }
    }

    public void closedQueueSessionCreateStreamMessageTest() throws Exception {
        String testName = "closedQueueSessionCreateStreamMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create StreamMessage with closed session.");
            try {
                StreamMessage streamMessage = this.tool.getDefaultQueueSession().createStreamMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateStreamMessageTest");
        }
    }

    public void closedQueueSessionCreateTextMessageTest() throws Exception {
        String testName = "closedQueueSessionCreateTextMessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create TextMessage with closed session.");
            try {
                TextMessage textMessage = this.tool.getDefaultQueueSession().createTextMessage();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateTextMessageTest");
        }
    }

    public void closedQueueSessionCreateText2MessageTest() throws Exception {
        String testName = "closedQueueSessionCreateText2MessageTest";
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logMsg("Try to create TextMessage with closed session.");
            try {
                TextMessage textMessage = this.tool.getDefaultQueueSession().createTextMessage("test message");
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionCreateText2MessageTest");
        }
    }

    public void closedQueueSessionReceiverCloseTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call close again");
            this.tool.getDefaultQueueReceiver().close();
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionReceiverCloseTest", e);
        }
    }

    public void closedQueueSessionGetMessageSelectorTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getMessageSelector");
            try {
                String foo = this.tool.getDefaultQueueReceiver().getMessageSelector();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionGetMessageSelectorTest", e);
        }
    }

    public void closedQueueSessionReceiveTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call receive");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receive();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionReceiveTest", e);
        }
    }

    public void closedQueueSessionReceiveTimeoutTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call receive(timeout)");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receive(this.timeout);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionReceiveTimeoutTest", e);
        }
    }

    public void closedQueueSessionReceiveNoWaitTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call receiveNoWait");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receiveNoWait();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionReceiveNoWaitTest", e);
        }
    }

    public void closedQueueSessionReceiverGetQueueTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getQueue");
            try {
                Queue foo = this.tool.getDefaultQueueReceiver().getQueue();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionReceiverGetQueueTest", e);
        }
    }

    public void closedQueueSessionSenderCloseTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call close again");
            this.tool.getDefaultQueueSender().close();
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSenderCloseTest", e);
        }
    }

    public void closedQueueSessionGetDeliveryModeTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getDeliveryMode");
            try {
                int foo = this.tool.getDefaultQueueSender().getDeliveryMode();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionGetDeliveryModeTest", e);
        }
    }

    public void closedQueueSessionGetDisableMessageIDTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getDisableMessageID");
            try {
                boolean foo = this.tool.getDefaultQueueSender().getDisableMessageID();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionGetDisableMessageIDTest", e);
        }
    }

    public void closedQueueSessionGetDisableMessageTimestampTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getDisableMessageTimestamp");
            try {
                boolean foo = this.tool.getDefaultQueueSender().getDisableMessageTimestamp();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionGetDisableMessageTimestampTest", e);
        }
    }

    public void closedQueueSessionGetPriorityTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getPriority");
            try {
                int foo = this.tool.getDefaultQueueSender().getPriority();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionGetPriorityTest", e);
        }
    }

    public void closedQueueSessionGetTimeToLiveTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getTimeToLive");
            try {
                long foo = this.tool.getDefaultQueueSender().getTimeToLive();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionGetTimeToLiveTest", e);
        }
    }

    public void closedQueueSessionSetDeliveryModeTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call setDeliveryMode");
            try {
                this.tool.getDefaultQueueSender().setDeliveryMode(2);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSetDeliveryModeTest", e);
        }
    }

    public void closedQueueSessionSetDisableMessageIDTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call setDisableMessageID");
            try {
                this.tool.getDefaultQueueSender().setDisableMessageID(true);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSetDisableMessageIDTest", e);
        }
    }

    public void closedQueueSessionSetDisableMessageTimestampTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call setDisableMessageTimestamp");
            try {
                this.tool.getDefaultQueueSender().setDisableMessageTimestamp(true);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSetDisableMessageTimestampTest", e);
        }
    }

    public void closedQueueSessionSetPriorityTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call setPriority");
            try {
                this.tool.getDefaultQueueSender().setPriority(4);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSetPriorityTest", e);
        }
    }

    public void closedQueueSessionSetTimeToLiveTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call setTimeToLive");
            try {
                this.tool.getDefaultQueueSender().setTimeToLive(0L);
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSetTimeToLiveTest", e);
        }
    }

    public void closedQueueSessionSenderGetQueueTest() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call getQueue");
            try {
                Queue foo = this.tool.getDefaultQueueSender().getQueue();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSenderGetQueueTest", e);
        }
    }

    public void closedQueueSessionSend1Test() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call send(Message)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSend1Test", e);
        }
    }

    public void closedQueueSessionSend2Test() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call send(Message,int,int,long)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl(), 2, 4, 0L);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSend2Test", e);
        }
    }

    public void closedQueueSessionSend3Test() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call send(Queue,Message)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl());
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSend3Test", e);
        }
    }

    public void closedQueueSessionSend4Test() throws Exception {
        try {
            this.createAndCloseSession(0, this.user, this.password);
            this.logTrace("Try to call send(Queue,Message,int,int,long)");
            try {
                this.tool.getDefaultQueueSender().send((Message)new MessageTestImpl(), 2, 4, 0L);
                this.logErr("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                return;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            throw new Exception("Error: failures occurred during tests");
        }
        catch (Exception e) {
            throw new Exception("closedQueueSessionSend4Test", e);
        }
    }

    public void closedQueueSessionRecoverTest() throws Exception {
        try {
            this.createAndCloseSession(2, this.user, this.password);
            this.logMsg("Try to call recover() with closed session.");
            try {
                this.tool.getDefaultQueueSession().recover();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception("closedQueueSessionRecoverTest");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"closedQueueSessionRecoverTest failed: ", (Throwable)e);
            throw new Exception("closedQueueSessionRecoverTest", e);
        }
    }

    public void closedSessionRecoverTest() throws Exception {
        String testName = "closedSessionRecoverTest";
        try {
            this.createAndCloseSession(15, this.user, this.password);
            this.logMsg("Try to call recover() with closed session.");
            try {
                this.tool.getDefaultSession().recover();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logErr((String)(testName + " failed: "), (Throwable)e);
            throw new Exception(testName);
        }
    }

    public void closedQueueSessionCommitTest() throws Exception {
        String testName = "closedQueueSessionCommitTest";
        try {
            this.createAndCloseSession(2, this.user, this.password);
            this.logMsg("Try to call commit with closed session.");
            try {
                this.tool.getDefaultQueueSession().commit();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logErr((String)(testName + " failed: "), (Throwable)e);
            throw new Exception(testName);
        }
    }

    public void closedQueueSessionGetTransactedTest() throws Exception {
        String testName = "closedQueueSessionGetTransactedTest";
        try {
            this.createAndCloseSession(2, this.user, this.password);
            this.logMsg("Try to call getTransacted() with closed session.");
            try {
                boolean bl = this.tool.getDefaultQueueSession().getTransacted();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logErr((String)(testName + " failed: "), (Throwable)e);
            throw new Exception(testName);
        }
    }

    public void closedQueueSessionRollbackTest() throws Exception {
        String testName = "closedQueueSessionRollbackTest";
        try {
            this.createAndCloseSession(2, this.user, this.password);
            this.logMsg("Try to call rollback() with closed session.");
            try {
                this.tool.getDefaultQueueSession().rollback();
            }
            catch (IllegalStateException ise) {
                this.logMsg("Caught expected exception");
                return;
            }
            throw new Exception(testName);
        }
        catch (Exception e) {
            TestUtil.logTrace((String)(" " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueSessionRollbackTest");
        }
    }
}

