/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.callStmt.callStmt20;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class callStmtClient20
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.callStmt.callStmt20";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private DataSource ds1 = null;
    private csSchema csSch = null;
    private rsSchema rsSch = null;
    private String drManager = null;
    private Properties sqlp = null;
    private CallableStatement cstmt = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        callStmtClient20 theTests = new callStmtClient20();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.rsSch = new rsSchema();
                this.csSch = new csSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter09() throws Exception {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sMaxRealVal = this.rsSch.extractVal("Real_Tab", 1, this.sqlp, this.conn);
            float maxRealVal = Float.parseFloat(sMaxRealVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Real_Io_Null(?)}");
            this.cstmt.setFloat(1, maxRealVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getFloat method");
            float oRetVal = this.cstmt.getFloat(1);
            this.msg.addOutputMsg("" + maxRealVal, "" + oRetVal);
            if (maxRealVal == oRetVal) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter10() throws Exception {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sMinRealVal = this.rsSch.extractVal("Real_Tab", 2, this.sqlp, this.conn);
            float minRealVal = Float.parseFloat(sMinRealVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Real_Io_Max(?)}");
            this.cstmt.setFloat(1, minRealVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getFloat method");
            float oRetVal = this.cstmt.getFloat(1);
            this.msg.addOutputMsg("" + minRealVal, "" + oRetVal);
            if (minRealVal == oRetVal) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testRegisterOutParameter11() throws Exception {
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            boolean maxBooleanVal = this.rsSch.extractValAsBoolVal("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bit_Io_Null(?)}");
            this.cstmt.setBoolean(1, maxBooleanVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getBoolean method");
            boolean oRetVal = this.cstmt.getBoolean(1);
            this.msg.addOutputMsg("" + maxBooleanVal, "" + oRetVal);
            if (maxBooleanVal == oRetVal) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testRegisterOutParameter12() throws Exception {
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            boolean minBooleanVal = this.rsSch.extractValAsBoolVal("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bit_Io_Max(?)}");
            this.cstmt.setBoolean(1, minBooleanVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getBoolean method");
            boolean oRetVal = this.cstmt.getBoolean(1);
            this.msg.addOutputMsg("" + minBooleanVal, "" + oRetVal);
            if (minBooleanVal == oRetVal) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter13() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sMaxByteVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            short maxByteVal = Short.parseShort(sMaxByteVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_Io_Null(?)}");
            this.cstmt.setShort(1, maxByteVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getShort method");
            short oRetVal = this.cstmt.getShort(1);
            this.msg.addOutputMsg("" + maxByteVal, "" + oRetVal);
            if (maxByteVal == oRetVal) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter14() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sMinByteVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            short minByteVal = Short.parseShort(sMinByteVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_Io_Max(?)}");
            this.cstmt.setShort(1, minByteVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getShort method");
            short oRetVal = this.cstmt.getShort(1);
            this.msg.addOutputMsg("" + minByteVal, "" + oRetVal);
            if (minByteVal == oRetVal) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter15() throws Exception {
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String sMaxShortVal = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            byte maxShortVal = Byte.parseByte(sMaxShortVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_Io_Null(?)}");
            this.cstmt.setByte(1, maxShortVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getByte method");
            byte oRetVal = this.cstmt.getByte(1);
            this.msg.addOutputMsg("" + maxShortVal, "" + oRetVal);
            if (maxShortVal == oRetVal) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter16() throws Exception {
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String sMinShortVal = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            byte minShortVal = Byte.parseByte(sMinShortVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_Io_Max(?)}");
            this.cstmt.setByte(1, minShortVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getShort method");
            byte oRetVal = this.cstmt.getByte(1);
            this.msg.addOutputMsg("" + minShortVal, "" + oRetVal);
            if (minShortVal == oRetVal) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter17() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sMaxIntegerVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            int maxIntegerVal = Integer.parseInt(sMaxIntegerVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_Io_Null(?)}");
            this.cstmt.setInt(1, maxIntegerVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getInt method");
            int oRetVal = this.cstmt.getInt(1);
            this.msg.addOutputMsg("" + maxIntegerVal, "" + oRetVal);
            if (maxIntegerVal == oRetVal) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter18() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sMinIntegerVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            int minIntegerVal = Integer.parseInt(sMinIntegerVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_Io_Max(?)}");
            this.cstmt.setInt(1, minIntegerVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getInt method");
            int oRetVal = this.cstmt.getInt(1);
            this.msg.addOutputMsg("" + minIntegerVal, "" + oRetVal);
            if (minIntegerVal == oRetVal) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter19() throws Exception {
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sMaxLongVal = this.rsSch.extractVal("Bigint_Tab", 1, this.sqlp, this.conn);
            long maxLongVal = Long.parseLong(sMaxLongVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_Io_Null(?)}");
            this.cstmt.setLong(1, maxLongVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getLong method");
            long oRetVal = this.cstmt.getLong(1);
            this.msg.addOutputMsg("" + maxLongVal, "" + oRetVal);
            if (maxLongVal == oRetVal) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter20() throws Exception {
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sMinLongVal = this.rsSch.extractVal("Bigint_Tab", 2, this.sqlp, this.conn);
            long minLongVal = Long.parseLong(sMinLongVal);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_Io_Max(?)}");
            this.cstmt.setLong(1, minLongVal);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getLong method");
            long oRetVal = this.cstmt.getLong(1);
            this.msg.addOutputMsg("" + minLongVal, "" + oRetVal);
            if (minLongVal == oRetVal) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter21() throws Exception {
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String sCoffeeName = this.rsSch.extractVal("Char_Tab", 1, this.sqlp, this.conn);
            sCoffeeName = sCoffeeName.substring(1, sCoffeeName.length() - 1);
            sCoffeeName = sCoffeeName.trim();
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_Io_Null(?)}");
            this.cstmt.setString(1, sCoffeeName);
            this.msg.setMsg("register the output parameters");
            int arraySize = sCoffeeName.length();
            this.cstmt.registerOutParameter(1, 1, arraySize);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getString method");
            String oRetVal = this.cstmt.getString(1);
            oRetVal = oRetVal.trim();
            this.msg.addOutputMsg(sCoffeeName, oRetVal);
            if (sCoffeeName.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testRegisterOutParameter22() throws Exception {
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String sCoffeeName = this.rsSch.extractVal("Varchar_Tab", 1, this.sqlp, this.conn);
            sCoffeeName = sCoffeeName.substring(1, sCoffeeName.length() - 1);
            sCoffeeName = sCoffeeName.trim();
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_Io_Null(?)}");
            this.cstmt.setString(1, sCoffeeName);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 12);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getString method");
            String oRetVal = this.cstmt.getString(1);
            oRetVal.trim();
            this.msg.addOutputMsg(sCoffeeName, oRetVal);
            if (sCoffeeName.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testRegisterOutParameter23() throws Exception {
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            String sCoffeeName = this.rsSch.extractVal("Longvarchar_Tab", 1, this.sqlp, this.conn);
            sCoffeeName = sCoffeeName.substring(1, sCoffeeName.length() - 1);
            sCoffeeName = sCoffeeName.trim();
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Lvarchar_Io_Null(?)}");
            this.cstmt.setString(1, sCoffeeName);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getString method");
            String oRetVal = this.cstmt.getString(1);
            oRetVal.trim();
            this.msg.addOutputMsg(sCoffeeName, oRetVal);
            if (sCoffeeName.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter24() throws Exception {
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            String sMfgDate = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            sMfgDate = sMfgDate.substring(sMfgDate.indexOf(39) + 1, sMfgDate.lastIndexOf(39));
            Date mfgDate = Date.valueOf(sMfgDate);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Date_Io_Null(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 91);
            this.cstmt.setDate(1, mfgDate);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getDate method");
            Date objRetVal = this.cstmt.getDate(1);
            long lDate = objRetVal.getTime();
            Date oRetVal = new Date(lDate);
            this.msg.addOutputMsg(String.valueOf(mfgDate), String.valueOf(oRetVal));
            if (mfgDate.compareTo(oRetVal) == 0) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter25() throws Exception {
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            String sBrkTime = this.rsSch.extractVal("Time_Tab", 1, this.sqlp, this.conn);
            sBrkTime = sBrkTime.substring(sBrkTime.indexOf(39) + 1, sBrkTime.lastIndexOf(39));
            Time brkTime = Time.valueOf(sBrkTime);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Time_Io_Null(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 92);
            this.cstmt.setTime(1, brkTime);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getTime method");
            Time objRetVal = this.cstmt.getTime(1);
            long lDate = objRetVal.getTime();
            Time oRetVal = new Time(lDate);
            this.msg.addOutputMsg(String.valueOf(brkTime), String.valueOf(oRetVal));
            if (brkTime.toString().trim().equals(oRetVal.toString().trim())) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter26() throws Exception {
        String sInTime = null;
        Timestamp inTimestamp = null;
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            sInTime = this.rsSch.extractVal("Timestamp_Tab", 1, this.sqlp, this.conn);
            sInTime = sInTime.substring(sInTime.indexOf(39) + 1, sInTime.lastIndexOf(39));
            inTimestamp = Timestamp.valueOf(sInTime);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Timestamp_Io_Null(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 93);
            this.cstmt.setTimestamp(1, inTimestamp);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getTimestamp method");
            Timestamp oRetVal = this.cstmt.getTimestamp(1);
            this.msg.addOutputMsg(String.valueOf(inTimestamp), String.valueOf(oRetVal));
            if (inTimestamp.equals(oRetVal)) {
                this.msg.setMsg("registerOutParameter registers the OUT parameter");
            } else {
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter27() throws Exception {
        byte[] retByteArr = null;
        boolean byteArrFlag = false;
        String binarySize = null;
        try {
            this.rsSch.createTab("Binary_Tab", this.sqlp, this.conn);
            binarySize = this.sqlp.getProperty("binarySize");
            this.msg.setMsg("Binary Table Size : " + binarySize);
            int bytearrsize = Integer.parseInt(binarySize);
            this.msg.setMsg("Binary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Binary_Proc_Io(?)}");
            this.cstmt.setBytes(1, bytearr);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -2);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getBytes method");
            retByteArr = this.cstmt.getBytes(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(retByteArr[i]));
                if (retByteArr[i] == bytearr[i]) continue;
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.setMsg("registerOutParameter registers the OUT parameter");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Binary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterOutParameter28() throws Exception {
        byte[] retByteArr = null;
        boolean byteArrFlag = false;
        String varbinarySize = null;
        try {
            this.rsSch.createTab("Varbinary_Tab", this.sqlp, this.conn);
            varbinarySize = this.sqlp.getProperty("varbinarySize");
            this.msg.setMsg("Varbinary Table Size : " + varbinarySize);
            int bytearrsize = Integer.parseInt(varbinarySize);
            this.msg.setMsg("Varbinary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varbinary_Proc_Io(?)}");
            this.cstmt.setBytes(1, bytearr);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -3);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getBytes method");
            retByteArr = this.cstmt.getBytes(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(retByteArr[i]));
                if (retByteArr[i] == bytearr[i]) continue;
                this.msg.printTestError("registerOutParameter does not register the OUT parameter", "test registerOutParameter Failed");
            }
            this.msg.setMsg("registerOutParameter registers the OUT parameter");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to registerOutParameter is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to registerOutParameter is Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

