/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.api.admin.progress.JobInfos;
import org.jvnet.hk2.annotations.Contract;

@Contract
public interface JobManager<T extends Job> {
    public String getNewId();

    public void registerJob(T var1) throws IllegalArgumentException;

    public Iterator<T> getJobs();

    public T get(String var1);

    public void purgeJob(String var1);

    public JobInfos getCompletedJobs(File var1);

    public JobInfo getCompletedJobForId(String var1, File var2);

    public JobInfos purgeCompletedJobForId(JobInfo var1);

    public void checkpoint(AdminCommand var1, AdminCommandContext var2) throws IOException;

    public void checkpoint(AdminCommandContext var1, Serializable var2) throws IOException;

    public T loadCheckpointData(String var1) throws IOException, ClassNotFoundException;

    public T createJob(String var1, String var2, Subject var3, boolean var4, ParameterMap var5, ActionReport var6);

    public void start(AsyncAdminCommandExecution var1);

    @FunctionalInterface
    public static interface AsyncAdminCommandExecution
    extends Runnable {
        public static final System.Logger LOG = System.getLogger(AsyncAdminCommandExecution.class.getName());

        public void execute();

        @Override
        default public void run() {
            try {
                LOG.log(System.Logger.Level.TRACE, () -> "Command execution started. " + String.valueOf(this));
                this.execute();
                LOG.log(System.Logger.Level.TRACE, () -> "Command execution succeeded. " + String.valueOf(this));
            }
            catch (Throwable t) {
                LOG.log(System.Logger.Level.TRACE, () -> "Command execution failed. " + String.valueOf(this), t);
                throw t;
            }
        }
    }

    public static class Checkpoint<T extends Job>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private T job;
        private AdminCommand command;
        private AdminCommandContext context;

        public Checkpoint(T job, AdminCommand command, AdminCommandContext context) {
            this.job = job;
            this.command = command;
            this.context = context;
        }

        public T getJob() {
            return this.job;
        }

        public AdminCommand getCommand() {
            return this.command;
        }

        public AdminCommandContext getContext() {
            return this.context;
        }
    }
}

